/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.base.Predicate;
import com.google.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.ui.editor.findrefs.EditorResourceAccess;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceSearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceQuery
implements ISearchQuery {
    @Inject
    private IReferenceFinder finder;
    @Inject
    protected EditorResourceAccess localContextProvider;
    private ReferenceSearchResult searchResult;
    private String label;
    private Iterable<URI> targetURIs;
    private Predicate<IReferenceDescription> filter;

    public void init(Iterable<URI> targetURIs, Predicate<IReferenceDescription> filter, String label) {
        this.targetURIs = targetURIs;
        this.label = label;
        this.filter = filter;
        this.searchResult = this.createSearchResult();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return this.label;
    }

    public Predicate<IReferenceDescription> getFilter() {
        return this.filter;
    }

    public ISearchResult getSearchResult() {
        return this.searchResult;
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.searchResult.reset();
        this.finder.findAllReferences(this.targetURIs, this.localContextProvider, this.searchResult, monitor);
        this.searchResult.finish();
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    protected ReferenceSearchResult createSearchResult() {
        return new ReferenceSearchResult(this);
    }
}

