/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.linking.LinkingScopeProviderBinding;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.imports.NonOverridableTypesProvider;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.imports.TypeUsage;
import org.eclipse.xtext.xbase.imports.TypeUsages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictResolver {
    @Inject
    private IImportsConfiguration config;
    @Inject
    private RewritableImportSection.Factory importSectionFactory;
    @Inject
    @LinkingScopeProviderBinding
    private IScopeProvider scopeProvider;
    @Inject
    private IndexedJvmTypeAccess indexedJvmTypeAccess;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public Map<String, JvmDeclaredType> resolveConflicts(TypeUsages usages, NonOverridableTypesProvider nonOverridableTypesProvider, XtextResource resource) {
        RewritableImportSection importSection = this.importSectionFactory.parse(resource);
        Multimap<String, JvmDeclaredType> locallyDefinedTypes = this.getLocallyDefinedTypes(resource);
        LinkedHashMap result = Maps.newLinkedHashMap();
        Multimap<String, JvmDeclaredType> simpleName2Types = usages.getSimpleName2Types();
        for (String simpleName : simpleName2Types.keySet()) {
            Collection types = simpleName2Types.get((Object)simpleName);
            Collection localTypes = locallyDefinedTypes.get((Object)simpleName);
            if (!localTypes.isEmpty() || this.isConflictsWithNonOverridableTypes(types, usages, nonOverridableTypesProvider, simpleName)) {
                JvmDeclaredType singleLocalType = localTypes.size() == 1 ? (JvmDeclaredType)localTypes.iterator().next() : null;
                for (JvmDeclaredType type : types) {
                    if (type == singleLocalType) {
                        result.put(type.getSimpleName(), type);
                        continue;
                    }
                    result.put(type.getQualifiedName('.'), type);
                }
                continue;
            }
            if (this.isConflictsWithNonOverridableTypes(types, usages, nonOverridableTypesProvider, simpleName)) {
                JvmDeclaredType type;
                type = types.iterator();
                while (type.hasNext()) {
                    JvmDeclaredType type2 = (JvmDeclaredType)type.next();
                    result.put(type2.getQualifiedName('.'), type2);
                }
                continue;
            }
            if (types.size() == 1) {
                result.put(simpleName, (JvmDeclaredType)types.iterator().next());
                continue;
            }
            JvmDeclaredType bestMatch = this.findBestMatch(types, usages, importSection);
            for (JvmDeclaredType type : types) {
                if (type == bestMatch) {
                    result.put(simpleName, type);
                    continue;
                }
                result.put(type.getQualifiedName('.'), type);
            }
        }
        return result;
    }

    protected Multimap<String, JvmDeclaredType> getLocallyDefinedTypes(XtextResource resource) {
        HashMultimap result = HashMultimap.create();
        for (JvmDeclaredType type : this.config.getLocallyDefinedTypes(resource)) {
            String packageName = type.getPackageName();
            if (Strings.isEmpty((String)packageName)) {
                result.put((Object)type.getQualifiedName('.'), (Object)type);
                continue;
            }
            result.put((Object)type.getQualifiedName('.').substring(packageName.length() + 1), (Object)type);
        }
        return result;
    }

    protected boolean isConflictsWithNonOverridableTypes(Iterable<JvmDeclaredType> types, TypeUsages usages, NonOverridableTypesProvider nonOverridableTypesProvider, String simpleName) {
        for (JvmDeclaredType type : types) {
            for (TypeUsage usage : usages.getUsages(type)) {
                QualifiedName qualifiedName;
                EObject indexedJvmType;
                JvmIdentifiableElement visibleType = nonOverridableTypesProvider.getVisibleType(usage.getContext(), simpleName);
                if (visibleType != null && !visibleType.equals(type)) {
                    return true;
                }
                String contextPackage = usage.getContextPackageName();
                if (Strings.isEmpty((String)contextPackage) || (indexedJvmType = this.indexedJvmTypeAccess.getIndexedJvmType(qualifiedName = this.qualifiedNameConverter.toQualifiedName(String.valueOf(contextPackage) + "." + simpleName), null, usage.getContext().eResource().getResourceSet())) == null || indexedJvmType == type) continue;
                return true;
            }
        }
        return false;
    }

    protected JvmDeclaredType findBestMatch(Collection<JvmDeclaredType> types, TypeUsages usages, RewritableImportSection importSection) {
        Iterator<JvmDeclaredType> iterator = types.iterator();
        JvmDeclaredType currentBestMatch = iterator.next();
        while (iterator.hasNext()) {
            JvmDeclaredType nextType = iterator.next();
            if (!this.isBetter(nextType, currentBestMatch, usages, importSection)) continue;
            currentBestMatch = nextType;
        }
        return currentBestMatch;
    }

    protected boolean isBetter(JvmDeclaredType candidate, JvmDeclaredType currentBestMatch, TypeUsages usages, RewritableImportSection importSection) {
        if (importSection.getImportedType(candidate.getSimpleName()) == candidate && importSection.getImportedType(currentBestMatch.getSimpleName()) != currentBestMatch) {
            return true;
        }
        return Iterables.size(usages.getUsages(candidate)) > Iterables.size(usages.getUsages(currentBestMatch));
    }
}

