/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.editor;

import com.google.inject.Inject;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceForStorageProvider;
import org.eclipse.xtext.ui.editor.XtextEditorInfo;
import org.eclipse.xtext.xbase.ui.editor.StacktraceBasedEditorDecider;
import org.eclipse.xtext.xbase.ui.editor.XbaseEditor;
import org.eclipse.xtext.xbase.ui.editor.XbaseEditorInputRedirector;

public class JavaEditorInputMatcher
implements IEditorMatchingStrategy {
    private static final Logger logger = Logger.getLogger(JavaEditorInputMatcher.class);
    @Inject
    private ITraceForStorageProvider traceInformation;
    @Inject
    private XtextEditorInfo editorInfo;
    @Inject
    private StacktraceBasedEditorDecider decisions;
    @Inject
    private XbaseEditorInputRedirector editorInputRedirector;

    public boolean matches(IEditorReference editorRef, IEditorInput inputToCheck) {
        ITrace traceToSource;
        IResource currentResource;
        IFile newResource;
        block12: {
            IEditorInput currentInput;
            block11: {
                IEditorInput newInput;
                block10: {
                    block9: {
                        block8: {
                            if (this.editorInfo.getEditorId().equals(editorRef.getId())) break block8;
                            return false;
                        }
                        newInput = this.editorInputRedirector.findOriginalSourceForOuputFolderCopy(inputToCheck);
                        currentInput = editorRef.getEditorInput();
                        if (!newInput.equals(currentInput)) break block9;
                        return true;
                    }
                    if (this.decisions.decideAccordingToCaller() != StacktraceBasedEditorDecider.Decision.FORCE_JAVA) break block10;
                    return false;
                }
                newResource = ResourceUtil.getFile((IEditorInput)newInput);
                if (newResource != null) break block11;
                return false;
            }
            currentResource = ResourceUtil.getResource((IEditorInput)currentInput);
            traceToSource = this.traceInformation.getTraceToSource((IStorage)newResource);
            if (traceToSource != null) break block12;
            return false;
        }
        try {
            IEditorPart existingEditor;
            if (this.isCurrentResource(currentResource, traceToSource) && (existingEditor = editorRef.getEditor(true)) instanceof XbaseEditor) {
                ((XbaseEditor)existingEditor).markNextSelectionAsJavaOffset((IResource)newResource);
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    protected boolean isCurrentResource(IResource currentResource, ITrace traceToSource) {
        Iterator iterator = traceToSource.getAllAssociatedLocations().iterator();
        if (!iterator.hasNext()) {
            return false;
        }
        IStorage storage = ((ILocationInResource)iterator.next()).getStorage();
        return currentResource.equals((Object)storage);
    }
}

