/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.reconciler;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.ContentAssistantFacade;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension4;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.IXtextDocumentContentObserver;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.ui.editor.reconciler.Messages;
import org.eclipse.xtext.ui.editor.reconciler.ReplaceRegion;
import org.eclipse.xtext.ui.editor.reconciler.XtextDocumentReconcileStrategy;
import org.eclipse.xtext.ui.editor.reconciler.XtextReconcilerUnitOfWork;

public class XtextReconciler
extends Job
implements IReconciler {
    private static final Logger log = Logger.getLogger(XtextReconciler.class);
    private boolean isInstalled;
    private boolean shouldInstallCompletionListener;
    private volatile boolean paused;
    private ITextViewer textViewer;
    private TextInputListener textInputListener;
    private final DocumentListener documentListener;
    private ReplaceRegion pendingReplaceRegion;
    private final Object pendingReplaceRegionLock;
    private int delay;
    private IReconcilingStrategy strategy;
    private boolean initalProcessDone;

    @Inject
    public XtextReconciler(XtextDocumentReconcileStrategy strategy) {
        super(Messages.XtextReconciler_JobName);
        this.setPriority(20);
        this.setSystem(true);
        this.isInstalled = false;
        this.documentListener = new DocumentListener();
        this.pendingReplaceRegionLock = new Object();
        this.paused = false;
        this.shouldInstallCompletionListener = false;
        this.setDelay(500);
        this.setReconcilingStrategy(strategy);
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return this.strategy;
    }

    public void setReconcilingStrategy(IReconcilingStrategy strategy) {
        this.strategy = strategy;
    }

    public void install(ITextViewer textViewer) {
        if (!this.isInstalled) {
            this.textViewer = textViewer;
            this.textInputListener = new TextInputListener();
            textViewer.addTextInputListener((ITextInputListener)this.textInputListener);
            this.handleInputDocumentChanged(null, textViewer.getDocument());
            if (textViewer instanceof ISourceViewerExtension4) {
                ContentAssistantFacade facade = ((ISourceViewerExtension4)textViewer).getContentAssistantFacade();
                if (facade == null) {
                    this.shouldInstallCompletionListener = true;
                } else {
                    facade.addCompletionListener((ICompletionListener)this.documentListener);
                }
                if (this.strategy instanceof ISourceViewerAware) {
                    ((ISourceViewerAware)this.strategy).setSourceViewer((ISourceViewer)textViewer);
                }
            }
            this.isInstalled = true;
        }
    }

    public void uninstall() {
        if (this.isInstalled) {
            this.textViewer.removeTextInputListener((ITextInputListener)this.textInputListener);
            this.isInstalled = false;
            if (this.documentListener != null && this.textViewer instanceof ISourceViewerExtension4) {
                ContentAssistantFacade facade = ((ISourceViewerExtension4)this.textViewer).getContentAssistantFacade();
                facade.removeCompletionListener((ICompletionListener)this.documentListener);
            }
        }
    }

    protected void handleInputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (this.shouldInstallCompletionListener) {
            ContentAssistantFacade facade = ((ISourceViewerExtension4)this.textViewer).getContentAssistantFacade();
            if (facade != null) {
                facade.addCompletionListener((ICompletionListener)this.documentListener);
            }
            this.shouldInstallCompletionListener = false;
        }
        if (oldInput instanceof IXtextDocument) {
            ((IXtextDocument)oldInput).removeXtextDocumentContentObserver(this.documentListener);
        }
        if (newInput instanceof IXtextDocument) {
            ((IXtextDocument)newInput).addXtextDocumentContentObserver(this.documentListener);
            IXtextDocument document = XtextDocumentUtil.get(this.textViewer);
            this.strategy.setDocument((IDocument)document);
            if (!this.initalProcessDone && this.strategy instanceof IReconcilingStrategyExtension) {
                this.initalProcessDone = true;
                IReconcilingStrategyExtension reconcilingStrategyExtension = (IReconcilingStrategyExtension)this.strategy;
                reconcilingStrategyExtension.initialReconcile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDocumentChanged(DocumentEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Reconciler cancelled");
        }
        this.cancel();
        ReplaceRegion newReplaceRegion = new ReplaceRegion(event.getOffset(), event.getLength(), event.getText());
        Object object = this.pendingReplaceRegionLock;
        synchronized (object) {
            if (this.pendingReplaceRegion != null) {
                this.pendingReplaceRegion.mergeWith(newReplaceRegion, event.getDocument());
            } else {
                this.pendingReplaceRegion = newReplaceRegion;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Reconciler scheduled with delay: " + this.delay), (Throwable)new Exception());
        }
        this.schedule(this.delay);
    }

    protected void pause() {
        this.paused = true;
    }

    protected void resume() {
        this.paused = false;
        this.schedule(this.delay);
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public boolean belongsTo(Object family) {
        return XtextReconciler.class.getName().equals(family);
    }

    protected IStatus run(IProgressMonitor monitor) {
        ReplaceRegion replaceRegionToBeProcessed;
        IXtextDocument document;
        if (monitor.isCanceled() || this.paused) {
            return Status.CANCEL_STATUS;
        }
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preparing reconciliation.");
        }
        if ((document = XtextDocumentUtil.get(this.textViewer)) != null && (replaceRegionToBeProcessed = this.getAndResetReplaceRegion()) != null) {
            if (this.strategy instanceof IReconcilingStrategyExtension) {
                ((IReconcilingStrategyExtension)this.strategy).setProgressMonitor(monitor);
            }
            this.strategy.reconcile((IRegion)replaceRegionToBeProcessed);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reconciliation finished. Time required: " + (System.currentTimeMillis() - start)));
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReplaceRegion getAndResetReplaceRegion() {
        ReplaceRegion replaceRegionToBeProcessed;
        Object object = this.pendingReplaceRegionLock;
        synchronized (object) {
            replaceRegionToBeProcessed = this.pendingReplaceRegion != null ? this.pendingReplaceRegion : null;
            this.pendingReplaceRegion = null;
        }
        return replaceRegionToBeProcessed;
    }

    protected class DocumentListener
    implements IXtextDocumentContentObserver,
    ICompletionListener {
        private volatile boolean sessionStarted = false;

        protected DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            XtextReconciler.this.handleDocumentChanged(event);
        }

        public void performNecessaryUpdates(IXtextDocumentContentObserver.Processor processor) {
            ReplaceRegion replaceRegionToBeProcessed;
            IXtextDocument document = XtextDocumentUtil.get(XtextReconciler.this.textViewer);
            if (document != null && !XtextReconciler.this.paused && (replaceRegionToBeProcessed = XtextReconciler.this.getAndResetReplaceRegion()) != null) {
                processor.process(new XtextReconcilerUnitOfWork((IRegion)replaceRegionToBeProcessed, document));
            }
            if (this.sessionStarted && !XtextReconciler.this.paused) {
                XtextReconciler.this.pause();
            }
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            this.sessionStarted = true;
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            this.sessionStarted = false;
            XtextReconciler.this.resume();
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }
    }

    protected class TextInputListener
    implements ITextInputListener {
        protected TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            XtextReconciler.this.handleInputDocumentChanged(oldInput, newInput);
        }
    }
}

