/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.conformance;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceResult;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceStrategy;
import org.eclipse.xtext.xbase.typesystem.references.CompoundTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class MultiTypeConformanceStrategy
extends TypeConformanceStrategy<CompoundTypeReference> {
    public MultiTypeConformanceStrategy(TypeConformanceComputer conformanceComputer) {
        super(conformanceComputer);
    }

    @Override
    protected TypeConformanceResult doVisitTypeReference(CompoundTypeReference left, LightweightTypeReference right, TypeConformanceComputationArgument.Internal<CompoundTypeReference> param) {
        for (LightweightTypeReference component : left.getMultiTypeComponents()) {
            TypeConformanceResult result = this.conformanceComputer.isConformant(component, right, param);
            if (result.isConformant()) continue;
            return result;
        }
        if (!left.getMultiTypeComponents().isEmpty()) {
            return TypeConformanceResult.create(param, ConformanceHint.SUCCESS);
        }
        return TypeConformanceResult.create(param, ConformanceHint.INCOMPATIBLE);
    }

    @Override
    protected TypeConformanceResult doVisitMultiTypeReference(CompoundTypeReference left, CompoundTypeReference right, TypeConformanceComputationArgument.Internal<CompoundTypeReference> param) {
        return this.doVisitTypeReference(left, (LightweightTypeReference)right, param);
    }
}

