/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.refactoring;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.refactoring.ui.DefaultRenameElementHandler;
import org.eclipse.xtext.ui.refactoring.ui.RefactoringWizardOpenOperation_NonForking;
import org.eclipse.xtext.ui.refactoring.ui.SyncUtil;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.ui.refactoring.ExpressionUtil;
import org.eclipse.xtext.xbase.ui.refactoring.ExtractVariableRefactoring;
import org.eclipse.xtext.xbase.ui.refactoring.ExtractVariableWizard;

public class ExtractVariableHandler
extends AbstractHandler {
    @Inject
    private SyncUtil syncUtil;
    @Inject
    ExpressionUtil expressionUtil;
    @Inject
    private Provider<ExtractVariableRefactoring> refactoringProvider;
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    protected static final Logger LOG = Logger.getLogger(DefaultRenameElementHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            this.syncUtil.totalSync(false);
            final XtextEditor editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event);
            if (editor != null) {
                final ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                final IXtextDocument document = editor.getDocument();
                document.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource resource) throws Exception {
                        ExtractVariableRefactoring introduceVariableRefactoring;
                        XExpression expression = ExtractVariableHandler.this.expressionUtil.findSelectedExpression(resource, selection);
                        if (expression != null && (introduceVariableRefactoring = (ExtractVariableRefactoring)((Object)ExtractVariableHandler.this.refactoringProvider.get())).initialize(document, expression)) {
                            ITextRegion region = ExtractVariableHandler.this.locationInFileProvider.getFullTextRegion((EObject)expression);
                            editor.selectAndReveal(region.getOffset(), region.getLength());
                            ExtractVariableWizard wizard = new ExtractVariableWizard(introduceVariableRefactoring);
                            RefactoringWizardOpenOperation_NonForking openOperation = new RefactoringWizardOpenOperation_NonForking((RefactoringWizard)wizard);
                            openOperation.run(editor.getSite().getShell(), "Extract Local Variable");
                        }
                    }
                });
            }
        }
        catch (Exception exc) {
            LOG.error((Object)"Error during refactoring", (Throwable)exc);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error during refactoring", (String)(String.valueOf(exc.getMessage()) + "\nSee log for details"));
        }
        return null;
    }
}

