/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableMemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ResolvedMethod;
import org.eclipse.xtend.lib.macro.declaration.ResolvedParameter;
import org.eclipse.xtend.lib.macro.declaration.ResolvedTypeParameter;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

@Beta
public class DelegateProcessor
implements TransformationParticipant<MutableMemberDeclaration> {
    public void doTransform(List<? extends MutableMemberDeclaration> elements, @Extension TransformationContext context) {
        final Util util = new Util(context);
        Procedures.Procedure1<MutableMemberDeclaration> _function = new Procedures.Procedure1<MutableMemberDeclaration>(){

            public void apply(final MutableMemberDeclaration it) {
                boolean _isValidDelegate = util.isValidDelegate((MemberDeclaration)it);
                if (_isValidDelegate) {
                    Set<ResolvedMethod> _methodsToImplement = util.getMethodsToImplement((MemberDeclaration)it);
                    Procedures.Procedure1<ResolvedMethod> _function = new Procedures.Procedure1<ResolvedMethod>(){

                        public void apply(ResolvedMethod method) {
                            util.implementMethod(it, method);
                        }
                    };
                    IterableExtensions.forEach(_methodsToImplement, (Procedures.Procedure1)_function);
                }
            }
        };
        IterableExtensions.forEach(elements, (Procedures.Procedure1)_function);
    }

    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;

        public Util(TransformationContext context) {
            this.context = context;
        }

        protected boolean _isValidDelegate(FieldDeclaration it) {
            boolean _areListedInterfacesValid;
            boolean _hasDelegationConflicts;
            boolean _not;
            boolean _and = false;
            boolean _and_1 = false;
            boolean _hasValidType = this.hasValidType((MemberDeclaration)it);
            _and_1 = !_hasValidType ? false : (_not = !(_hasDelegationConflicts = this.hasDelegationConflicts((MemberDeclaration)it)));
            _and = !_and_1 ? false : (_areListedInterfacesValid = this.areListedInterfacesValid((MemberDeclaration)it));
            return _and;
        }

        protected boolean _isValidDelegate(MethodDeclaration it) {
            boolean _areListedInterfacesValid;
            boolean _hasDelegationConflicts;
            boolean _not;
            boolean _hasValidSignature;
            boolean _and = false;
            boolean _and_1 = false;
            boolean _and_2 = false;
            boolean _hasValidType = this.hasValidType((MemberDeclaration)it);
            _and_2 = !_hasValidType ? false : (_hasValidSignature = this.hasValidSignature(it));
            _and_1 = !_and_2 ? false : (_not = !(_hasDelegationConflicts = this.hasDelegationConflicts((MemberDeclaration)it)));
            _and = !_and_1 ? false : (_areListedInterfacesValid = this.areListedInterfacesValid((MemberDeclaration)it));
            return _and;
        }

        public boolean hasValidType(MemberDeclaration it) {
            boolean _xifexpression = false;
            boolean _or = false;
            TypeReference _type = this.getType(it);
            boolean _equals = Objects.equal((Object)_type, null);
            if (_equals) {
                _or = true;
            } else {
                boolean _isInferred;
                TypeReference _type_1 = this.getType(it);
                _or = _isInferred = _type_1.isInferred();
            }
            if (_or) {
                boolean _xblockexpression = false;
                this.context.addError((Element)it, "Cannot use inferred types on delegates");
                _xifexpression = _xblockexpression = false;
            } else {
                _xifexpression = true;
            }
            return _xifexpression;
        }

        protected TypeReference _getType(FieldDeclaration it) {
            return it.getType();
        }

        protected TypeReference _getType(MethodDeclaration it) {
            return it.getReturnType();
        }

        public boolean hasValidSignature(MethodDeclaration it) {
            boolean _switchResult = false;
            Iterable _parameters = it.getParameters();
            Functions.Function1<ParameterDeclaration, TypeReference> _function = new Functions.Function1<ParameterDeclaration, TypeReference>(){

                public TypeReference apply(ParameterDeclaration it) {
                    return it.getType();
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_parameters, (Functions.Function1)_function);
            List _list = IterableExtensions.toList((Iterable)_map);
            boolean _matched = false;
            if (!_matched) {
                if (Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[0])))) {
                    _matched = true;
                }
                if (!_matched) {
                    TypeReference _string = this.context.getString();
                    if (Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_string})))) {
                        _matched = true;
                    }
                }
                if (!_matched) {
                    TypeReference _string_1 = this.context.getString();
                    TypeReference _newWildcardTypeReference = this.context.newWildcardTypeReference();
                    TypeReference _newTypeReference = this.context.newTypeReference(Class.class, new TypeReference[]{_newWildcardTypeReference});
                    TypeReference _newArrayTypeReference = this.context.newArrayTypeReference(_newTypeReference);
                    TypeReference _object = this.context.getObject();
                    TypeReference _newArrayTypeReference_1 = this.context.newArrayTypeReference(_object);
                    if (Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_string_1, _newArrayTypeReference, _newArrayTypeReference_1})))) {
                        _matched = true;
                    }
                }
                if (_matched) {
                    _switchResult = true;
                }
            }
            if (!_matched) {
                boolean _xblockexpression = false;
                this.context.addError((Element)it, "Not a valid delegate signature, use () or (String methodName) or (String methodName, Class<?>[] argumentTypes, Object[] arguments)");
                _switchResult = _xblockexpression = false;
            }
            return _switchResult;
        }

        public boolean hasDelegationConflicts(MemberDeclaration delegate) {
            boolean _xblockexpression = false;
            boolean conflict = false;
            Iterable<? extends MemberDeclaration> _otherDelegates = this.otherDelegates(delegate);
            for (MemberDeclaration memberDeclaration : _otherDelegates) {
                Set<TypeReference> otherInterfaces = this.getDelegatedInterfaces(memberDeclaration);
                Set<TypeReference> _delegatedInterfaces = this.getDelegatedInterfaces(delegate);
                for (TypeReference iface : _delegatedInterfaces) {
                    boolean _contains = otherInterfaces.contains(iface);
                    if (!_contains) continue;
                    conflict = true;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"The interface ");
                    String _simpleName = iface.getSimpleName();
                    _builder.append((Object)_simpleName, "");
                    _builder.append((Object)" is also implemented by the delegate ");
                    String _simpleName_1 = memberDeclaration.getSimpleName();
                    _builder.append((Object)_simpleName_1, "");
                    this.context.addError((Element)delegate, _builder.toString());
                }
            }
            _xblockexpression = conflict;
            return _xblockexpression;
        }

        public Iterable<? extends MemberDeclaration> otherDelegates(final MemberDeclaration delegate) {
            TypeDeclaration _declaringType = delegate.getDeclaringType();
            Iterable<? extends MemberDeclaration> _delegates = this.getDelegates(_declaringType);
            Functions.Function1<MemberDeclaration, Boolean> _function = new Functions.Function1<MemberDeclaration, Boolean>(){

                public Boolean apply(MemberDeclaration it) {
                    return !Objects.equal((Object)it, (Object)delegate);
                }
            };
            return IterableExtensions.filter(_delegates, (Functions.Function1)_function);
        }

        public boolean areListedInterfacesValid(MemberDeclaration delegate) {
            boolean _xblockexpression = false;
            TypeDeclaration _declaringType = delegate.getDeclaringType();
            TypeReference declaringType = this.context.newSelfTypeReference((Type)_declaringType);
            Set<TypeReference> interfacesOfDeclaringType = this.getImplementedInterfaces(declaringType);
            TypeReference _type = this.getType(delegate);
            Set<TypeReference> availableInterfaces = this.getImplementedInterfaces(_type);
            Set<TypeReference> listedInterfaces = this.listedInterfaces(delegate);
            boolean valid = true;
            for (final TypeReference iface : listedInterfaces) {
                Functions.Function1<TypeReference, Boolean> _function_1;
                boolean _exists_1;
                boolean _not_1;
                boolean _not;
                Functions.Function1<TypeReference, Boolean> _function = new Functions.Function1<TypeReference, Boolean>(){

                    public Boolean apply(TypeReference it) {
                        Type _type = it.getType();
                        Type _type_1 = iface.getType();
                        return Objects.equal((Object)_type, (Object)_type_1);
                    }
                };
                boolean _exists = IterableExtensions.exists(availableInterfaces, (Functions.Function1)_function);
                boolean bl = _not = !_exists;
                if (_not) {
                    StringConcatenation _builder = new StringConcatenation();
                    TypeReference _type_1 = this.getType(delegate);
                    String _simpleName = _type_1.getSimpleName();
                    _builder.append((Object)_simpleName, "");
                    _builder.append((Object)" does not implement ");
                    String _simpleName_1 = iface.getSimpleName();
                    _builder.append((Object)_simpleName_1, "");
                    this.context.addError((Element)delegate, _builder.toString());
                    valid = false;
                }
                boolean bl2 = _not_1 = !(_exists_1 = IterableExtensions.exists(interfacesOfDeclaringType, (Functions.Function1)(_function_1 = new Functions.Function1<TypeReference, Boolean>(){

                    public Boolean apply(TypeReference it) {
                        Type _type = it.getType();
                        Type _type_1 = iface.getType();
                        return Objects.equal((Object)_type, (Object)_type_1);
                    }
                })));
                if (!_not_1) continue;
                StringConcatenation _builder_1 = new StringConcatenation();
                String _simpleName_2 = declaringType.getSimpleName();
                _builder_1.append((Object)_simpleName_2, "");
                _builder_1.append((Object)" does not implement ");
                String _simpleName_3 = iface.getSimpleName();
                _builder_1.append((Object)_simpleName_3, "");
                this.context.addError((Element)delegate, _builder_1.toString());
                valid = false;
            }
            boolean _and = false;
            boolean _isEmpty = listedInterfaces.isEmpty();
            if (!_isEmpty) {
                _and = false;
            } else {
                boolean _isEmpty_1;
                Sets.SetView _intersection = Sets.intersection(interfacesOfDeclaringType, availableInterfaces);
                _and = _isEmpty_1 = _intersection.isEmpty();
            }
            if (_and) {
                StringConcatenation _builder = new StringConcatenation();
                TypeReference _type_1 = this.getType(delegate);
                String _simpleName = _type_1.getSimpleName();
                _builder.append((Object)_simpleName, "");
                _builder.append((Object)" and ");
                String _simpleName_1 = declaringType.getSimpleName();
                _builder.append((Object)_simpleName_1, "");
                _builder.append((Object)" have no interfaces in common");
                this.context.addError((Element)delegate, _builder.toString());
                valid = false;
            }
            _xblockexpression = valid;
            return _xblockexpression;
        }

        public Iterable<? extends MemberDeclaration> getDelegates(TypeDeclaration it) {
            Iterable _declaredMembers = it.getDeclaredMembers();
            Functions.Function1<MemberDeclaration, Boolean> _function = new Functions.Function1<MemberDeclaration, Boolean>(){

                public Boolean apply(MemberDeclaration it) {
                    Type _findTypeGlobally = Util.this.context.findTypeGlobally(Delegate.class);
                    AnnotationReference _findAnnotation = it.findAnnotation(_findTypeGlobally);
                    return _findAnnotation != null;
                }
            };
            return IterableExtensions.filter((Iterable)_declaredMembers, (Functions.Function1)_function);
        }

        public Set<TypeReference> listedInterfaces(MemberDeclaration it) {
            Type _findTypeGlobally = this.context.findTypeGlobally(Delegate.class);
            AnnotationReference _findAnnotation = it.findAnnotation(_findTypeGlobally);
            TypeReference[] _classArrayValue = _findAnnotation.getClassArrayValue("value");
            return IterableExtensions.toSet((Iterable)((Iterable)Conversions.doWrapArray((Object)_classArrayValue)));
        }

        public Set<TypeReference> getImplementedInterfaces(TypeReference it) {
            Set _xblockexpression = null;
            LinkedHashSet seen = CollectionLiterals.newLinkedHashSet((Object[])new TypeReference[0]);
            this.collectAllSuperTypes(it, seen);
            Functions.Function1<TypeReference, Boolean> _function = new Functions.Function1<TypeReference, Boolean>(){

                public Boolean apply(TypeReference it) {
                    Type _type = it.getType();
                    return _type instanceof InterfaceDeclaration;
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)seen, (Functions.Function1)_function);
            _xblockexpression = IterableExtensions.toSet((Iterable)_filter);
            return _xblockexpression;
        }

        private void collectAllSuperTypes(TypeReference it, final Set<TypeReference> seen) {
            boolean cycle;
            boolean _add = seen.add(it);
            boolean bl = cycle = !_add;
            if (cycle) {
                return;
            }
            Iterable _declaredSuperTypes = it.getDeclaredSuperTypes();
            Procedures.Procedure1<TypeReference> _function = new Procedures.Procedure1<TypeReference>(){

                public void apply(TypeReference it) {
                    Util.this.collectAllSuperTypes(it, seen);
                }
            };
            IterableExtensions.forEach((Iterable)_declaredSuperTypes, (Procedures.Procedure1)_function);
        }

        public Set<TypeReference> getDelegatedInterfaces(MemberDeclaration delegate) {
            Set _xblockexpression = null;
            TypeDeclaration _declaringType = delegate.getDeclaringType();
            TypeReference _newSelfTypeReference = this.context.newSelfTypeReference((Type)_declaringType);
            final Set<TypeReference> interfacesOfDeclaringType = this.getImplementedInterfaces(_newSelfTypeReference);
            final Set<TypeReference> listedInterfaces = this.listedInterfaces(delegate);
            TypeReference _type = this.getType(delegate);
            Set<TypeReference> availableInterfaces = this.getImplementedInterfaces(_type);
            Functions.Function1<TypeReference, Boolean> _function = new Functions.Function1<TypeReference, Boolean>(){

                public Boolean apply(final TypeReference iface) {
                    boolean _and = false;
                    boolean _contains = interfacesOfDeclaringType.contains(iface);
                    if (!_contains) {
                        _and = false;
                    } else {
                        boolean _or = false;
                        boolean _isEmpty = listedInterfaces.isEmpty();
                        if (_isEmpty) {
                            _or = true;
                        } else {
                            boolean _exists;
                            Functions.Function1<TypeReference, Boolean> _function = new Functions.Function1<TypeReference, Boolean>(){

                                public Boolean apply(TypeReference it) {
                                    return iface.isAssignableFrom(it);
                                }
                            };
                            _or = _exists = IterableExtensions.exists((Iterable)listedInterfaces, (Functions.Function1)_function);
                        }
                        _and = _or;
                    }
                    return _and;
                }
            };
            Iterable _filter = IterableExtensions.filter(availableInterfaces, (Functions.Function1)_function);
            _xblockexpression = IterableExtensions.toSet((Iterable)_filter);
            return _xblockexpression;
        }

        public Set<ResolvedMethod> getMethodsToImplement(final MemberDeclaration delegate) {
            Set<TypeReference> _delegatedInterfaces = this.getDelegatedInterfaces(delegate);
            Functions.Function1<TypeReference, Iterable<? extends ResolvedMethod>> _function = new Functions.Function1<TypeReference, Iterable<? extends ResolvedMethod>>(){

                public Iterable<? extends ResolvedMethod> apply(TypeReference it) {
                    return it.getDeclaredResolvedMethods();
                }
            };
            Iterable _map = IterableExtensions.map(_delegatedInterfaces, (Functions.Function1)_function);
            Iterable _flatten = Iterables.concat((Iterable)_map);
            Functions.Function1<ResolvedMethod, Boolean> _function_1 = new Functions.Function1<ResolvedMethod, Boolean>(){

                public Boolean apply(ResolvedMethod it) {
                    TypeDeclaration _declaringType = delegate.getDeclaringType();
                    MethodDeclaration _declaration = it.getDeclaration();
                    String _simpleName = _declaration.getSimpleName();
                    Iterable _resolvedParameters = it.getResolvedParameters();
                    Functions.Function1<ResolvedParameter, TypeReference> _function = new Functions.Function1<ResolvedParameter, TypeReference>(){

                        public TypeReference apply(ResolvedParameter it) {
                            return it.getResolvedType();
                        }
                    };
                    Iterable _map = IterableExtensions.map((Iterable)_resolvedParameters, (Functions.Function1)_function);
                    MethodDeclaration _findDeclaredMethod = _declaringType.findDeclaredMethod(_simpleName, (TypeReference[])Conversions.unwrapArray((Object)_map, TypeReference.class));
                    return Objects.equal((Object)_findDeclaredMethod, null);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)_flatten, (Functions.Function1)_function_1);
            Functions.Function1<ResolvedMethod, Boolean> _function_2 = new Functions.Function1<ResolvedMethod, Boolean>(){

                public Boolean apply(ResolvedMethod it) {
                    boolean _isObjectMethod = Util.this.isObjectMethod(it);
                    return !_isObjectMethod;
                }
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_2);
            Functions.Function1<ResolvedMethod, String> _function_3 = new Functions.Function1<ResolvedMethod, String>(){

                public String apply(ResolvedMethod it) {
                    return it.getSimpleSignature();
                }
            };
            Map _groupBy = IterableExtensions.groupBy((Iterable)_filter_1, (Functions.Function1)_function_3);
            Collection _values = _groupBy.values();
            Functions.Function1<List<ResolvedMethod>, ResolvedMethod> _function_4 = new Functions.Function1<List<ResolvedMethod>, ResolvedMethod>(){

                public ResolvedMethod apply(List<ResolvedMethod> it) {
                    return (ResolvedMethod)IterableExtensions.head(it);
                }
            };
            Iterable _map_1 = IterableExtensions.map(_values, (Functions.Function1)_function_4);
            return IterableExtensions.toSet((Iterable)_map_1);
        }

        public boolean isObjectMethod(ResolvedMethod it) {
            boolean _isEmpty;
            boolean _xblockexpression = false;
            MethodDeclaration _declaration = it.getDeclaration();
            String name = _declaration.getSimpleName();
            Iterable _resolvedParameters = it.getResolvedParameters();
            Functions.Function1<ResolvedParameter, TypeReference> _function = new Functions.Function1<ResolvedParameter, TypeReference>(){

                public TypeReference apply(ResolvedParameter it) {
                    return it.getResolvedType();
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_resolvedParameters, (Functions.Function1)_function);
            List parameterTypes = IterableExtensions.toList((Iterable)_map);
            boolean _or = false;
            boolean _or_1 = false;
            boolean _or_2 = false;
            boolean _or_3 = false;
            boolean _and = false;
            boolean _equals = Objects.equal((Object)name, (Object)"hashCode");
            _and = !_equals ? false : (_isEmpty = parameterTypes.isEmpty());
            if (_and) {
                _or_3 = true;
            } else {
                boolean _isEmpty_1;
                boolean _and_1 = false;
                boolean _equals_1 = Objects.equal((Object)name, (Object)"toString");
                _and_1 = !_equals_1 ? false : (_isEmpty_1 = parameterTypes.isEmpty());
                _or_3 = _and_1;
            }
            if (_or_3) {
                _or_2 = true;
            } else {
                boolean _and_2 = false;
                boolean _equals_2 = Objects.equal((Object)name, (Object)"equals");
                if (!_equals_2) {
                    _and_2 = false;
                } else {
                    boolean _equals_3;
                    TypeReference _object = this.context.getObject();
                    _and_2 = _equals_3 = Objects.equal((Object)parameterTypes, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_object})));
                }
                _or_2 = _and_2;
            }
            if (_or_2) {
                _or_1 = true;
            } else {
                boolean _isEmpty_2;
                boolean _and_3 = false;
                boolean _equals_4 = Objects.equal((Object)name, (Object)"finalize");
                _and_3 = !_equals_4 ? false : (_isEmpty_2 = parameterTypes.isEmpty());
                _or_1 = _and_3;
            }
            if (_or_1) {
                _or = true;
            } else {
                boolean _isEmpty_3;
                boolean _and_4 = false;
                boolean _equals_5 = Objects.equal((Object)name, (Object)"clone");
                _and_4 = !_equals_5 ? false : (_isEmpty_3 = parameterTypes.isEmpty());
                _or = _and_4;
            }
            _xblockexpression = _or;
            return _xblockexpression;
        }

        public MutableMethodDeclaration implementMethod(final MutableMemberDeclaration delegate, final ResolvedMethod resolvedMethod) {
            MutableMethodDeclaration _xblockexpression = null;
            delegate.markAsRead();
            final MethodDeclaration declaration = resolvedMethod.getDeclaration();
            MutableTypeDeclaration _declaringType = delegate.getDeclaringType();
            String _simpleName = declaration.getSimpleName();
            Procedures.Procedure1<MutableMethodDeclaration> _function = new Procedures.Procedure1<MutableMethodDeclaration>(){

                public void apply(final MutableMethodDeclaration impl) {
                    Element _primarySourceElement = Util.this.context.getPrimarySourceElement((Element)delegate);
                    Util.this.context.setPrimarySourceElement((MutableElement)impl, _primarySourceElement);
                    final HashMap typeParameterMappings = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
                    Iterable _resolvedTypeParameters = resolvedMethod.getResolvedTypeParameters();
                    Procedures.Procedure1<ResolvedTypeParameter> _function = new Procedures.Procedure1<ResolvedTypeParameter>(){

                        public void apply(ResolvedTypeParameter param) {
                            TypeParameterDeclaration _declaration = param.getDeclaration();
                            String _simpleName = _declaration.getSimpleName();
                            Iterable _resolvedUpperBounds = param.getResolvedUpperBounds();
                            MutableTypeParameterDeclaration copy = impl.addTypeParameter(_simpleName, (TypeReference[])Conversions.unwrapArray((Object)_resolvedUpperBounds, TypeReference.class));
                            TypeParameterDeclaration _declaration_1 = param.getDeclaration();
                            TypeReference _newTypeReference = Util.this.context.newTypeReference((Type)_declaration_1, new TypeReference[0]);
                            TypeReference _newTypeReference_1 = Util.this.context.newTypeReference((Type)copy, new TypeReference[0]);
                            typeParameterMappings.put(_newTypeReference, _newTypeReference_1);
                            Iterable _upperBounds = copy.getUpperBounds();
                            Functions.Function1<TypeReference, TypeReference> _function = new Functions.Function1<TypeReference, TypeReference>(){

                                public TypeReference apply(TypeReference it) {
                                    return Util.this.replace(it, typeParameterMappings);
                                }
                            };
                            Iterable _map = IterableExtensions.map((Iterable)_upperBounds, (Functions.Function1)_function);
                            copy.setUpperBounds(_map);
                        }
                    };
                    IterableExtensions.forEach((Iterable)_resolvedTypeParameters, (Procedures.Procedure1)_function);
                    Iterable _resolvedExceptionTypes = resolvedMethod.getResolvedExceptionTypes();
                    Functions.Function1<TypeReference, TypeReference> _function_1 = new Functions.Function1<TypeReference, TypeReference>(){

                        public TypeReference apply(TypeReference it) {
                            return Util.this.replace(it, typeParameterMappings);
                        }
                    };
                    Iterable _map = IterableExtensions.map((Iterable)_resolvedExceptionTypes, (Functions.Function1)_function_1);
                    impl.setExceptions((TypeReference[])Conversions.unwrapArray((Object)_map, TypeReference.class));
                    boolean _isVarArgs = declaration.isVarArgs();
                    impl.setVarArgs(_isVarArgs);
                    TypeReference _resolvedReturnType = resolvedMethod.getResolvedReturnType();
                    TypeReference _replace = Util.this.replace(_resolvedReturnType, typeParameterMappings);
                    impl.setReturnType(_replace);
                    Iterable _resolvedParameters = resolvedMethod.getResolvedParameters();
                    Procedures.Procedure1<ResolvedParameter> _function_2 = new Procedures.Procedure1<ResolvedParameter>(){

                        public void apply(ResolvedParameter p) {
                            ParameterDeclaration _declaration = p.getDeclaration();
                            String _simpleName = _declaration.getSimpleName();
                            TypeReference _resolvedType = p.getResolvedType();
                            TypeReference _replace = Util.this.replace(_resolvedType, typeParameterMappings);
                            impl.addParameter(_simpleName, _replace);
                        }
                    };
                    IterableExtensions.forEach((Iterable)_resolvedParameters, (Procedures.Procedure1)_function_2);
                    StringConcatenationClient _client = new StringConcatenationClient(){

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            String _returnIfNeeded = Util.this.returnIfNeeded(resolvedMethod);
                            _builder.append((Object)_returnIfNeeded, "");
                            CharSequence _delegateAccess = Util.this.delegateAccess((MemberDeclaration)delegate, declaration);
                            _builder.append((Object)_delegateAccess, "");
                            _builder.append((Object)".");
                            String _simpleName = declaration.getSimpleName();
                            _builder.append((Object)_simpleName, "");
                            _builder.append((Object)"(");
                            Iterable _parameters = declaration.getParameters();
                            Functions.Function1<ParameterDeclaration, CharSequence> _function = new Functions.Function1<ParameterDeclaration, CharSequence>(){

                                public CharSequence apply(ParameterDeclaration it) {
                                    return it.getSimpleName();
                                }
                            };
                            String _join = IterableExtensions.join((Iterable)_parameters, (CharSequence)", ", (Functions.Function1)_function);
                            _builder.append((Object)_join, "");
                            _builder.append((Object)");");
                            _builder.newLineIfNotEmpty();
                        }
                    };
                    impl.setBody(_client);
                }
            };
            _xblockexpression = _declaringType.addMethod(_simpleName, (Procedures.Procedure1)_function);
            return _xblockexpression;
        }

        public TypeReference replace(TypeReference target, Map<? extends TypeReference, ? extends TypeReference> mappings) {
            Set<Map.Entry<? extends TypeReference, ? extends TypeReference>> _entrySet = mappings.entrySet();
            Functions.Function2<TypeReference, Map.Entry<? extends TypeReference, ? extends TypeReference>, TypeReference> _function = new Functions.Function2<TypeReference, Map.Entry<? extends TypeReference, ? extends TypeReference>, TypeReference>(){

                public TypeReference apply(TypeReference result, Map.Entry<? extends TypeReference, ? extends TypeReference> mapping) {
                    TypeReference _key = mapping.getKey();
                    TypeReference _value = mapping.getValue();
                    return Util.this.replace(result, _key, _value);
                }
            };
            return (TypeReference)IterableExtensions.fold(_entrySet, (Object)target, (Functions.Function2)_function);
        }

        public TypeReference replace(TypeReference target, final TypeReference oldType, final TypeReference newType) {
            boolean _isArray;
            boolean _not;
            boolean _equals = Objects.equal((Object)target, (Object)oldType);
            if (_equals) {
                return newType;
            }
            List _actualTypeArguments = target.getActualTypeArguments();
            boolean _isEmpty = _actualTypeArguments.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                Type _type = target.getType();
                List _actualTypeArguments_1 = target.getActualTypeArguments();
                Functions.Function1<TypeReference, TypeReference> _function = new Functions.Function1<TypeReference, TypeReference>(){

                    public TypeReference apply(TypeReference it) {
                        return Util.this.replace(it, oldType, newType);
                    }
                };
                List _map = ListExtensions.map((List)_actualTypeArguments_1, (Functions.Function1)_function);
                return this.context.newTypeReference(_type, (TypeReference[])Conversions.unwrapArray((Object)_map, TypeReference.class));
            }
            boolean _isWildCard = target.isWildCard();
            if (_isWildCard) {
                boolean _not_1;
                TypeReference _object;
                boolean _notEquals;
                TypeReference _upperBound = target.getUpperBound();
                boolean bl2 = _notEquals = !Objects.equal((Object)_upperBound, (Object)(_object = this.context.getObject()));
                if (_notEquals) {
                    TypeReference _upperBound_1 = target.getUpperBound();
                    TypeReference _replace = this.replace(_upperBound_1, oldType, newType);
                    return this.context.newWildcardTypeReference(_replace);
                }
                TypeReference _lowerBound = target.getLowerBound();
                boolean _isAnyType = _lowerBound.isAnyType();
                boolean bl3 = _not_1 = !_isAnyType;
                if (_not_1) {
                    TypeReference _lowerBound_1 = target.getLowerBound();
                    TypeReference _replace_1 = this.replace(_lowerBound_1, oldType, newType);
                    return this.context.newWildcardTypeReferenceWithLowerBound(_replace_1);
                }
            }
            if (_isArray = target.isArray()) {
                TypeReference _arrayComponentType = target.getArrayComponentType();
                TypeReference _replace_2 = this.replace(_arrayComponentType, oldType, newType);
                return this.context.newArrayTypeReference(_replace_2);
            }
            return target;
        }

        protected CharSequence _delegateAccess(FieldDeclaration it, MethodDeclaration method) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"this.");
            String _simpleName = it.getSimpleName();
            _builder.append((Object)_simpleName, "");
            return _builder;
        }

        protected CharSequence _delegateAccess(MethodDeclaration it, MethodDeclaration method) {
            TypeReference _object;
            TypeReference _newArrayTypeReference_1;
            TypeReference _newWildcardTypeReference;
            TypeReference _newTypeReference;
            TypeReference _newArrayTypeReference;
            TypeReference _string_1;
            TypeReference _string;
            StringConcatenation _switchResult = null;
            Iterable _parameters = it.getParameters();
            Functions.Function1<ParameterDeclaration, TypeReference> _function = new Functions.Function1<ParameterDeclaration, TypeReference>(){

                public TypeReference apply(ParameterDeclaration it) {
                    return it.getType();
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_parameters, (Functions.Function1)_function);
            List _list = IterableExtensions.toList((Iterable)_map);
            boolean _matched = false;
            if (!_matched && Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[0])))) {
                _matched = true;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"this.");
                String _simpleName = it.getSimpleName();
                _builder.append((Object)_simpleName, "");
                _builder.append((Object)"()");
                _switchResult = _builder;
            }
            if (!_matched && Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_string = this.context.getString()})))) {
                _matched = true;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"this.");
                String _simpleName_1 = it.getSimpleName();
                _builder_1.append((Object)_simpleName_1, "");
                _builder_1.append((Object)"(\"");
                String _simpleName_2 = method.getSimpleName();
                _builder_1.append((Object)_simpleName_2, "");
                _builder_1.append((Object)"\")");
                _switchResult = _builder_1;
            }
            if (!_matched && Objects.equal((Object)_list, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeReference[]{_string_1 = this.context.getString(), _newArrayTypeReference = this.context.newArrayTypeReference(_newTypeReference = this.context.newTypeReference(Class.class, new TypeReference[]{_newWildcardTypeReference = this.context.newWildcardTypeReference()})), _newArrayTypeReference_1 = this.context.newArrayTypeReference(_object = this.context.getObject())})))) {
                _matched = true;
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append((Object)"this.");
                String _simpleName_3 = it.getSimpleName();
                _builder_2.append((Object)_simpleName_3, "");
                _builder_2.append((Object)"(\"");
                String _simpleName_4 = method.getSimpleName();
                _builder_2.append((Object)_simpleName_4, "");
                _builder_2.append((Object)"\", new Class[]{");
                Iterable _parameters_1 = method.getParameters();
                Functions.Function1<ParameterDeclaration, CharSequence> _function_1 = new Functions.Function1<ParameterDeclaration, CharSequence>(){

                    public CharSequence apply(ParameterDeclaration it) {
                        TypeReference _type = it.getType();
                        Type _type_1 = _type.getType();
                        String _simpleName = _type_1.getSimpleName();
                        return String.valueOf(_simpleName) + ".class";
                    }
                };
                String _join = IterableExtensions.join((Iterable)_parameters_1, (CharSequence)", ", (Functions.Function1)_function_1);
                _builder_2.append((Object)_join, "");
                _builder_2.append((Object)"}, new Object[]{");
                Iterable _parameters_2 = method.getParameters();
                Functions.Function1<ParameterDeclaration, CharSequence> _function_2 = new Functions.Function1<ParameterDeclaration, CharSequence>(){

                    public CharSequence apply(ParameterDeclaration it) {
                        return it.getSimpleName();
                    }
                };
                String _join_1 = IterableExtensions.join((Iterable)_parameters_2, (CharSequence)", ", (Functions.Function1)_function_2);
                _builder_2.append((Object)_join_1, "");
                _builder_2.append((Object)"})");
                _switchResult = _builder_2;
            }
            if (!_matched) {
                throw new IllegalArgumentException("delegate signature");
            }
            return _switchResult;
        }

        public String returnIfNeeded(ResolvedMethod it) {
            String _xifexpression = null;
            TypeReference _resolvedReturnType = it.getResolvedReturnType();
            boolean _isVoid = _resolvedReturnType.isVoid();
            _xifexpression = _isVoid ? "" : "return ";
            return _xifexpression;
        }

        public boolean isValidDelegate(MemberDeclaration it) {
            if (it instanceof MethodDeclaration) {
                return this._isValidDelegate((MethodDeclaration)it);
            }
            if (it instanceof FieldDeclaration) {
                return this._isValidDelegate((FieldDeclaration)it);
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
        }

        public TypeReference getType(MemberDeclaration it) {
            if (it instanceof MethodDeclaration) {
                return this._getType((MethodDeclaration)it);
            }
            if (it instanceof FieldDeclaration) {
                return this._getType((FieldDeclaration)it);
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
        }

        public CharSequence delegateAccess(MemberDeclaration it, MethodDeclaration method) {
            if (it instanceof MethodDeclaration) {
                return this._delegateAccess((MethodDeclaration)it, method);
            }
            if (it instanceof FieldDeclaration) {
                return this._delegateAccess((FieldDeclaration)it, method);
            }
            throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, method).toString());
        }
    }
}

