/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.preferences;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.xtext.ui.editor.preferences.PreferenceStoreAccessImpl;
import org.eclipse.xtext.ui.preferences.IStatusChangeListener;
import org.eclipse.xtext.ui.preferences.Messages;
import org.eclipse.xtext.ui.preferences.ScrolledPageContent;

public abstract class OptionsConfigurationBlock {
    @Inject
    AbstractUIPlugin uiPlugin;
    @Inject
    protected PreferenceStoreAccessImpl preferenceStoreAccessImpl;
    private static final String IS_PROJECT_SPECIFIC = "is_project_specific";
    private static final String SETTINGS_EXPANDED = "expanded";
    private static final String REBUILD_COUNT_KEY = "preferences_build_requested";
    protected final List<Button> checkBoxes = Lists.newArrayList();
    protected final List<Text> textBoxes = Lists.newArrayList();
    protected final List<Combo> comboBoxes = Lists.newArrayList();
    protected final Map<Control, Label> labels = Maps.newHashMap();
    protected final List<ExpandableComposite> expandedComposites = Lists.newArrayList();
    private SelectionListener selectionListener;
    private ModifyListener textModifyListener;
    protected IStatusChangeListener statusChangeListener;
    protected IProject project;
    protected String[] keys;
    private Shell shell;
    private Map<String, String> disabledProjectSettings;
    private Map<String, String> originalSettings;
    private int rebuildCount;
    private IPreferenceStore preferenceStore;
    private IWorkbenchPreferenceContainer workbenchPreferenceContainer;
    private List<String> keysToRegister = Lists.newArrayList();

    public IProject getProject() {
        return this.project;
    }

    public void setStatusChangeListener(IStatusChangeListener fContext) {
        this.statusChangeListener = fContext;
    }

    public OptionsConfigurationBlock(IProject project, IPreferenceStore preferenceStore, IWorkbenchPreferenceContainer container) {
        this.project = project;
        this.keys = new String[0];
        this.setPreferenceStore(preferenceStore);
        this.workbenchPreferenceContainer = container;
    }

    public OptionsConfigurationBlock() {
        this.keys = new String[0];
    }

    public void setWorkbenchPreferenceContainer(IWorkbenchPreferenceContainer workbenchPreferenceContainer) {
        this.workbenchPreferenceContainer = workbenchPreferenceContainer;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setPreferenceStore(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
        this.rebuildCount = this.getRebuildCount();
    }

    private void updateDisabledProjSettings(IProject project, IPreferenceStore preferenceStore, String[] allKeys) {
        if (project == null || this.hasProjectSpecificOptions(project)) {
            this.disabledProjectSettings = null;
        } else {
            this.disabledProjectSettings = Maps.newHashMap();
            String[] stringArray = allKeys;
            int n = allKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                this.disabledProjectSettings.put(key, preferenceStore.getString(key));
                ++n2;
            }
        }
    }

    public boolean hasProjectSpecificOptions(IProject project) {
        IPreferenceStore ps = this.preferenceStore;
        if (project != this.getProject()) {
            ps = this.preferenceStoreAccessImpl.getWritablePreferenceStore(project);
        }
        boolean oldSettingsUsed = ps.getBoolean(IS_PROJECT_SPECIFIC);
        boolean newSettingsValue = ps.getBoolean(this.getIsProjectSpecificPropertyKey(this.getPropertyPrefix()));
        if (oldSettingsUsed && !newSettingsValue) {
            ps.setValue(this.getIsProjectSpecificPropertyKey(this.getPropertyPrefix()), true);
            return true;
        }
        return newSettingsValue;
    }

    protected void setShell(Shell shell) {
        this.shell = shell;
    }

    protected Shell getShell() {
        return this.shell;
    }

    public final Control createContents(Composite parent) {
        Control content = this.doCreateContents(parent);
        this.collectRegistredKeys();
        this.updateDisabledProjSettings(this.project, this.preferenceStore, this.keys);
        this.captureOriginalSettings(this.keys);
        return content;
    }

    protected abstract Control doCreateContents(Composite var1);

    protected Button addCheckBox(Composite parent, String label, String key, String[] values, int indent) {
        ControlData data = new ControlData(key, values);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = indent;
        return this.addCheckboxWithData(parent, label, data, gd);
    }

    protected Button addCheckboxWithData(Composite parent, String label, ControlData data, GridData gd) {
        Button checkBox = new Button(parent, 32);
        checkBox.setFont(JFaceResources.getDialogFont());
        checkBox.setText(label);
        checkBox.setData((Object)data);
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.getSelectionListener());
        this.makeScrollableCompositeAware((Control)checkBox);
        this.updateCheckBox(checkBox);
        this.checkBoxes.add(checkBox);
        return checkBox;
    }

    protected Text addTextField(Composite parent, String label, String key, int indent, int widthHint) {
        Label labelControl = new Label(parent, 64);
        labelControl.setText(label);
        labelControl.setFont(JFaceResources.getDialogFont());
        GridData labelLayoutData = new GridData();
        labelLayoutData.horizontalIndent = indent;
        labelControl.setLayoutData((Object)labelLayoutData);
        Text textBox = new Text(parent, 2052);
        textBox.setData((Object)key);
        this.makeScrollableCompositeAware((Control)textBox);
        this.labels.put((Control)textBox, labelControl);
        this.updateText(textBox);
        textBox.addModifyListener(this.getTextModifyListener());
        GridData textLayoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        if (widthHint != 0) {
            textLayoutData.widthHint = widthHint;
        }
        textBox.setLayoutData((Object)textLayoutData);
        this.textBoxes.add(textBox);
        return textBox;
    }

    protected Combo addComboBox(Composite parent, String label, String key, int indent, String[] values, String[] valueLabels) {
        GridData gd = new GridData(4, 2, true, false, 2, 1);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16384);
        labelControl.setFont(JFaceResources.getDialogFont());
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = this.newComboControl(parent, key, values, valueLabels);
        comboBox.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.labels.put((Control)comboBox, labelControl);
        return comboBox;
    }

    protected Combo newComboControl(Composite composite, String key, String[] values, String[] valueLabels) {
        ControlData data = new ControlData(key, values);
        Combo comboBox = new Combo(composite, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.addSelectionListener(this.getSelectionListener());
        comboBox.setFont(JFaceResources.getDialogFont());
        comboBox.setVisibleItemCount(30);
        this.makeScrollableCompositeAware((Control)comboBox);
        this.updateCombo(comboBox);
        this.comboBoxes.add(comboBox);
        return comboBox;
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    protected ExpandableComposite createStyleSection(Composite parent, String label, int nColumns) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, nColumns, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                OptionsConfigurationBlock.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.expandedComposites.add(excomposite);
        this.makeScrollableCompositeAware((Control)excomposite);
        return excomposite;
    }

    protected final void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    protected void restoreSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.expandedComposites.size()) {
            ExpandableComposite excomposite = this.expandedComposites.get(i);
            if (settings == null) {
                excomposite.setExpanded(i == 0);
            } else {
                excomposite.setExpanded(settings.getBoolean(SETTINGS_EXPANDED + String.valueOf(i)));
            }
            ++i;
        }
    }

    protected void storeSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.expandedComposites.size()) {
            ExpandableComposite curr = this.expandedComposites.get(i);
            settings.put(SETTINGS_EXPANDED + String.valueOf(i), curr.isExpanded());
            ++i;
        }
    }

    protected SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    OptionsConfigurationBlock.this.controlChanged(e.widget);
                }
            };
        }
        return this.selectionListener;
    }

    protected ModifyListener getTextModifyListener() {
        if (this.textModifyListener == null) {
            this.textModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OptionsConfigurationBlock.this.textChanged((Text)e.widget);
                }
            };
        }
        return this.textModifyListener;
    }

    protected void controlChanged(Widget widget) {
        ControlData data = (ControlData)widget.getData();
        String newValue = null;
        if (widget instanceof Button) {
            newValue = data.getValue(((Button)widget).getSelection());
        } else if (widget instanceof Combo) {
            newValue = data.getValue(((Combo)widget).getSelectionIndex());
        } else {
            return;
        }
        String oldValue = this.setValue(data.getKey(), newValue);
        this.validateSettings(data.getKey(), oldValue, newValue);
    }

    protected void textChanged(Text textControl) {
        String key = (String)textControl.getData();
        String number = textControl.getText();
        String oldValue = this.setValue(key, number);
        this.validateSettings(key, oldValue, number);
    }

    protected String getValue(String key) {
        if (this.disabledProjectSettings != null) {
            return this.disabledProjectSettings.get(key);
        }
        return this.preferenceStore.getString(key);
    }

    protected String setValue(String key, String value) {
        if (this.disabledProjectSettings != null) {
            return this.disabledProjectSettings.put(key, value);
        }
        String oldValue = this.getValue(key);
        this.preferenceStore.putValue(key, value);
        return oldValue;
    }

    protected String setToDefault(String key) {
        String value = this.preferenceStore.getDefaultString(key);
        if (this.disabledProjectSettings != null) {
            return this.disabledProjectSettings.put(key, value);
        }
        String oldValue = this.getValue(key);
        this.preferenceStore.setValue(key, value);
        return oldValue;
    }

    public void useProjectSpecificSettings(boolean enable) {
        boolean hasProjectSpecificOption;
        boolean bl = hasProjectSpecificOption = this.disabledProjectSettings == null;
        if (enable != hasProjectSpecificOption && this.project != null) {
            if (enable) {
                int i = 0;
                while (i < this.keys.length) {
                    String curr = this.keys[i];
                    String val = this.disabledProjectSettings.get(curr);
                    this.preferenceStore.putValue(curr, val);
                    ++i;
                }
                this.disabledProjectSettings = null;
                this.updateControls();
                this.validateSettings(null, null, null);
                this.preferenceStore.setValue(this.getIsProjectSpecificPropertyKey(this.getPropertyPrefix()), true);
            } else {
                this.disabledProjectSettings = Maps.newHashMap();
                int i = 0;
                while (i < this.keys.length) {
                    String curr = this.keys[i];
                    String oldSetting = this.preferenceStore.getString(curr);
                    this.disabledProjectSettings.put(curr, oldSetting);
                    this.preferenceStore.setToDefault(curr);
                    ++i;
                }
                this.preferenceStore.setToDefault(this.getIsProjectSpecificPropertyKey(this.getPropertyPrefix()));
                this.preferenceStore.setToDefault(IS_PROJECT_SPECIFIC);
            }
        }
    }

    public boolean performOk() {
        return this.processChanges(this.workbenchPreferenceContainer);
    }

    public boolean performApply() {
        return this.processChanges(this.workbenchPreferenceContainer);
    }

    private int getRebuildCount() {
        return this.preferenceStore.getDefaultInt(REBUILD_COUNT_KEY);
    }

    private void incrementRebuildCount() {
        this.preferenceStore.setDefault(REBUILD_COUNT_KEY, this.getRebuildCount() + 1);
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        String[] strings;
        int count;
        boolean needsBuild = !this.getPreferenceChanges().isEmpty();
        boolean doBuild = false;
        if (needsBuild && (count = this.getRebuildCount()) > this.rebuildCount) {
            needsBuild = false;
            this.rebuildCount = count;
        }
        if (needsBuild && (strings = this.getFullBuildDialogStrings(this.project == null)) != null) {
            MessageDialog dialog = new MessageDialog(this.shell, strings[0], null, strings[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            int res = dialog.open();
            if (res == 0) {
                doBuild = true;
            } else if (res != 1) {
                return false;
            }
        }
        this.savePreferences();
        if (container != null) {
            if (doBuild) {
                this.incrementRebuildCount();
                container.registerUpdateJob(this.getBuildJob(this.getProject()));
            }
        } else if (doBuild) {
            this.getBuildJob(this.getProject()).schedule();
        }
        this.captureOriginalSettings(this.keys);
        return true;
    }

    protected void savePreferences() {
        try {
            if (this.preferenceStore instanceof IPersistentPreferenceStore) {
                ((IPersistentPreferenceStore)this.preferenceStore).save();
            }
        }
        catch (IOException e) {
            this.logError("Unexpected internal error: ", e);
        }
    }

    private void logError(String text, IOException e) {
        Status status = new Status(4, this.uiPlugin.getBundle().getSymbolicName(), text, (Throwable)e);
        this.uiPlugin.getLog().log((IStatus)status);
    }

    public Map<String, MapDifference.ValueDifference<String>> getPreferenceChanges() {
        HashMap currentSettings = Maps.newHashMapWithExpectedSize((int)this.keys.length);
        String[] stringArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            currentSettings.put(key, this.preferenceStore.getString(key));
            ++n2;
        }
        MapDifference mapDifference = Maps.difference((Map)currentSettings, this.originalSettings);
        Map entriesDiffering = mapDifference.entriesDiffering();
        return entriesDiffering;
    }

    protected abstract Job getBuildJob(IProject var1);

    protected abstract String[] getFullBuildDialogStrings(boolean var1);

    public void performDefaults() {
        int i = 0;
        while (i < this.keys.length) {
            String curr = this.keys[i];
            this.setToDefault(curr);
            ++i;
        }
        this.updateControls();
        this.validateSettings(null, null, null);
    }

    public void dispose() {
    }

    protected void updateControls() {
        int i = this.comboBoxes.size() - 1;
        while (i >= 0) {
            this.updateCombo(this.comboBoxes.get(i));
            --i;
        }
        i = this.checkBoxes.size() - 1;
        while (i >= 0) {
            this.updateCheckBox(this.checkBoxes.get(i));
            --i;
        }
        i = this.textBoxes.size() - 1;
        while (i >= 0) {
            this.updateText(this.textBoxes.get(i));
            --i;
        }
    }

    protected void collectRegistredKeys() {
        ControlData data;
        ArrayList collectedKeys = Lists.newArrayList();
        for (Combo combo : this.comboBoxes) {
            data = (ControlData)combo.getData();
            collectedKeys.add(data.getKey());
        }
        for (Button button : this.checkBoxes) {
            data = (ControlData)button.getData();
            collectedKeys.add(data.getKey());
        }
        for (Text textField : this.textBoxes) {
            collectedKeys.add((String)textField.getData());
        }
        collectedKeys.addAll(this.keysToRegister);
        this.keys = (String[])Iterables.toArray((Iterable)collectedKeys, String.class);
    }

    protected void updateCombo(Combo curr) {
        ControlData data = (ControlData)curr.getData();
        String currValue = this.getValue(data.getKey());
        int selection = data.getSelection(currValue);
        curr.select(selection);
    }

    protected void updateCheckBox(Button curr) {
        ControlData data = (ControlData)curr.getData();
        curr.setSelection(this.checkBoxValue(data));
    }

    private boolean checkBoxValue(ControlData data) {
        String currValue = this.getValue(data.getKey());
        boolean selection = data.getSelection(currValue) == 0;
        return selection;
    }

    protected void updateText(Text curr) {
        String key = (String)curr.getData();
        String currValue = this.getValue(key);
        if (currValue != null) {
            curr.setText(currValue);
        }
    }

    protected abstract void validateSettings(String var1, String var2, String var3);

    private void captureOriginalSettings(String[] keys) {
        this.originalSettings = Maps.newHashMapWithExpectedSize((int)keys.length);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            this.originalSettings.put(key, this.preferenceStore.getString(key));
            ++n2;
        }
    }

    protected void registerKey(String key) {
        this.keysToRegister.add(key);
    }

    public abstract String getPropertyPrefix();

    public String getIsProjectSpecificPropertyKey(String propertyPrefix) {
        String key = IS_PROJECT_SPECIFIC;
        if (propertyPrefix != null) {
            key = OptionsConfigurationBlock.isProjectSpecificPropertyKey(propertyPrefix);
        } else {
            this.logError("Project specific key is not qualified", null);
        }
        return key;
    }

    public static String isProjectSpecificPropertyKey(String propertyPrefix) {
        return String.valueOf(propertyPrefix) + "." + IS_PROJECT_SPECIFIC;
    }

    public static final class BuildJob
    extends Job {
        private final IProject project;

        public BuildJob(String name, IProject project) {
            super(name);
            this.project = project;
        }

        public boolean isCoveredBy(BuildJob other) {
            if (other.project == null) {
                return true;
            }
            return this.project != null && this.project.equals((Object)other.project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Job[] buildJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                int i = 0;
                while (i < buildJobs.length) {
                    BuildJob job;
                    if (buildJobs[i] != this && buildJobs[i] instanceof BuildJob && (job = (BuildJob)buildJobs[i]).isCoveredBy(this)) {
                        buildJobs[i].cancel();
                    }
                    ++i;
                }
            }
            try {
                try {
                    if (this.project != null) {
                        monitor.beginTask(String.format(Messages.BuilderConfigurationBlock_BuildJob_TitleBuildProject_TaskName, TextProcessor.process((String)this.project.getName(), (String)":.")), 2);
                        this.project.build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        monitor.beginTask(Messages.BuilderConfigurationBlock_BuildJob_TitleBuildAll_TaskName, 2);
                        ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    }
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    monitor.done();
                    return iStatus;
                }
                catch (OperationCanceledException e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }

    protected static class ControlData {
        private String key;
        private String[] values;

        public ControlData(String key, String[] values) {
            this.key = key;
            this.values = values;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.values[index];
        }

        public String getValue(int index) {
            return this.values[index];
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.values.length) {
                    if (value.equals(this.values[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.values.length - 1;
        }
    }
}

