/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.javaconverter;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.xtend.core.javaconverter.ASTParserFactory;
import org.eclipse.xtend.core.javaconverter.JavaASTFlattener;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class JavaConverter {
    @Inject
    private ASTParserFactory astParserFactory;
    @Inject
    private Provider<JavaASTFlattener> astFlattenerProvider;
    private boolean fallbackConversionStartegy = false;

    public ConversionResult toXtend(ICompilationUnit cu) {
        try {
            ASTParserFactory.ASTParserWrapper parser = this.astParserFactory.createJavaParser(cu);
            ASTNode root = parser.createAST();
            String _source = cu.getSource();
            String _targetLevel = parser.getTargetLevel();
            return this.executeAstFlattener(_source, root, _targetLevel, false);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ConversionResult toXtend(String unitName, String javaSrc) {
        ConversionResult _xblockexpression = null;
        boolean _equals = Objects.equal((Object)unitName, null);
        if (_equals) {
            throw new IllegalArgumentException();
        }
        ASTParserFactory.ASTParserWrapper _createJavaParser = this.astParserFactory.createJavaParser(null);
        _xblockexpression = this.internalToXtend(unitName, javaSrc, null, _createJavaParser);
        return _xblockexpression;
    }

    public ConversionResult toXtend(String unitName, String javaSrc, Object classPathContext) {
        ConversionResult _xblockexpression = null;
        boolean _equals = Objects.equal((Object)unitName, null);
        if (_equals) {
            throw new IllegalArgumentException();
        }
        ASTParserFactory.ASTParserWrapper _createJavaParser = this.astParserFactory.createJavaParser(classPathContext);
        _xblockexpression = this.internalToXtend(unitName, javaSrc, null, _createJavaParser);
        return _xblockexpression;
    }

    public ConversionResult bodyDeclarationToXtend(String javaSrc, String[] imports, Object classPathContext) {
        ASTParserFactory.ASTParserWrapper _createJavaParser = this.astParserFactory.createJavaParser(classPathContext);
        return this.internalToXtend(null, javaSrc, imports, _createJavaParser);
    }

    public ConversionResult statementToXtend(String javaSrc, Object classPathContext) {
        ASTParserFactory.ASTParserWrapper parser = this.astParserFactory.createJavaParser(classPathContext);
        char[] _charArray = javaSrc.toCharArray();
        parser.setSource(_charArray);
        parser.setKind(2);
        ASTNode root = parser.createAST();
        if (root instanceof Block) {
            String _targetLevel = parser.getTargetLevel();
            return this.executeAstFlattener(javaSrc, root, _targetLevel, true);
        }
        String _targetLevel_1 = parser.getTargetLevel();
        return this.executeAstFlattener(javaSrc, root, _targetLevel_1, false);
    }

    public ConversionResult expressionToXtend(String javaSrc, Object classPathContext) {
        ASTParserFactory.ASTParserWrapper parser = this.astParserFactory.createJavaParser(classPathContext);
        char[] _charArray = javaSrc.toCharArray();
        parser.setSource(_charArray);
        parser.setKind(1);
        ASTNode root = parser.createAST();
        String _targetLevel = parser.getTargetLevel();
        return this.executeAstFlattener(javaSrc, root, _targetLevel, false);
    }

    private ConversionResult internalToXtend(String unitName, String javaSrc, String[] imports, ASTParserFactory.ASTParserWrapper parser) {
        boolean _equals;
        boolean _notEquals;
        final StringBuilder javaSrcBuilder = new StringBuilder();
        boolean bl = _notEquals = !Objects.equal((Object)imports, null);
        if (_notEquals) {
            Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

                public void apply(String it) {
                    javaSrcBuilder.append("import " + it + ";");
                }
            };
            IterableExtensions.forEach((Iterable)((Iterable)Conversions.doWrapArray((Object)imports)), (Procedures.Procedure1)_function);
        }
        if (_equals = Objects.equal((Object)unitName, null)) {
            parser.setUnitName("MISSING");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"class MISSING { ");
            _builder.append((Object)javaSrc, "");
            _builder.append((Object)" }");
            javaSrcBuilder.append((CharSequence)_builder);
        } else {
            parser.setUnitName(unitName);
            javaSrcBuilder.append(javaSrc);
        }
        parser.setKind(8);
        String preparedJavaSrc = javaSrcBuilder.toString();
        char[] _charArray = preparedJavaSrc.toCharArray();
        parser.setSource(_charArray);
        ASTNode result = parser.createAST();
        String _targetLevel = parser.getTargetLevel();
        return this.executeAstFlattener(preparedJavaSrc, result, _targetLevel, false);
    }

    private ConversionResult executeAstFlattener(String preparedJavaSource, ASTNode parseResult, String targetLevel, boolean synteticBlock) {
        JavaASTFlattener astFlattener = (JavaASTFlattener)((Object)this.astFlattenerProvider.get());
        astFlattener.setTargetlevel(targetLevel);
        astFlattener.useFallBackStrategy(this.fallbackConversionStartegy);
        astFlattener.setJavaSources(preparedJavaSource);
        boolean _and = false;
        _and = !synteticBlock ? false : parseResult instanceof Block;
        if (_and) {
            astFlattener.acceptSyntaticBlock((Block)parseResult);
        } else {
            parseResult.accept((ASTVisitor)astFlattener);
        }
        return ConversionResult.create(astFlattener);
    }

    public JavaConverter useRobustSyntax() {
        this.fallbackConversionStartegy = true;
        return this;
    }

    @Accessors
    public static class ConversionResult {
        private String xtendCode;
        private Iterable<String> problems = CollectionLiterals.newArrayList((Object[])new String[0]);

        public static ConversionResult create(JavaASTFlattener flattener) {
            boolean _notEquals;
            String _result;
            ConversionResult result = new ConversionResult();
            result.xtendCode = _result = flattener.getResult();
            List<String> _problems = flattener.getProblems();
            boolean bl = _notEquals = !Objects.equal(_problems, null);
            if (_notEquals) {
                List<String> _problems_1 = flattener.getProblems();
                result.problems = _problems_1;
            }
            return result;
        }

        @Pure
        public String getXtendCode() {
            return this.xtendCode;
        }

        public void setXtendCode(String xtendCode) {
            this.xtendCode = xtendCode;
        }

        @Pure
        public Iterable<String> getProblems() {
            return this.problems;
        }

        public void setProblems(Iterable<String> problems) {
            this.problems = problems;
        }
    }
}

