/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.packrat.matching;

import org.eclipse.xtext.parser.packrat.matching.ICharacterClass;

public class CharacterAlternatives
implements ICharacterClass {
    private final ICharacterClass[] classes;

    public CharacterAlternatives(ICharacterClass ... classes) {
        this.classes = classes;
    }

    @Override
    public boolean matches(char candidate) {
        ICharacterClass[] iCharacterClassArray = this.classes;
        int n = this.classes.length;
        int n2 = 0;
        while (n2 < n) {
            ICharacterClass characterClass = iCharacterClassArray[n2];
            if (characterClass.matches(candidate)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.classes.length) {
            if (i != 0) {
                result.append(" | ");
            }
            result.append(this.classes[i]);
            ++i;
        }
        return result.toString();
    }
}

