/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.editor;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.folding.FoldedPosition;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptor;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptorExtension;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.ui.editor.FoldingPreferences;

public class XtendFoldingRegionProvider
extends DefaultFoldingRegionProvider {
    @Inject
    FoldingPreferences foldingPreferences;

    public Collection<FoldedPosition> getFoldingRegions(IXtextDocument xtextDocument) {
        if (this.foldingPreferences.isEnabled()) {
            return super.getFoldingRegions(xtextDocument);
        }
        return Collections.emptyList();
    }

    protected boolean isHandled(EObject object) {
        EClass clazz = object.eClass();
        return clazz == XtendPackage.Literals.XTEND_CLASS || clazz == XtendPackage.Literals.XTEND_FILE || clazz == XtendPackage.Literals.XTEND_INTERFACE || clazz == XtendPackage.Literals.XTEND_ENUM || clazz == XtendPackage.Literals.XTEND_ANNOTATION_TYPE || clazz == XtendPackage.Literals.ANONYMOUS_CLASS || clazz == XtendPackage.Literals.XTEND_FUNCTION || clazz == XtendPackage.Literals.XTEND_CONSTRUCTOR;
    }

    protected boolean shouldProcessContent(EObject object) {
        return true;
    }

    protected void computeCommentFolding(IXtextDocument xtextDocument, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor, ITypedRegion typedRegion, boolean initiallyFolded) throws BadLocationException {
        if (xtextDocument.get(0, typedRegion.getOffset()).trim().length() == 0) {
            super.computeCommentFolding(xtextDocument, foldingRegionAcceptor, typedRegion, this.foldingPreferences.isFoldHeader());
        } else {
            super.computeCommentFolding(xtextDocument, foldingRegionAcceptor, typedRegion, this.foldingPreferences.isFoldComments());
        }
    }

    protected void computeObjectFolding(EObject eObject, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor) {
        if (eObject instanceof XtendFile) {
            this.computeImportFolding((XtendFile)eObject, foldingRegionAcceptor);
        } else {
            boolean initiallyFolded = false;
            if (eObject instanceof XtendFunction) {
                initiallyFolded = this.foldingPreferences.isFoldMethods();
            }
            if (eObject instanceof XtendTypeDeclaration && !(eObject.eContainer() instanceof XtendFile)) {
                initiallyFolded = this.foldingPreferences.isFoldInnerTypes();
            }
            super.computeObjectFolding(eObject, foldingRegionAcceptor, initiallyFolded);
        }
    }

    protected void computeImportFolding(XtendFile xtendFile, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor) {
        ICompositeNode node;
        if (xtendFile.getImportSection() != null && xtendFile.getImportSection().getImportDeclarations().size() > 1 && (node = NodeModelUtils.findActualNodeFor((EObject)xtendFile.getImportSection())) != null) {
            ITextRegion textRegion = node.getTextRegion();
            ((IFoldingRegionAcceptorExtension)foldingRegionAcceptor).accept(textRegion.getOffset(), textRegion.getLength(), this.foldingPreferences.isFoldImports());
        }
    }
}

