/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.formatting2;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.formatting2.Chunk;
import org.eclipse.xtend.core.formatting2.Line;
import org.eclipse.xtend.core.formatting2.LineModel;
import org.eclipse.xtend.core.formatting2.RichStringToLineModel;
import org.eclipse.xtend.core.formatting2.SemanticWhitespace;
import org.eclipse.xtend.core.formatting2.TemplateWhitespace;
import org.eclipse.xtend.core.richstring.DefaultIndentationHandler;
import org.eclipse.xtend.core.richstring.RichStringProcessor;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringElseIf;
import org.eclipse.xtend.core.xtend.RichStringForLoop;
import org.eclipse.xtend.core.xtend.RichStringIf;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.FormatterPreferenceKeys;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.internal.HiddenRegionReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionExtensions;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeEObjectRegion;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextSegment;
import org.eclipse.xtext.nodemodel.BidiTreeIterable;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@FinalFieldsConstructor
public class RichStringFormatter {
    private final Factory factory;
    @Extension
    private final ITextRegionExtensions _iTextRegionExtensions;

    protected void _format(RichString richString, final IFormattableDocument doc) {
        boolean _not;
        boolean _notEquals;
        EObject _eContainer = richString.eContainer();
        RichString _containerOfType = (RichString)EcoreUtil2.getContainerOfType((EObject)_eContainer, RichString.class);
        boolean bl = _notEquals = !Objects.equal((Object)_containerOfType, null);
        if (_notEquals) {
            return;
        }
        IEObjectRegion _regionForEObject = this._iTextRegionExtensions.regionForEObject((EObject)richString);
        boolean _hasSyntaxError = this.hasSyntaxError(_regionForEObject);
        if (_hasSyntaxError) {
            return;
        }
        ITextRegionAccess _textRegionAccess = this._iTextRegionExtensions.getTextRegionAccess();
        RichStringToLineModel impl = new RichStringToLineModel(_textRegionAccess, richString);
        DefaultIndentationHandler _defaultIndentationHandler = new DefaultIndentationHandler();
        this.factory.richStringProcessor.process(richString, impl, _defaultIndentationHandler);
        impl.finish();
        EList _expressions = richString.getExpressions();
        for (XExpression e : _expressions) {
            this.format((EObject)e, doc);
        }
        LineModel _model = impl.getModel();
        List<Line> lines = _model.getLines();
        boolean _and = false;
        boolean _isEmpty = lines.isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (!_not) {
            _and = false;
        } else {
            boolean _isNullOrEmpty;
            Line _last = (Line)IterableExtensions.last(lines);
            String _content = _last.getContent();
            _and = _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_content);
        }
        boolean canIndent = _and;
        for (Line line : lines) {
            boolean _not_1;
            boolean _greaterThan;
            LineModel _model_1 = impl.getModel();
            int _rootIndentLenght = _model_1.getRootIndentLenght();
            boolean bl3 = _greaterThan = _rootIndentLenght > 0;
            if (!_greaterThan) continue;
            int _xifexpression = 0;
            boolean _and_1 = false;
            if (!canIndent) {
                _and_1 = false;
            } else {
                boolean _equals;
                Line _head = (Line)IterableExtensions.head(lines);
                _and_1 = _equals = Objects.equal((Object)line, (Object)_head);
            }
            _xifexpression = _and_1 ? 1 : 0;
            int increaseIndentationChange = _xifexpression;
            int _xifexpression_1 = 0;
            boolean _and_2 = false;
            if (!canIndent) {
                _and_2 = false;
            } else {
                boolean _equals_1;
                Line _last_1 = (Line)IterableExtensions.last(lines);
                _and_2 = _equals_1 = Objects.equal((Object)line, (Object)_last_1);
            }
            _xifexpression_1 = _and_2 ? 1 : 0;
            int decraseIndentationChange = _xifexpression_1;
            int _xifexpression_2 = 0;
            boolean _isLeadingSemanticNewLine = line.isLeadingSemanticNewLine();
            if (_isLeadingSemanticNewLine) {
                int _offset = line.getOffset();
                int _newLineCharCount = line.getNewLineCharCount();
                _xifexpression_2 = _offset + _newLineCharCount;
            } else {
                _xifexpression_2 = line.getOffset();
            }
            int nloffset = _xifexpression_2;
            int _indentLength = line.getIndentLength();
            LineModel _model_2 = impl.getModel();
            int _rootIndentLenght_1 = _model_2.getRootIndentLenght();
            int i = Math.min(_indentLength, _rootIndentLenght_1);
            int _xifexpression_3 = 0;
            boolean _isLeadingSemanticNewLine_1 = line.isLeadingSemanticNewLine();
            if (_isLeadingSemanticNewLine_1) {
                _xifexpression_3 = i;
            } else {
                int _newLineCharCount_1 = line.getNewLineCharCount();
                _xifexpression_3 = _newLineCharCount_1 + i;
            }
            int nllength = _xifexpression_3;
            boolean _isLeadingSemanticNewLine_2 = line.isLeadingSemanticNewLine();
            if (_isLeadingSemanticNewLine_2) {
                this.setNewLines(doc, nloffset, nllength, increaseIndentationChange, decraseIndentationChange, 0);
            } else {
                this.setNewLines(doc, nloffset, nllength, increaseIndentationChange, decraseIndentationChange, 1);
            }
            List<Chunk> _chunks = line.getChunks();
            boolean _isEmpty_1 = _chunks.isEmpty();
            boolean bl4 = _not_1 = !_isEmpty_1;
            if (!_not_1) continue;
            int offset = nloffset + nllength;
            int _indentLength_1 = line.getIndentLength();
            LineModel _model_3 = impl.getModel();
            int _rootIndentLenght_2 = _model_3.getRootIndentLenght();
            int length = _indentLength_1 - _rootIndentLenght_2;
            List<Chunk> _chunks_1 = line.getChunks();
            Functions.Function1<Chunk, CharSequence> _function = new Functions.Function1<Chunk, CharSequence>(){

                public CharSequence apply(Chunk chunk) {
                    CharSequence _switchResult = null;
                    boolean _matched = false;
                    if (!_matched && chunk instanceof SemanticWhitespace) {
                        _matched = true;
                        _switchResult = ((SemanticWhitespace)chunk).getText();
                    }
                    if (!_matched && chunk instanceof TemplateWhitespace) {
                        _matched = true;
                        AbstractFormatter2 _formatter = doc.getFormatter();
                        _switchResult = (CharSequence)_formatter.getPreference((TypedPreferenceKey)FormatterPreferenceKeys.indentation);
                    }
                    return _switchResult;
                }
            };
            List _map = ListExtensions.map(_chunks_1, (Functions.Function1)_function);
            String text = IterableExtensions.join((Iterable)_map);
            this.setSpace(doc, offset, length, text);
        }
    }

    protected boolean _hasSyntaxError(IEObjectRegion region) {
        return false;
    }

    protected boolean _hasSyntaxError(NodeEObjectRegion region) {
        INode _node = region.getNode();
        BidiTreeIterable _asTreeIterable = _node.getAsTreeIterable();
        for (INode _next : _asTreeIterable) {
            boolean _notEquals;
            SyntaxErrorMessage _syntaxErrorMessage = _next.getSyntaxErrorMessage();
            boolean bl = _notEquals = !Objects.equal((Object)_syntaxErrorMessage, null);
            if (!_notEquals) continue;
            return true;
        }
        return false;
    }

    protected void setNewLines(IFormattableDocument doc, int offset, int length, final int indentationIncrease, final int indentationDecrease, final int newLines) {
        AbstractFormatter2 _formatter = doc.getFormatter();
        IHiddenRegionFormatting _createHiddenRegionFormatting = _formatter.createHiddenRegionFormatting();
        Procedures.Procedure1<IHiddenRegionFormatting> _function = new Procedures.Procedure1<IHiddenRegionFormatting>(){

            public void apply(IHiddenRegionFormatting it) {
                it.setIndentationIncrease(Integer.valueOf(indentationIncrease));
                it.setIndentationDecrease(Integer.valueOf(indentationDecrease));
                it.setNewLinesMin(Integer.valueOf(newLines));
                it.setNewLinesDefault(Integer.valueOf(newLines));
                it.setNewLinesMax(Integer.valueOf(newLines));
            }
        };
        IHiddenRegionFormatting fmt = (IHiddenRegionFormatting)ObjectExtensions.operator_doubleArrow((Object)_createHiddenRegionFormatting, (Procedures.Procedure1)_function);
        AbstractFormatter2 _formatter_1 = doc.getFormatter();
        ITextRegionAccess _textRegionAccess = this._iTextRegionExtensions.getTextRegionAccess();
        TextSegment _textSegment = new TextSegment(_textRegionAccess, offset, length);
        ITextReplacer replacer = _formatter_1.createWhitespaceReplacer((ITextSegment)_textSegment, fmt);
        doc.addReplacer(replacer);
    }

    protected void setSpace(IFormattableDocument doc, int offset, int length, final String space) {
        AbstractFormatter2 _formatter = doc.getFormatter();
        IHiddenRegionFormatting _createHiddenRegionFormatting = _formatter.createHiddenRegionFormatting();
        Procedures.Procedure1<IHiddenRegionFormatting> _function = new Procedures.Procedure1<IHiddenRegionFormatting>(){

            public void apply(IHiddenRegionFormatting it) {
                it.setSpace(space);
            }
        };
        IHiddenRegionFormatting fmt = (IHiddenRegionFormatting)ObjectExtensions.operator_doubleArrow((Object)_createHiddenRegionFormatting, (Procedures.Procedure1)_function);
        AbstractFormatter2 _formatter_1 = doc.getFormatter();
        ITextRegionAccess _textRegionAccess = this._iTextRegionExtensions.getTextRegionAccess();
        TextSegment _textSegment = new TextSegment(_textRegionAccess, offset, length);
        ITextReplacer replacer = _formatter_1.createWhitespaceReplacer((ITextSegment)_textSegment, fmt);
        doc.addReplacer(replacer);
    }

    protected void _format(RichStringLiteral expr, IFormattableDocument doc) {
    }

    protected void _format(Void expr, IFormattableDocument doc) {
    }

    protected void formatIntoSingleLine(IFormattableDocument doc, EObject obj) {
        AbstractFormatter2 _formatter = doc.getFormatter();
        Predicate<ITextReplacer> _function = new Predicate<ITextReplacer>(){

            public boolean apply(ITextReplacer it) {
                boolean _xblockexpression = false;
                RichStringFormatter.this.suppressLineWraps(it);
                _xblockexpression = true;
                return _xblockexpression;
            }
        };
        IFormattableDocument _withReplacerFilter = doc.withReplacerFilter((Predicate)_function);
        _formatter.format((Object)obj, _withReplacerFilter);
    }

    protected void _suppressLineWraps(ITextReplacer it) {
    }

    protected void _suppressLineWraps(HiddenRegionReplacer it) {
        IHiddenRegionFormatting _formatting = it.getFormatting();
        this.suppressLineWraps(_formatting);
    }

    protected void _suppressLineWraps(IHiddenRegionFormatting it) {
        String _space = it.getSpace();
        boolean _equals = Objects.equal((Object)_space, null);
        if (_equals) {
            it.setSpace(" ");
        }
        it.setNewLinesMin(null);
        it.setNewLinesDefault(null);
        it.setNewLinesMax(null);
        it.setAutowrap(null);
    }

    protected void _format(XExpression expr, @Extension IFormattableDocument doc) {
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        doc.surround((EObject)expr, (Procedures.Procedure1)_function);
        this.formatIntoSingleLine(doc, (EObject)expr);
    }

    protected void _format(RichStringIf expr, @Extension IFormattableDocument doc) {
        ISemanticRegionsFinder _regionFor = this._iTextRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword = _regionFor.keyword("IF");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        ISemanticRegion _prepend = doc.prepend(_keyword, (Procedures.Procedure1)_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        doc.append(_prepend, (Procedures.Procedure1)_function_1);
        EList<RichStringElseIf> _elseIfs = expr.getElseIfs();
        RichStringElseIf _last = (RichStringElseIf)IterableExtensions.last(_elseIfs);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        doc.append((EObject)_last, (Procedures.Procedure1)_function_2);
        XExpression _if = expr.getIf();
        this.formatIntoSingleLine(doc, (EObject)_if);
        XExpression _then = expr.getThen();
        this.format((EObject)_then, doc);
        EList<RichStringElseIf> _elseIfs_1 = expr.getElseIfs();
        for (RichStringElseIf elseif : _elseIfs_1) {
            this.format(elseif, doc);
        }
        ISemanticRegionsFinder _regionFor_1 = this._iTextRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_1 = _regionFor_1.keyword("ELSE");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        doc.surround(_keyword_1, (Procedures.Procedure1)_function_3);
        XExpression _else = expr.getElse();
        this.format((EObject)_else, doc);
        ISemanticRegionsFinder _regionFor_2 = this._iTextRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_2 = _regionFor_2.keyword("ENDIF");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_4 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        doc.surround(_keyword_2, (Procedures.Procedure1)_function_4);
    }

    protected void _format(RichStringElseIf expr, @Extension IFormattableDocument doc) {
        ISemanticRegionsFinder _regionFor = this._iTextRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword = _regionFor.keyword("ELSEIF");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        ISemanticRegion _prepend = doc.prepend(_keyword, (Procedures.Procedure1)_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        doc.append(_prepend, (Procedures.Procedure1)_function_1);
        XExpression _if = expr.getIf();
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        doc.append((EObject)_if, (Procedures.Procedure1)_function_2);
        XExpression _if_1 = expr.getIf();
        this.formatIntoSingleLine(doc, (EObject)_if_1);
    }

    protected void _format(RichStringForLoop expr, @Extension IFormattableDocument doc) {
        ISemanticRegionsFinder _regionFor = this._iTextRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword = _regionFor.keyword("FOR");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        ISemanticRegion _prepend = doc.prepend(_keyword, (Procedures.Procedure1)_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        doc.append(_prepend, (Procedures.Procedure1)_function_1);
        ISemanticRegionsFinder _regionFor_1 = this._iTextRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_1 = _regionFor_1.keyword(":");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        ISemanticRegion _prepend_1 = doc.prepend(_keyword_1, (Procedures.Procedure1)_function_2);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        doc.append(_prepend_1, (Procedures.Procedure1)_function_3);
        JvmFormalParameter _declaredParam = expr.getDeclaredParam();
        this.formatIntoSingleLine(doc, (EObject)_declaredParam);
        XExpression _forExpression = expr.getForExpression();
        this.formatIntoSingleLine(doc, (EObject)_forExpression);
        XExpression _eachExpression = expr.getEachExpression();
        this.format((EObject)_eachExpression, doc);
        ISemanticRegionsFinder _regionFor_2 = this._iTextRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_2 = _regionFor_2.keyword("BEFORE");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_4 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        doc.surround(_keyword_2, (Procedures.Procedure1)_function_4);
        XExpression _before = expr.getBefore();
        this.formatIntoSingleLine(doc, (EObject)_before);
        ISemanticRegionsFinder _regionFor_3 = this._iTextRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_3 = _regionFor_3.keyword("SEPARATOR");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_5 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        doc.surround(_keyword_3, (Procedures.Procedure1)_function_5);
        XExpression _separator = expr.getSeparator();
        this.formatIntoSingleLine(doc, (EObject)_separator);
        ISemanticRegionsFinder _regionFor_4 = this._iTextRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_4 = _regionFor_4.keyword("AFTER");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_6 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        doc.surround(_keyword_4, (Procedures.Procedure1)_function_6);
        XExpression _after = expr.getAfter();
        this.formatIntoSingleLine(doc, (EObject)_after);
        XExpression _eachExpression_1 = expr.getEachExpression();
        Procedures.Procedure1<IHiddenRegionFormatter> _function_7 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        doc.prepend((EObject)_eachExpression_1, (Procedures.Procedure1)_function_7);
        ISemanticRegionsFinder _regionFor_5 = this._iTextRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_5 = _regionFor_5.keyword("ENDFOR");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_8 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        doc.surround(_keyword_5, (Procedures.Procedure1)_function_8);
    }

    public void format(EObject richString, IFormattableDocument doc) {
        if (richString instanceof RichString) {
            this._format((RichString)richString, doc);
            return;
        }
        if (richString instanceof RichStringForLoop) {
            this._format((RichStringForLoop)richString, doc);
            return;
        }
        if (richString instanceof RichStringLiteral) {
            this._format((RichStringLiteral)richString, doc);
            return;
        }
        if (richString instanceof RichStringIf) {
            this._format((RichStringIf)richString, doc);
            return;
        }
        if (richString instanceof RichStringElseIf) {
            this._format((RichStringElseIf)richString, doc);
            return;
        }
        if (richString instanceof XExpression) {
            this._format((XExpression)richString, doc);
            return;
        }
        if (richString == null) {
            this._format((Void)null, doc);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(richString, doc).toString());
    }

    protected boolean hasSyntaxError(IEObjectRegion region) {
        if (region instanceof NodeEObjectRegion) {
            return this._hasSyntaxError((NodeEObjectRegion)region);
        }
        if (region != null) {
            return this._hasSyntaxError(region);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(region).toString());
    }

    protected void suppressLineWraps(Object it) {
        if (it instanceof HiddenRegionReplacer) {
            this._suppressLineWraps((HiddenRegionReplacer)it);
            return;
        }
        if (it instanceof IHiddenRegionFormatting) {
            this._suppressLineWraps((IHiddenRegionFormatting)it);
            return;
        }
        if (it instanceof ITextReplacer) {
            this._suppressLineWraps((ITextReplacer)it);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    public RichStringFormatter(Factory factory, ITextRegionExtensions _iTextRegionExtensions) {
        this.factory = factory;
        this._iTextRegionExtensions = _iTextRegionExtensions;
    }

    public static class Factory {
        @Inject
        private RichStringProcessor richStringProcessor;

        public RichStringFormatter create(ITextRegionAccess regionAccess) {
            ITextRegionExtensions _extensions = regionAccess.getExtensions();
            return new RichStringFormatter(this, _extensions);
        }
    }
}

