/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.acceptor;

import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.parsetree.reconstr.ITokenStream;
import org.eclipse.xtext.parsetree.reconstr.ITokenStreamExtension;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;

public class TokenStreamSequenceAdapter
implements ISequenceAcceptor {
    protected ISerializationDiagnostic.Acceptor errorAcceptor;
    protected ITokenStream out;
    protected Grammar grammar;

    public TokenStreamSequenceAdapter(ITokenStream out, Grammar grammar, ISerializationDiagnostic.Acceptor errorAcceptor) {
        this.out = out;
        this.grammar = grammar;
        this.errorAcceptor = errorAcceptor;
    }

    @Override
    public void acceptAssignedCrossRefDatatype(RuleCall rc, String token, EObject value, int index, ICompositeNode node) {
        this.writeSemantic(GrammarUtil.containingCrossReference(rc), token);
    }

    @Override
    public void acceptAssignedCrossRefEnum(RuleCall enumRC, String token, EObject value, int index, ICompositeNode node) {
        this.writeSemantic(GrammarUtil.containingCrossReference(enumRC), token);
    }

    @Override
    public void acceptAssignedCrossRefKeyword(Keyword kw, String token, EObject value, int index, ILeafNode node) {
        this.writeSemantic(GrammarUtil.containingCrossReference(kw), token);
    }

    @Override
    public void acceptAssignedCrossRefTerminal(RuleCall rc, String token, EObject value, int index, ILeafNode node) {
        this.writeSemantic(GrammarUtil.containingCrossReference(rc), token);
    }

    @Override
    public void acceptAssignedDatatype(RuleCall datatypeRC, String token, Object value, int index, ICompositeNode node) {
        this.writeSemantic(datatypeRC, token);
    }

    @Override
    public void acceptAssignedEnum(RuleCall enumRC, String token, Object value, int index, ICompositeNode node) {
        this.writeSemantic(enumRC, token);
    }

    @Override
    public void acceptAssignedKeyword(Keyword keyword, String token, Object value, int index, ILeafNode node) {
        this.writeSemantic(keyword, token);
    }

    @Override
    public void acceptAssignedTerminal(RuleCall terminalRC, String token, Object value, int index, ILeafNode node) {
        this.writeSemantic(terminalRC, token);
    }

    @Override
    public void acceptComment(AbstractRule rule, String token, ILeafNode node) {
        this.writeHidden(rule, token);
    }

    @Override
    public void acceptUnassignedAction(Action action) {
    }

    @Override
    public void acceptUnassignedDatatype(RuleCall datatypeRC, String token, ICompositeNode node) {
        this.writeSemantic(datatypeRC, token);
    }

    @Override
    public void acceptUnassignedEnum(RuleCall enumRC, String token, ICompositeNode node) {
        this.writeSemantic(enumRC, token);
    }

    @Override
    public void acceptUnassignedKeyword(Keyword keyword, String token, ILeafNode node) {
        this.writeSemantic(keyword, token);
    }

    @Override
    public void acceptUnassignedTerminal(RuleCall terminalRC, String token, ILeafNode node) {
        this.writeSemantic(terminalRC, token);
    }

    @Override
    public void acceptWhitespace(AbstractRule rule, String token, ILeafNode node) {
        this.writeHidden(rule, token);
    }

    @Override
    public boolean enterAssignedAction(Action action, EObject semanticChild, ICompositeNode node) {
        return true;
    }

    @Override
    public boolean enterAssignedParserRuleCall(RuleCall rc, EObject newCurrent, ICompositeNode node) {
        return true;
    }

    @Override
    public void enterUnassignedParserRuleCall(RuleCall rc) {
    }

    @Override
    public void finish() {
    }

    protected void flush() {
        block2: {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                if (this.errorAcceptor == null) break block2;
                this.errorAcceptor.accept(new ISerializationDiagnostic.ExceptionDiagnostic(this.grammar, e));
            }
        }
    }

    @Deprecated
    public void init(EObject context) {
        if (context instanceof ParserRule && this.out instanceof ITokenStreamExtension) {
            ((ITokenStreamExtension)this.out).init((ParserRule)context);
        }
    }

    public void init(ISerializationContext context) {
        if (context instanceof ParserRule && this.out instanceof ITokenStreamExtension) {
            ((ITokenStreamExtension)this.out).init(context.getParserRule());
        }
    }

    @Override
    public void leaveAssignedAction(Action action, EObject semanticChild) {
    }

    public void leaveAssignedParserRuleCall(RuleCall rc) {
    }

    @Override
    public void leaveAssignedParserRuleCall(RuleCall rc, EObject semanticChild) {
    }

    @Override
    public void leaveUnssignedParserRuleCall(RuleCall rc) {
    }

    protected void writeHidden(EObject grammarElement, String value) {
        block2: {
            try {
                this.out.writeHidden(grammarElement, value);
            }
            catch (IOException e) {
                if (this.errorAcceptor == null) break block2;
                this.errorAcceptor.accept(new ISerializationDiagnostic.ExceptionDiagnostic(this.grammar, e));
            }
        }
    }

    protected void writeSemantic(EObject grammarElement, String value) {
        block2: {
            try {
                this.out.writeSemantic(grammarElement, value);
            }
            catch (IOException e) {
                if (this.errorAcceptor == null) break block2;
                this.errorAcceptor.accept(new ISerializationDiagnostic.ExceptionDiagnostic(this.grammar, e));
            }
        }
    }
}

