/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.tasks;

import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.xtext.tasks.Priority;
import org.eclipse.xtext.tasks.Task;

public class TaskMarkerCreator {
    public void createMarker(Task task, IResource resource, String markerType) throws CoreException {
        IMarker marker = resource.createMarker(markerType);
        this.setMarkerAttributes(task, resource, marker);
    }

    protected void setMarkerAttributes(Task task, IResource resource, IMarker marker) throws CoreException {
        HashMap<String, Object> attributes = new HashMap<String, Object>(8);
        attributes.put("location", "line " + task.getLineNumber());
        attributes.put("priority", this.getPriority(task.getTag().getPriority()));
        attributes.put("message", task.getFullText());
        attributes.put("lineNumber", task.getLineNumber());
        attributes.put("charStart", task.getOffset());
        attributes.put("charEnd", task.getOffset() + task.getTotalLength());
        attributes.put("userEditable", false);
        marker.setAttributes(attributes);
    }

    private int getPriority(Priority priority) {
        switch (priority) {
            case HIGH: {
                return 2;
            }
            case NORMAL: {
                return 1;
            }
            case LOW: {
                return 0;
            }
        }
        return 1;
    }
}

