/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.ide;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.ide.editor.hierarchy.AbstractHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNodeReference;
import org.eclipse.xtext.junit4.validation.ValidationTestHelper;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.findrefs.SimpleLocalResourceAccess;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.junit.Assert;

@Deprecated(forRemoval=true, since="2.30")
public abstract class AbstractHierarchyBuilderTest {
    @Inject
    private ValidationTestHelper validationTestHelper;
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private IResourceDescriptionsProvider resourceDescriptionsProvider;

    protected void testBuildHierarchy(Procedures.Procedure1<? super HierarchyBuilderTestConfiguration> configurator) {
        HierarchyBuilderTestConfiguration configuration = new HierarchyBuilderTestConfiguration();
        configurator.apply((Object)configuration);
        ResourceSet resourceSet = this.createResourceSet(configuration);
        IHierarchyBuilder hierarchyBuilder = (IHierarchyBuilder)configuration.hierarchyBuilderProvider.apply((Object)resourceSet);
        String resourceURI = null;
        resourceURI = configuration.resourceURI == null ? (String)((Pair)Iterables.getLast(configuration.models, null)).getKey() : configuration.resourceURI;
        XtextResource resource = (XtextResource)resourceSet.getResource(URI.createURI((String)resourceURI), false);
        URI rootURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)this.eObjectAtOffsetHelper.resolveElementAt(resource, configuration.index));
        String actualHierarchy = this.toExpectation(rootURI, hierarchyBuilder);
        Assert.assertEquals((Object)configuration.expectedHierarchy, (Object)actualHierarchy);
    }

    protected ResourceSet createResourceSet(HierarchyBuilderTestConfiguration configuration) {
        try {
            XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
            for (Pair<String, String> model : configuration.models) {
                Resource resource = resourceSet.createResource(URI.createURI((String)((String)model.getKey())));
                resource.load((InputStream)new LazyStringInputStream((String)model.getValue(), "UTF-8"), null);
                this.validationTestHelper.assertNoIssues(resource);
            }
            return resourceSet;
        }
        catch (IOException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }

    protected <T extends AbstractHierarchyBuilder> T configureBuilderWith(T hierarchyBuilder, ResourceSet resourceSet) {
        hierarchyBuilder.setResourceAccess((IReferenceFinder.IResourceAccess)new SimpleLocalResourceAccess(resourceSet));
        hierarchyBuilder.setIndexData(this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet));
        return hierarchyBuilder;
    }

    protected String toExpectation(URI rootURI, IHierarchyBuilder builder) {
        StringConcatenation richString = new StringConcatenation();
        for (IHierarchyNode root : builder.buildRoots(rootURI, null)) {
            richString.append(this.toExpectation(root, builder));
            richString.newLineIfNotEmpty();
        }
        return richString.toString();
    }

    protected String toExpectation(IHierarchyNode node, IHierarchyBuilder builder) {
        StringConcatenation richString = new StringConcatenation();
        richString.append((Object)node.getElement());
        richString.append(" {");
        richString.newLineIfNotEmpty();
        richString.append("\t");
        richString.append(this.internalToExpectation(node, builder), "\t");
        richString.newLineIfNotEmpty();
        richString.append("}");
        richString.newLine();
        return richString.toString();
    }

    protected String internalToExpectation(IHierarchyNode node, IHierarchyBuilder builder) {
        StringConcatenation richString = new StringConcatenation();
        for (IHierarchyNodeReference location : node.getReferences()) {
            richString.append(this.toExpectation(location));
            richString.newLineIfNotEmpty();
        }
        if (node.mayHaveChildren()) {
            for (IHierarchyNode childNode : builder.buildChildren(node, null)) {
                richString.append(this.toExpectation(childNode, builder));
                richString.newLineIfNotEmpty();
            }
        }
        return richString.toString();
    }

    protected String toExpectation(IHierarchyNodeReference location) {
        StringConcatenation richString = new StringConcatenation();
        richString.append("'");
        richString.append(location.getText());
        richString.append("' [");
        richString.append((Object)location.getOffset());
        richString.append(", ");
        richString.append((Object)location.getLength());
        richString.append("]");
        return richString.toString();
    }

    protected static class HierarchyBuilderTestConfiguration {
        private Functions.Function1<? super ResourceSet, ? extends IHierarchyBuilder> hierarchyBuilderProvider;
        private Collection<Pair<String, String>> models = new ArrayList<Pair<String, String>>();
        private int index;
        private String resourceURI;
        private String expectedHierarchy;

        protected HierarchyBuilderTestConfiguration() {
        }

        public Functions.Function1<? super ResourceSet, ? extends IHierarchyBuilder> getHierarchyBuilderProvider() {
            return this.hierarchyBuilderProvider;
        }

        public void setHierarchyBuilderProvider(Functions.Function1<? super ResourceSet, ? extends IHierarchyBuilder> hierarchyBuilderProvider) {
            this.hierarchyBuilderProvider = hierarchyBuilderProvider;
        }

        public Collection<Pair<String, String>> getModels() {
            return this.models;
        }

        public void setModels(Collection<Pair<String, String>> models) {
            this.models = models;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getResourceURI() {
            return this.resourceURI;
        }

        public void setResourceURI(String resourceURI) {
            this.resourceURI = resourceURI;
        }

        public String getExpectedHierarchy() {
            return this.expectedHierarchy;
        }

        public void setExpectedHierarchy(String expectedHierarchy) {
            this.expectedHierarchy = expectedHierarchy;
        }
    }
}

