/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ComparisonFailure;

@Deprecated(forRemoval=true, since="2.30")
public abstract class AbstractPortableURIsTest
extends URIHandlerImpl.PlatformSchemeAware {
    private ResourceSet resourceSet;

    @Before
    public void setUp() throws Exception {
        this.resourceSet = new XtextResourceSet();
        this.resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        this.resourceSet.getLoadOptions().put("URI_HANDLER", this);
    }

    @After
    public void tearDown() {
        this.resourceSet = null;
    }

    public URI resolve(URI uri) {
        this.assertPortableURI(uri);
        return super.resolve(uri);
    }

    protected void doTestResource(String platformPath, String ... packageNames) {
        Resource resource = this.resourceSet.getResource(URI.createPlatformPluginURI((String)platformPath, (boolean)false), true);
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((long)1L, (long)resource.getContents().size());
        EObject obj = (EObject)resource.getContents().get(0);
        if (obj instanceof EPackage) {
            Assert.assertEquals((Object)packageNames[0], (Object)((EPackage)obj).getName());
        } else if (obj instanceof GenModel) {
            GenModel model = (GenModel)obj;
            ArrayList packages = Lists.newArrayList((Iterable)model.getGenPackages());
            Assert.assertEquals((long)packageNames.length, (long)packages.size());
            ListExtensions.sortInplaceBy((List)packages, (Functions.Function1)new Functions.Function1<GenPackage, String>(){

                public String apply(GenPackage p) {
                    return p.getEcorePackage().getName();
                }
            });
            List<String> packageNamesList = Arrays.asList(packageNames);
            Collections.sort(packageNamesList);
            int i = 0;
            while (i < packageNamesList.size()) {
                Assert.assertEquals((Object)packageNamesList.get(i), (Object)((GenPackage)packages.get(i)).getEcorePackage().getName());
                ++i;
            }
            IStatus status = model.validate();
            Assert.assertTrue((String)this.printLeafs(status), (boolean)status.isOK());
            EObject orig = EcoreUtil.copy((EObject)obj);
            ((GenModel)obj).reconcile();
            if (!EcoreUtil.equals((EObject)orig, (EObject)obj)) {
                Predicate<EStructuralFeature> ignoreContainer = new Predicate<EStructuralFeature>(){

                    public boolean apply(EStructuralFeature f) {
                        if (f instanceof EReference) {
                            EReference casted = (EReference)f;
                            return !casted.isContainment();
                        }
                        return false;
                    }
                };
                String origAsString = EmfFormatter.objToStr((Object)orig, (Predicate)ignoreContainer);
                String newAsString = EmfFormatter.objToStr((Object)obj, (Predicate)ignoreContainer);
                throw new ComparisonFailure("Reconcile changed model", origAsString, newAsString);
            }
        } else {
            Assert.fail((String)("Unexpected root element type: " + obj.eClass().getName()));
        }
    }

    protected String printLeafs(IStatus status) {
        StringBuilder result = new StringBuilder();
        this.appendLeafs(status, result);
        return result.toString();
    }

    protected void appendLeafs(IStatus status, StringBuilder result) {
        IStatus[] children;
        if (status.isOK()) {
            return;
        }
        result.append(status.getMessage()).append('\n');
        IStatus[] iStatusArray = children = status.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            this.appendLeafs(child, result);
            ++n2;
        }
    }

    protected void assertPortableURI(URI uri) {
        if (uri.isRelative()) {
            String path = uri.path();
            Assert.assertFalse((String)(String.valueOf(uri.toString()) + " is not portable"), (boolean)path.startsWith(".."));
        }
    }
}

