/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.refactoring;

import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.xtext.common.types.ui.refactoring.JdtRefactoringContext;
import org.eclipse.xtext.ui.refactoring.impl.DefaultRenameRefactoringProvider;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;

public class JvmRenameRefactoringProvider
extends DefaultRenameRefactoringProvider {
    public ProcessorBasedRefactoring getRenameRefactoring(IRenameElementContext renameElementContext) {
        IJavaElement javaElement;
        if (renameElementContext instanceof JdtRefactoringContext && this.isJavaSource(javaElement = ((JdtRefactoringContext)renameElementContext).getJavaElement())) {
            try {
                RenameJavaElementDescriptor renameDescriptor = this.createRenameDescriptor(javaElement, javaElement.getElementName());
                return (ProcessorBasedRefactoring)renameDescriptor.createRefactoring(new RefactoringStatus());
            }
            catch (Exception exc) {
                throw new WrappedException(exc);
            }
        }
        return super.getRenameRefactoring(renameElementContext);
    }

    protected boolean isJavaSource(IJavaElement javaElement) {
        return "java".equals(javaElement.getResource().getFileExtension());
    }

    public RenameJavaElementDescriptor createRenameDescriptor(IJavaElement javaElement, String newName) throws JavaModelException {
        IDialogSettings javaSettings;
        IDialogSettings refactoringSettings;
        String contributionId;
        int elementType = javaElement.getElementType();
        switch (elementType) {
            case 2: {
                contributionId = "org.eclipse.jdt.ui.rename.java.project";
                break;
            }
            case 3: {
                contributionId = "org.eclipse.jdt.ui.rename.source.folder";
                break;
            }
            case 4: {
                contributionId = "org.eclipse.jdt.ui.rename.package";
                break;
            }
            case 5: {
                contributionId = "org.eclipse.jdt.ui.rename.compilationunit";
                break;
            }
            case 7: {
                contributionId = "org.eclipse.jdt.ui.rename.type";
                break;
            }
            case 9: {
                IMethod method = (IMethod)javaElement;
                if (method.isConstructor()) {
                    return this.createRenameDescriptor((IJavaElement)method.getDeclaringType(), newName);
                }
                contributionId = "org.eclipse.jdt.ui.rename.method";
                break;
            }
            case 8: {
                IField field = (IField)javaElement;
                if (field.isEnumConstant()) {
                    contributionId = "org.eclipse.jdt.ui.rename.enum.constant";
                    break;
                }
                contributionId = "org.eclipse.jdt.ui.rename.field";
                break;
            }
            case 15: {
                contributionId = "org.eclipse.jdt.ui.rename.type.parameter";
                break;
            }
            case 14: {
                contributionId = "org.eclipse.jdt.ui.rename.local.variable";
                break;
            }
            default: {
                return null;
            }
        }
        RenameJavaElementDescriptor descriptor = (RenameJavaElementDescriptor)RefactoringCore.getRefactoringContribution((String)contributionId).createDescriptor();
        descriptor.setJavaElement(javaElement);
        descriptor.setNewName(newName);
        if (elementType != 3) {
            descriptor.setUpdateReferences(true);
        }
        if ((refactoringSettings = (javaSettings = JavaPlugin.getDefault().getDialogSettings()).getSection("org.eclipse.ltk.ui.refactoring.settings")) == null) {
            refactoringSettings = javaSettings.addNewSection("org.eclipse.ltk.ui.refactoring.settings");
        }
        switch (elementType) {
            case 8: 
            case 9: {
                descriptor.setDeprecateDelegate(refactoringSettings.getBoolean("delegateDeprecation"));
                descriptor.setKeepOriginal(refactoringSettings.getBoolean("delegateUpdating"));
            }
        }
        switch (elementType) {
            case 7: {
                int strategy;
                descriptor.setUpdateSimilarDeclarations(refactoringSettings.getBoolean("updateSimilarElements"));
                try {
                    strategy = refactoringSettings.getInt("updateSimilarElementsMatchStrategy");
                }
                catch (NumberFormatException e) {
                    strategy = 1;
                }
                descriptor.setMatchStrategy(strategy);
            }
        }
        switch (elementType) {
            case 4: {
                descriptor.setUpdateHierarchy(refactoringSettings.getBoolean("renameSubpackages"));
            }
        }
        switch (elementType) {
            case 4: 
            case 7: {
                String fileNamePatterns = refactoringSettings.get("patterns");
                if (fileNamePatterns == null || fileNamePatterns.length() == 0) break;
                descriptor.setFileNamePatterns(fileNamePatterns);
                boolean updateQualifiedNames = refactoringSettings.getBoolean("updateQualifiedNames");
                descriptor.setUpdateQualifiedNames(updateQualifiedNames);
            }
        }
        switch (elementType) {
            case 4: 
            case 7: 
            case 8: {
                boolean updateTextualOccurrences = refactoringSettings.getBoolean("updateTextualMatches");
                descriptor.setUpdateTextualOccurrences(updateTextualOccurrences);
            }
        }
        switch (elementType) {
            case 8: {
                descriptor.setRenameGetters(refactoringSettings.getBoolean("renameGetter"));
                descriptor.setRenameSetters(refactoringSettings.getBoolean("renameSetter"));
            }
        }
        return descriptor;
    }
}

