/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util.jdt;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifyableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.util.TypesSwitch;
import org.eclipse.xtext.common.types.util.jdt.IJavaElementFinder;

public class JavaElementFinder
implements IJavaElementFinder {
    @Inject
    private IJavaProjectProvider projectProvider;

    public IJavaElement findElementFor(JvmIdentifyableElement element) {
        if (element == null || element.eResource() == null) {
            return null;
        }
        Implementation implementation = new Implementation(this.projectProvider.getJavaProject(element.eResource().getResourceSet()));
        IJavaElement result = implementation.doSwitch((EObject)element);
        return result;
    }

    public void setProjectProvider(IJavaProjectProvider projectProvider) {
        this.projectProvider = projectProvider;
    }

    public IJavaProjectProvider getProjectProvider() {
        return this.projectProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Implementation
    extends TypesSwitch<IJavaElement> {
        private final IJavaProject javaProject;

        public Implementation(IJavaProject javaProject) {
            this.javaProject = javaProject;
        }

        public IJavaElement caseJvmPrimitiveType(JvmPrimitiveType object) {
            return null;
        }

        public IJavaElement caseJvmArrayType(JvmArrayType object) {
            return this.doSwitch((EObject)object.getComponentType());
        }

        public IJavaElement caseJvmMember(JvmMember object) {
            if (object.getDeclaringType() != null) {
                IJavaElement typeElement = this.doSwitch((EObject)object.getDeclaringType());
                return typeElement;
            }
            return null;
        }

        public IJavaElement caseJvmField(JvmField object) {
            IType type;
            IField result;
            IJavaElement parent = this.caseJvmMember((JvmMember)object);
            if (parent instanceof IType && (result = (type = (IType)parent).getField(object.getSimpleName())) != null) {
                return result;
            }
            return parent;
        }

        public IJavaElement caseJvmOperation(JvmOperation object) {
            IJavaElement parent = this.caseJvmMember((JvmMember)object);
            if (parent instanceof IType) {
                IType type = (IType)parent;
                try {
                    IMethod[] iMethodArray = type.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method = iMethodArray[n2];
                        if (!method.isConstructor() && object.getSimpleName().equals(method.getElementName()) && object.getParameters().size() == method.getNumberOfParameters()) {
                            int numberOfParameters = method.getNumberOfParameters();
                            String[] parameterTypes = method.getParameterTypes();
                            boolean match = true;
                            int i = 0;
                            while (i < numberOfParameters && match) {
                                String[][] resolved;
                                JvmFormalParameter formalParameter = (JvmFormalParameter)object.getParameters().get(i);
                                String parameterType = parameterTypes[i];
                                String readable = Signature.toString((String)parameterType);
                                if (parameterType.startsWith("Q") && (resolved = type.resolveType(readable)) != null && resolved.length == 1) {
                                    readable = resolved[0][0];
                                    readable = readable != null && readable.length() >= 1 ? String.valueOf(readable) + '.' + resolved[0][1] : resolved[0][1];
                                }
                                if (!readable.equals(formalParameter.getParameterType().getCanonicalName())) {
                                    match = false;
                                }
                                ++i;
                            }
                            if (match) {
                                return method;
                            }
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    return parent;
                }
            }
            return parent;
        }

        public IJavaElement caseJvmConstructor(JvmConstructor object) {
            IJavaElement parent = this.caseJvmMember((JvmMember)object);
            if (parent instanceof IType) {
                IType type = (IType)parent;
                try {
                    IMethod[] iMethodArray = type.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method = iMethodArray[n2];
                        if (method.isConstructor()) {
                            int numberOfParameters = method.getNumberOfParameters();
                            String[] parameterTypes = method.getParameterTypes();
                            boolean match = true;
                            int i = 0;
                            while (i < numberOfParameters && match) {
                                JvmFormalParameter formalParameter = (JvmFormalParameter)object.getParameters().get(i);
                                String parameterType = parameterTypes[i];
                                String readable = Signature.toString((String)parameterType);
                                if (!readable.equals(formalParameter.getParameterType().getCanonicalName())) {
                                    match = false;
                                }
                                ++i;
                            }
                            if (match) {
                                return method;
                            }
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    return parent;
                }
            }
            return parent;
        }

        public IJavaElement caseJvmDeclaredType(JvmDeclaredType object) {
            try {
                String fullyQualifiedName = object.getFullyQualifiedName();
                IType result = this.javaProject.findType(fullyQualifiedName);
                return result;
            }
            catch (JavaModelException e) {
                return null;
            }
        }

        public IJavaElement doSwitch(EObject theEObject) {
            if (this.javaProject == null) {
                return null;
            }
            return (IJavaElement)super.doSwitch(theEObject);
        }
    }
}

