/*****************************************************************************
 * Copyright (c) 2009 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Remi Schnekenburger (CEA LIST) - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.uml.diagram.component.custom.preferences;

import org.eclipse.uml2.uml.Property;



/**
 * Constants for {@link Property} preferences.
 * @since 3.0
 */
public interface IPapyrusPropertyPreferencesConstant {

	/** Preference id for {@link Property} display label. */
	public String LABEL_DISPLAY_PREFERENCE = "Property.label.display"; //$NON-NLS-1$

	/** Preference id for {@link Property} display label. */
	public String PREF_FONT = "Property.font"; //$NON-NLS-1$

	/** Preference id for {@link Property} display label. */
	public String PREF_FONT_COLOR = "Property.font.color"; //$NON-NLS-1$

	/** Preference id for {@link Property} display label. */
	public String PREF_LINE_COLOR = "Property.line.color"; //$NON-NLS-1$
}
