/*
 * generated by Xtext
 */
package org.eclipse.papyrus.infra.gmfdiag.css3.formatting2;

import com.google.inject.Inject
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CssSelector
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CssTok
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.FuncTok
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.PseudoClassFunction
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.SimpleSelectorForNegation
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.UrlTok
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.charset
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.css_declaration
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.font_face
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.importExpression
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.keyframe_selector
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.keyframes
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.media
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.page
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ruleset
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.selector
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.simple_selector
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.stylesheet
import org.eclipse.papyrus.infra.gmfdiag.css3.services.CSSGrammarAccess
import org.eclipse.xtext.formatting2.IFormattableDocument

class CSSFormatter extends AbstractCSSFormatter {
	
	@Inject extension CSSGrammarAccess

	def dispatch void format(stylesheet stylesheet, extension IFormattableDocument document) {
		
		if (textRegionAccess.hasSyntaxError){ //Avoid formatting invalid documents; this could introduce even more issues
			return;
		}

		format(stylesheet.getCharset(), document);
		for (importExpression imports : stylesheet.getImports()) {
			format(imports, document);
		}
		for (ruleset ruleset : stylesheet.getRuleset()) {
			format(ruleset, document);
		}
		for (media media : stylesheet.getMedia()) {
			format(media, document);
		}
		for (page page : stylesheet.getPage()) {
			format(page, document);
		}
		for (font_face font_face : stylesheet.getFont_face()) {
			format(font_face, document);
		}
		for (keyframes keyframes : stylesheet.getKeyframes()) {
			format(keyframes, document);
		}
	}
	
	def dispatch void format(charset charset, extension IFormattableDocument document) {
		charset.append[newLines = 2];
	}

	def dispatch void format(page page, extension IFormattableDocument document) {
		for (css_declaration declarations : page.getDeclarations()) {
			format(declarations, document);
		}
	}

	def dispatch void format(media media, extension IFormattableDocument document) {
		for (ruleset rulesets : media.getRulesets()) {
			format(rulesets, document);
		}
	}

	def dispatch void format(font_face font_face, extension IFormattableDocument document) {
		for (css_declaration declarations : font_face.getDeclarations()) {
			format(declarations, document);
		}
		for (keyframe_selector keyframeselectors : font_face.getKeyframeselectors()) {
			format(keyframeselectors, document);
		}
	}

	def dispatch void format(keyframe_selector keyframe_selector, extension IFormattableDocument document) {
		for (css_declaration declarations : keyframe_selector.getDeclarations()) {
			format(declarations, document);
		}
	}

	def dispatch void format(ruleset ruleset, extension IFormattableDocument document) {
		ruleset.regionFor.keyword("{").prepend[oneSpace].append[newLine]
		
		ruleset.interior[indent];
		
		for (semicolon : ruleset.regionFor.keywords(
			rulesetAccess.semicolonKeyword_4_1_0,
			rulesetAccess.semicolonKeyword_4_2
		)) {
			semicolon.nextHiddenRegion.set[newLines = 1]
		}
		
		ruleset.regionFor.keyword("}").prepend[newLine]
		ruleset.append[newLines = 2]
		for (selector selectors : ruleset.getSelectors()) {
			format(selectors, document);
		}
		for (css_declaration declarations : ruleset.getDeclarations()) {
			format(declarations, document);
		}
	}

	def dispatch void format(selector selector, extension IFormattableDocument document) {
		for (simple_selector simpleselectors : selector.getSimpleselectors()) {
			format(simpleselectors, document);
		}
		format(selector.getSelector(), document);
	}

	def dispatch void format(SimpleSelectorForNegation simpleselectorfornegation, extension IFormattableDocument document) {
		format(simpleselectorfornegation.getElement(), document);
		format(simpleselectorfornegation.getUniversal(), document);
		for (CssSelector subSelectors : simpleselectorfornegation.getSubSelectors()) {
			format(subSelectors, document);
		}
	}

	def dispatch void format(simple_selector simple_selector, extension IFormattableDocument document) {
		format(simple_selector.getElement(), document);
		format(simple_selector.getUniversal(), document);
		for (CssSelector subSelectors : simple_selector.getSubSelectors()) {
			format(subSelectors, document);
		}
	}

	def dispatch void format(css_declaration css_declaration, extension IFormattableDocument document) {
		css_declaration.prepend[indent]
		
		format(css_declaration.getProperty(), document);
		for (CssTok valueTokens : css_declaration.getValueTokens()) {
			format(valueTokens, document);
		}
	}

	def dispatch void format(PseudoClassFunction pseudoclassfunction, extension IFormattableDocument document) {
		format(pseudoclassfunction.getParamSelector(), document);
		for (CssTok params : pseudoclassfunction.getParams()) {
			format(params, document);
		}
	}

	def dispatch void format(UrlTok urltok, extension IFormattableDocument document) {
		format(urltok.getUrl(), document);
	}

	def dispatch void format(FuncTok functok, extension IFormattableDocument document) {
		for (CssTok params : functok.getParams()) {
			format(params, document);
		}
		format(functok.getName(), document);
	}
}
