/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common;

import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.PaletteViewerReloadContextProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.SynchronizableGmfDiagramEditor;
import org.eclipse.papyrus.infra.ui.editor.reload.EMFSelectionContext;
import org.eclipse.papyrus.infra.ui.editor.reload.IDisposableReloadContext;
import org.eclipse.papyrus.infra.ui.editor.reload.IReloadContextProvider;

class DiagramReloadContextProvider
implements IReloadContextProvider {
    private final SynchronizableGmfDiagramEditor editor;

    public DiagramReloadContextProvider(SynchronizableGmfDiagramEditor editor) {
        this.editor = editor;
    }

    public Object createReloadContext() {
        return new DiagramSelectionContext(this.editor);
    }

    public void restore(Object reloadContext) {
        ((DiagramSelectionContext)((Object)reloadContext)).restore(this.editor);
    }

    private static class DiagramSelectionContext
    extends EMFSelectionContext
    implements IDisposableReloadContext {
        private SynchronizableGmfDiagramEditor editor;
        private Object embeddedPaletteContext;
        private Object palettePageContext;

        DiagramSelectionContext(SynchronizableGmfDiagramEditor editor) {
            super((ISelectionProvider)editor.getDiagramGraphicalViewer());
            IReloadContextProvider pageProvider;
            PalettePage page;
            PaletteViewer embedded = this.getEmbeddedPalette(editor);
            if (embedded != null) {
                this.embeddedPaletteContext = PaletteViewerReloadContextProvider.getInstance(embedded).createReloadContext();
            }
            if ((page = (PalettePage)Iterables.getFirst(editor.getPalettePages(), null)) != null && (pageProvider = (IReloadContextProvider)AdapterUtils.adapt((Object)page, IReloadContextProvider.class, null)) != null) {
                this.palettePageContext = pageProvider.createReloadContext();
            }
        }

        public void dispose() {
            this.editor = null;
            this.embeddedPaletteContext = null;
            this.palettePageContext = null;
        }

        void restore(SynchronizableGmfDiagramEditor editor) {
            PaletteViewer palette;
            this.editor = editor;
            this.restore((ISelectionProvider)editor.getDiagramGraphicalViewer());
            if (this.embeddedPaletteContext != null && (palette = this.getEmbeddedPalette(editor)) != null) {
                PaletteViewerReloadContextProvider.getInstance(palette).restore(this.embeddedPaletteContext);
            }
            if (this.palettePageContext != null) {
                Collection<? extends PalettePage> pages = editor.getPalettePages();
                if (pages.isEmpty()) {
                    editor.setDeferredPalettePageReloadContext(this.palettePageContext);
                } else {
                    for (PalettePage palettePage : pages) {
                        IReloadContextProvider pageProvider = (IReloadContextProvider)AdapterUtils.adapt((Object)palettePage, IReloadContextProvider.class, null);
                        if (pageProvider == null) continue;
                        pageProvider.restore(this.palettePageContext);
                    }
                }
            }
        }

        protected Object deresolveSelectableElement(Object selectableElement) {
            Object model;
            Object result = null;
            if (selectableElement instanceof EditPart && (model = ((EditPart)selectableElement).getModel()) instanceof EObject) {
                result = model;
            }
            return result;
        }

        protected Object resolveSelectableElement(Object deresolved) {
            return this.editor.getDiagramGraphicalViewer().getEditPartRegistry().get(deresolved);
        }

        PaletteViewer getEmbeddedPalette(SynchronizableGmfDiagramEditor editor) {
            PaletteViewer result = null;
            if (editor.getDiagramEditDomain() instanceof EditDomain) {
                result = ((EditDomain)editor.getDiagramEditDomain()).getPaletteViewer();
            }
            return result;
        }
    }
}

