/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.ColumnPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.group.command.ViewportSelectRowGroupCommand;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRegionCommand;

public class ViewportSelectRowGroupCommandHandler
extends AbstractLayerCommandHandler<ViewportSelectRowGroupCommand> {
    private final AbstractLayer viewportLayer;

    public ViewportSelectRowGroupCommandHandler(AbstractLayer viewportLayer) {
        if (viewportLayer == null) {
            throw new IllegalArgumentException("viewportLayer cannot be null!");
        }
        this.viewportLayer = viewportLayer;
    }

    @Override
    protected boolean doCommand(ViewportSelectRowGroupCommand command) {
        ILayer underlyingLayer = this.viewportLayer.getUnderlyingLayerByPosition(0, 0);
        RowPositionCoordinate underlyingStart = LayerCommandUtil.convertRowPositionToTargetContext(new RowPositionCoordinate(command.getLayer(), command.getOriginRowPosition()), underlyingLayer);
        int span = command.getRowSpan();
        if (underlyingStart == null) {
            span += command.getOriginRowPosition();
            underlyingStart = LayerCommandUtil.convertRowPositionToTargetContext(new RowPositionCoordinate(command.getLayer(), 0), underlyingLayer);
        }
        if (underlyingStart != null) {
            SelectRegionCommand regionCommand = new SelectRegionCommand(underlyingLayer, 0, underlyingStart.getRowPosition(), Integer.MAX_VALUE, span, command.isWithShiftMask(), command.isWithControlMask());
            ColumnPositionCoordinate underlyingColumn = LayerCommandUtil.convertColumnPositionToTargetContext(new ColumnPositionCoordinate(this.viewportLayer, 0), underlyingLayer);
            regionCommand.setAnchorColumnPosition(underlyingColumn.columnPosition);
            if (command.getOriginRowPosition() <= 0) {
                RowPositionCoordinate underlyingRow = LayerCommandUtil.convertRowPositionToTargetContext(new RowPositionCoordinate(this.viewportLayer, 0), underlyingLayer);
                regionCommand.setAnchorRowPosition(underlyingRow.rowPosition);
            }
            underlyingLayer.doCommand(regionCommand);
        }
        return true;
    }

    @Override
    public Class<ViewportSelectRowGroupCommand> getCommandClass() {
        return ViewportSelectRowGroupCommand.class;
    }
}

