/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.assistant;

import org.eclipse.papyrus.moka.fuml.loci.ISemanticVisitor;
import org.eclipse.papyrus.moka.kernel.assistant.IDebugAssistant;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class DebugAssistantException
extends RuntimeException {
    private static final long serialVersionUID = 7505081361638138900L;
    protected IDebugAssistant debugAssistant;
    protected ISemanticVisitor visitor;
    protected Element visitorNode;
    protected String message;

    public DebugAssistantException(IDebugAssistant debugAssistant, ISemanticVisitor visitor) {
        this(debugAssistant, visitor, null);
    }

    public DebugAssistantException(IDebugAssistant debugAssistant, ISemanticVisitor visitor, String message) {
        this.debugAssistant = debugAssistant;
        this.visitor = visitor;
        this.visitorNode = this.debugAssistant.getVisitorNode(visitor);
        this.message = message;
    }

    public IDebugAssistant getDebugAssistant() {
        return this.debugAssistant;
    }

    public void setDebugAssistant(IDebugAssistant debugAssistant) {
        this.debugAssistant = debugAssistant;
    }

    public ISemanticVisitor getVisitor() {
        return this.visitor;
    }

    public void setVisitor(ISemanticVisitor visitor) {
        this.visitor = visitor;
    }

    public Element getVisitorNode() {
        return this.visitorNode;
    }

    public void setVisitorNode(Element visitorNode) {
        this.visitorNode = visitorNode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.message != null) {
            builder.append(this.message);
        } else {
            builder.append("Missing expected tokens\n");
        }
        builder.append("Current visited node: ");
        if (this.visitorNode instanceof NamedElement) {
            builder.append(((NamedElement)this.visitorNode).getQualifiedName());
        } else {
            builder.append(this.visitorNode);
        }
        return builder.toString();
    }
}

