/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.serializer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.DynamicRuleMatch;
import org.eclipse.ocl.examples.xtext.serializer.EnumerationValue;
import org.eclipse.ocl.examples.xtext.serializer.GrammarRuleVector;
import org.eclipse.ocl.examples.xtext.serializer.RuleMatch;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;

public abstract class SerializationMatchTerm {
    private @Nullable Integer hashCode = null;

    public @Nullable Integer basicGetIntegerSolution(@NonNull RuleMatch ruleMatch) {
        return null;
    }

    protected abstract int computeHashCode();

    public abstract boolean equals(Object var1);

    public @NonNull Set<@NonNull SerializationMatchTerm> getChildClosure() {
        @NonNull Set<@NonNull SerializationMatchTerm> singleton = Collections.singleton(this);
        return singleton;
    }

    public final int hashCode() {
        Integer hashCode2 = this.hashCode;
        if (hashCode2 == null) {
            this.hashCode = hashCode2 = Integer.valueOf(this.computeHashCode());
        }
        return hashCode2;
    }

    public abstract boolean isConstant(@NonNull DynamicRuleMatch var1);

    public abstract boolean isKnown(@NonNull DynamicRuleMatch var1);

    public @NonNull String toString() {
        DiagnosticStringBuilder s = new DiagnosticStringBuilder();
        this.toString(s);
        @NonNull String castString = s.toString();
        return castString;
    }

    public abstract void toString(@NonNull DiagnosticStringBuilder var1);

    public static abstract class SerializationMatchTermAbstractBinary
    extends SerializationMatchTerm {
        protected final @NonNull SerializationMatchTerm left;
        protected final @NonNull SerializationMatchTerm right;
        private @Nullable Set<@NonNull SerializationMatchTerm> childClosure = null;

        public SerializationMatchTermAbstractBinary(@NonNull SerializationMatchTerm left, @NonNull SerializationMatchTerm right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public int computeHashCode() {
            return this.getClass().hashCode() + 3 * this.left.hashCode() + 7 * this.right.hashCode();
        }

        @Override
        public @NonNull Set<@NonNull SerializationMatchTerm> getChildClosure() {
            Set<@NonNull SerializationMatchTerm> childClosure2 = this.childClosure;
            if (childClosure2 == null) {
                this.childClosure = childClosure2 = new HashSet<SerializationMatchTerm>();
                childClosure2.add(this);
                childClosure2.addAll(this.left.getChildClosure());
                childClosure2.addAll(this.right.getChildClosure());
            }
            return childClosure2;
        }

        public @NonNull SerializationMatchTerm getLeft() {
            return this.left;
        }

        public @NonNull SerializationMatchTerm getRight() {
            return this.right;
        }

        @Override
        public boolean isConstant(@NonNull DynamicRuleMatch ruleMatch) {
            return this.left.isConstant(ruleMatch) && this.right.isConstant(ruleMatch);
        }

        @Override
        public boolean isKnown(@NonNull DynamicRuleMatch ruleMatch) {
            return this.left.isKnown(ruleMatch) && this.right.isKnown(ruleMatch);
        }
    }

    public static class SerializationMatchTermAdd
    extends SerializationMatchTermAbstractBinary {
        public SerializationMatchTermAdd(@NonNull SerializationMatchTerm left, @NonNull SerializationMatchTerm right) {
            super(left, right);
        }

        @Override
        public @Nullable Integer basicGetIntegerSolution(@NonNull RuleMatch ruleMatch) {
            Integer intLeft = this.left.basicGetIntegerSolution(ruleMatch);
            if (intLeft == null) {
                return null;
            }
            Integer intRight = this.right.basicGetIntegerSolution(ruleMatch);
            if (intRight == null) {
                return null;
            }
            return intLeft + intRight;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationMatchTermAdd)) {
                return false;
            }
            SerializationMatchTermAdd that = (SerializationMatchTermAdd)obj;
            if (!this.left.equals(that.left)) {
                return false;
            }
            return this.right.equals(that.right);
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("(");
            this.left.toString(s);
            s.append(" + ");
            this.right.toString(s);
            s.append(")");
        }
    }

    public static class SerializationMatchTermDivide
    extends SerializationMatchTermAbstractBinary {
        public SerializationMatchTermDivide(@NonNull SerializationMatchTerm left, @NonNull SerializationMatchTerm right) {
            super(left, right);
        }

        @Override
        public @Nullable Integer basicGetIntegerSolution(@NonNull RuleMatch ruleMatch) {
            Integer intRight = this.right.basicGetIntegerSolution(ruleMatch);
            if (intRight == null || intRight == 0) {
                return null;
            }
            Integer intLeft = this.left.basicGetIntegerSolution(ruleMatch);
            if (intLeft == null) {
                return null;
            }
            int result = Math.floorDiv(intLeft, (int)intRight);
            if (result * intRight != intLeft) {
                return null;
            }
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationMatchTermDivide)) {
                return false;
            }
            SerializationMatchTermDivide that = (SerializationMatchTermDivide)obj;
            if (!this.left.equals(that.left)) {
                return false;
            }
            return this.right.equals(that.right);
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("(");
            this.left.toString(s);
            s.append(" / ");
            this.right.toString(s);
            s.append(")");
        }
    }

    public static class SerializationMatchTermEAttributeSize
    extends SerializationMatchTerm {
        protected final @NonNull EAttribute eAttribute;
        protected final @NonNull EnumerationValue enumerationValue;

        public SerializationMatchTermEAttributeSize(@NonNull EAttribute eAttribute, @NonNull EnumerationValue enumerationValue) {
            this.eAttribute = eAttribute;
            this.enumerationValue = enumerationValue;
        }

        @Override
        public @Nullable Integer basicGetIntegerSolution(@NonNull RuleMatch ruleMatch) {
            return ruleMatch.getSize(this.eAttribute, this.enumerationValue);
        }

        @Override
        public int computeHashCode() {
            return this.getClass().hashCode() + 3 * this.eAttribute.hashCode() + 7 * this.enumerationValue.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationMatchTermEAttributeSize)) {
                return false;
            }
            SerializationMatchTermEAttributeSize that = (SerializationMatchTermEAttributeSize)obj;
            if (this.eAttribute != that.eAttribute) {
                return false;
            }
            return this.enumerationValue.equals(that.enumerationValue);
        }

        public @NonNull EAttribute getEAttribute() {
            return this.eAttribute;
        }

        public @NonNull EnumerationValue getEnumerationValue() {
            return this.enumerationValue;
        }

        @Override
        public boolean isConstant(@NonNull DynamicRuleMatch ruleMatch) {
            return false;
        }

        @Override
        public boolean isKnown(@NonNull DynamicRuleMatch ruleMatch) {
            return true;
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("|");
            s.append(SerializationUtils.getName((ENamedElement)SerializationUtils.getEContainingClass((EStructuralFeature)this.eAttribute)));
            s.append("::");
            s.append(SerializationUtils.getName((ENamedElement)this.eAttribute));
            s.append(".'");
            s.append(this.enumerationValue.getName());
            s.append("'|");
        }
    }

    public static class SerializationMatchTermEReferenceSize
    extends SerializationMatchTerm {
        protected final @NonNull EReference eReference;
        protected final @NonNull GrammarRuleVector grammarRuleVector;

        public SerializationMatchTermEReferenceSize(@NonNull EReference eReference, @NonNull GrammarRuleVector grammarRuleVector) {
            this.eReference = eReference;
            this.grammarRuleVector = grammarRuleVector;
        }

        @Override
        public @Nullable Integer basicGetIntegerSolution(@NonNull RuleMatch ruleMatch) {
            return ruleMatch.getSize(this.eReference, this.grammarRuleVector);
        }

        @Override
        public int computeHashCode() {
            return this.getClass().hashCode() + 3 * this.eReference.hashCode() + 7 * this.grammarRuleVector.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationMatchTermEReferenceSize)) {
                return false;
            }
            SerializationMatchTermEReferenceSize that = (SerializationMatchTermEReferenceSize)obj;
            if (this.eReference != that.eReference) {
                return false;
            }
            return this.grammarRuleVector.equals(that.grammarRuleVector);
        }

        public @NonNull EReference getEReference() {
            return this.eReference;
        }

        public @NonNull GrammarRuleVector getGrammarRuleVector() {
            return this.grammarRuleVector;
        }

        @Override
        public boolean isConstant(@NonNull DynamicRuleMatch ruleMatch) {
            return false;
        }

        @Override
        public boolean isKnown(@NonNull DynamicRuleMatch ruleMatch) {
            return true;
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("|");
            s.append(SerializationUtils.getName((ENamedElement)SerializationUtils.getEContainingClass((EStructuralFeature)this.eReference)));
            s.append("::");
            s.append(SerializationUtils.getName((ENamedElement)this.eReference));
            s.append(":{");
            this.grammarRuleVector.toString(s);
            s.append("}|");
        }
    }

    public static class SerializationMatchTermEStructuralFeatureSize
    extends SerializationMatchTerm {
        protected final @NonNull EStructuralFeature eStructuralFeature;

        public SerializationMatchTermEStructuralFeatureSize(@NonNull EStructuralFeature eStructuralFeature) {
            assert (eStructuralFeature != null);
            this.eStructuralFeature = eStructuralFeature;
        }

        @Override
        public @Nullable Integer basicGetIntegerSolution(@NonNull RuleMatch ruleMatch) {
            return ruleMatch.getSize(this.eStructuralFeature);
        }

        @Override
        public int computeHashCode() {
            return this.getClass().hashCode() + 3 * this.eStructuralFeature.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationMatchTermEStructuralFeatureSize)) {
                return false;
            }
            SerializationMatchTermEStructuralFeatureSize that = (SerializationMatchTermEStructuralFeatureSize)obj;
            return this.eStructuralFeature == that.eStructuralFeature;
        }

        public @NonNull EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        @Override
        public boolean isConstant(@NonNull DynamicRuleMatch ruleMatch) {
            return false;
        }

        @Override
        public boolean isKnown(@NonNull DynamicRuleMatch ruleMatch) {
            return true;
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("|");
            s.append(SerializationUtils.getName((ENamedElement)SerializationUtils.getEContainingClass(this.eStructuralFeature)));
            s.append("::");
            s.append(SerializationUtils.getName((ENamedElement)this.eStructuralFeature));
            s.append("|");
        }
    }

    public static class SerializationMatchTermGreaterThan
    extends SerializationMatchTermAbstractBinary {
        public SerializationMatchTermGreaterThan(@NonNull SerializationMatchTerm left, @NonNull SerializationMatchTerm right) {
            super(left, right);
        }

        @Override
        public @Nullable Integer basicGetIntegerSolution(@NonNull RuleMatch ruleMatch) {
            Integer intLeft = this.left.basicGetIntegerSolution(ruleMatch);
            if (intLeft == null) {
                return null;
            }
            Integer intRight = this.right.basicGetIntegerSolution(ruleMatch);
            if (intRight == null) {
                return null;
            }
            return intLeft > intRight ? 1 : 0;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationMatchTermGreaterThan)) {
                return false;
            }
            SerializationMatchTermGreaterThan that = (SerializationMatchTermGreaterThan)obj;
            if (!this.left.equals(that.left)) {
                return false;
            }
            return this.right.equals(that.right);
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("(");
            this.left.toString(s);
            s.append(" > ");
            this.right.toString(s);
            s.append(")");
        }
    }

    public static class SerializationMatchTermInteger
    extends SerializationMatchTerm {
        protected final int value;

        public SerializationMatchTermInteger(int value) {
            this.value = value;
        }

        @Override
        public int computeHashCode() {
            return this.getClass().hashCode() + this.value;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationMatchTermInteger)) {
                return false;
            }
            SerializationMatchTermInteger that = (SerializationMatchTermInteger)obj;
            return this.value == that.value;
        }

        @Override
        public @NonNull Integer basicGetIntegerSolution(@NonNull RuleMatch ruleMatch) {
            return this.value;
        }

        public int getValue() {
            return this.value;
        }

        @Override
        public boolean isConstant(@NonNull DynamicRuleMatch ruleMatch) {
            return true;
        }

        @Override
        public boolean isKnown(@NonNull DynamicRuleMatch ruleMatch) {
            return true;
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            String string = Integer.toString(this.value);
            assert (string != null);
            s.append(string);
        }
    }

    public static class SerializationMatchTermMultiply
    extends SerializationMatchTermAbstractBinary {
        public SerializationMatchTermMultiply(@NonNull SerializationMatchTerm left, @NonNull SerializationMatchTerm right) {
            super(left, right);
        }

        @Override
        public @Nullable Integer basicGetIntegerSolution(@NonNull RuleMatch ruleMatch) {
            Integer intRight = this.right.basicGetIntegerSolution(ruleMatch);
            if (intRight == null || intRight == 0) {
                return null;
            }
            Integer intLeft = this.left.basicGetIntegerSolution(ruleMatch);
            if (intLeft == null) {
                return null;
            }
            return intLeft * intRight;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationMatchTermMultiply)) {
                return false;
            }
            SerializationMatchTermMultiply that = (SerializationMatchTermMultiply)obj;
            if (!this.left.equals(that.left)) {
                return false;
            }
            return this.right.equals(that.right);
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("(");
            this.left.toString(s);
            s.append(" * ");
            this.right.toString(s);
            s.append(")");
        }
    }

    public static class SerializationMatchTermSubtract
    extends SerializationMatchTermAbstractBinary {
        public SerializationMatchTermSubtract(@NonNull SerializationMatchTerm left, @NonNull SerializationMatchTerm right) {
            super(left, right);
        }

        @Override
        public @Nullable Integer basicGetIntegerSolution(@NonNull RuleMatch ruleMatch) {
            Integer intLeft = this.left.basicGetIntegerSolution(ruleMatch);
            if (intLeft == null) {
                return null;
            }
            Integer intRight = this.right.basicGetIntegerSolution(ruleMatch);
            if (intRight == null) {
                return null;
            }
            return intLeft - intRight;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationMatchTermSubtract)) {
                return false;
            }
            SerializationMatchTermSubtract that = (SerializationMatchTermSubtract)obj;
            if (!this.left.equals(that.left)) {
                return false;
            }
            return this.right.equals(that.right);
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("(");
            this.left.toString(s);
            s.append(" - ");
            this.right.toString(s);
            s.append(")");
        }
    }

    public static class SerializationMatchTermUnsupported
    extends SerializationMatchTerm {
        @Override
        public int computeHashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof SerializationMatchTermUnsupported;
        }

        @Override
        public boolean isConstant(@NonNull DynamicRuleMatch ruleMatch) {
            return false;
        }

        @Override
        public boolean isKnown(@NonNull DynamicRuleMatch ruleMatch) {
            return false;
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("?");
        }
    }

    public static class SerializationMatchTermVariable
    extends SerializationMatchTerm {
        protected final int cardinalityVariableIndex;

        public SerializationMatchTermVariable(int cardinalityVariableIndex) {
            this.cardinalityVariableIndex = cardinalityVariableIndex;
        }

        @Override
        public @Nullable Integer basicGetIntegerSolution(@NonNull RuleMatch ruleMatch) {
            return ruleMatch.basicGetIntegerSolution(this.cardinalityVariableIndex);
        }

        @Override
        public int computeHashCode() {
            return this.getClass().hashCode() + 3 * this.cardinalityVariableIndex;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SerializationMatchTermVariable)) {
                return false;
            }
            SerializationMatchTermVariable that = (SerializationMatchTermVariable)obj;
            return this.cardinalityVariableIndex == that.cardinalityVariableIndex;
        }

        public int getVariableIndex() {
            return this.cardinalityVariableIndex;
        }

        @Override
        public boolean isConstant(@NonNull DynamicRuleMatch ruleMatch) {
            return false;
        }

        @Override
        public boolean isKnown(@NonNull DynamicRuleMatch ruleMatch) {
            return false;
        }

        @Override
        public void toString(@NonNull DiagnosticStringBuilder s) {
            s.append("V" + this.cardinalityVariableIndex);
        }
    }
}

