/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.FeatureCall;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.util.ProfileCollector;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Operation;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationCall
extends FeatureCall {
    private Expression[] params;

    public OperationCall(Identifier name, Expression target, Expression ... params) {
        super(name, target);
        this.params = params;
    }

    public Expression[] getParams() {
        return this.params;
    }

    public List<Expression> getParamsAsList() {
        return Arrays.asList(this.params);
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Operation op;
        Object targetObj = null;
        if (this.getTarget() != null) {
            targetObj = this.getTarget().evaluate(ctx);
        }
        Object[] evaluatedParams = new Object[this.getParams().length];
        if (this.getParams().length > 0) {
            int i = 0;
            while (i < this.getParams().length) {
                evaluatedParams[i] = this.getParams()[i].evaluate(ctx);
                ++i;
            }
        }
        if (this.getTarget() == null) {
            Extension f = ctx.getExtension(this.getName().getValue(), evaluatedParams);
            if (f != null) {
                ProfileCollector.getInstance().enter(f.toString());
                try {
                    Object object = this.evaluate(f, evaluatedParams, ctx);
                    return object;
                }
                catch (EvaluationException e) {
                    e.addStackElement(this, ctx);
                    throw e;
                }
                finally {
                    ProfileCollector.getInstance().leave();
                }
            }
            Variable var = ctx.getVariable("this");
            if (var == null) {
                throw new EvaluationException("Couldn't find extension '" + this.getName().getValue() + this.getParamTypes(evaluatedParams, ctx) + "'!", (SyntaxElement)this, ctx);
            }
            targetObj = var.getValue();
        }
        if ((op = ctx.findOperation(this.getName().getValue(), targetObj, evaluatedParams)) != null) {
            return this.evaluate(op, targetObj, evaluatedParams, ctx);
        }
        Object[] ps = new Object[evaluatedParams.length + 1];
        ps[0] = targetObj;
        System.arraycopy(evaluatedParams, 0, ps, 1, evaluatedParams.length);
        Extension f = ctx.getExtension(this.getName().getValue(), ps);
        if (f != null) {
            try {
                ProfileCollector.getInstance().enter(f.toString());
                Object object = this.evaluate(f, ps, ctx);
                return object;
            }
            catch (EvaluationException e) {
                e.addStackElement(this, ctx);
                throw e;
            }
            finally {
                ProfileCollector.getInstance().leave();
            }
        }
        if (targetObj instanceof Collection) {
            ArrayList<Object> result = new ArrayList<Object>();
            Collection col = (Collection)targetObj;
            for (Object element : col) {
                Object r;
                op = ctx.findOperation(this.getName().getValue(), element, evaluatedParams);
                if (op != null) {
                    r = this.evaluate(op, element, evaluatedParams, ctx);
                    if (r instanceof Collection) {
                        result.addAll((Collection)r);
                        continue;
                    }
                    result.add(r);
                    continue;
                }
                ps = new Object[evaluatedParams.length + 1];
                ps[0] = element;
                System.arraycopy(evaluatedParams, 0, ps, 1, evaluatedParams.length);
                f = ctx.getExtension(this.getName().getValue(), ps);
                if (f != null) {
                    r = null;
                    try {
                        r = this.evaluate(f, ps, ctx);
                    }
                    catch (EvaluationException e) {
                        e.addStackElement(this, ctx);
                        throw e;
                    }
                    if (r instanceof Collection) {
                        result.addAll((Collection)r);
                        continue;
                    }
                    result.add(r);
                    continue;
                }
                throw new EvaluationException("Couldn't find operation '" + this.getName().getValue() + this.getParamTypes(evaluatedParams, ctx) + "' for " + ctx.getType(targetObj).getName() + "!", (SyntaxElement)this, ctx);
            }
            return result;
        }
        if (targetObj != null) {
            throw new EvaluationException("Couldn't find operation '" + this.getName().getValue() + this.getParamTypes(evaluatedParams, ctx) + "' for " + ctx.getType(targetObj).getName() + ".", (SyntaxElement)this, ctx);
        }
        return ctx.handleNullEvaluation(this);
    }

    private String getParamTypes(Object[] params2, ExecutionContext ctx) {
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < params2.length) {
            Type type = ctx.getType(params2[i]);
            buff.append(type.getName());
            if (i + 1 < params2.length) {
                buff.append(",");
            }
            ++i;
        }
        return buff.append(")").toString();
    }

    @Override
    public Type analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type[] paramTypes = new Type[this.getParams().length];
        if (this.getParams().length > 0) {
            int i = 0;
            while (i < this.getParams().length) {
                paramTypes[i] = this.getParams()[i].analyze(ctx, issues);
                if (paramTypes[i] == null) {
                    return null;
                }
                ++i;
            }
        }
        Type targetType = null;
        if (this.getTarget() == null) {
            Extension f = null;
            try {
                f = ctx.getExtensionForTypes(this.getName().getValue(), paramTypes);
            }
            catch (Exception e) {
                issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Error parsing extensions : " + e.getMessage(), this));
            }
            if (f != null) {
                return ctx.getReturnType(f, paramTypes, issues);
            }
            Variable var = ctx.getVariable("this");
            if (var != null) {
                targetType = (Type)var.getValue();
            } else {
                issues.add(new AnalysationIssue(AnalysationIssue.FEATURE_NOT_FOUND, "Couldn't find extension : " + this.toString(), this));
            }
        } else {
            targetType = this.getTarget().analyze(ctx, issues);
        }
        if (targetType == null) {
            return null;
        }
        Operation op = targetType.getOperation(this.getName().getValue(), paramTypes);
        if (op != null) {
            return op.getReturnType(targetType, paramTypes);
        }
        int issueSize = issues.size();
        Type rt = this.getExtensionsReturnType(ctx, issues, paramTypes, targetType);
        if (rt != null) {
            return rt;
        }
        if (issueSize < issues.size()) {
            return null;
        }
        String additionalMsg = "";
        if (targetType instanceof ParameterizedType) {
            Type innerType = ((ParameterizedType)targetType).getInnerType();
            op = innerType.getOperation(this.getName().getValue(), paramTypes);
            if (op != null) {
                rt = op.getReturnType();
                if (rt instanceof ParameterizedType) {
                    rt = ((ParameterizedType)rt).getInnerType();
                }
                return ctx.getListType(rt);
            }
            rt = this.getExtensionsReturnType(ctx, issues, paramTypes, innerType);
            if (rt != null) {
                if (rt instanceof ParameterizedType) {
                    rt = ((ParameterizedType)rt).getInnerType();
                }
                return ctx.getListType(rt);
            }
            additionalMsg = " or type '" + innerType + "'";
        }
        issues.add(new AnalysationIssue(AnalysationIssue.FEATURE_NOT_FOUND, "Couldn't find operation '" + this.getName().getValue() + this.getParamsString(paramTypes) + "' for type '" + targetType.getName() + "'" + additionalMsg, this));
        return null;
    }

    private Type getExtensionsReturnType(ExecutionContext ctx, Set<AnalysationIssue> issues, Type[] paramTypes, Type targetType) {
        Type returnType = null;
        Type[] pts = new Type[paramTypes.length + 1];
        HashSet<AnalysationIssue> internalIssues = new HashSet<AnalysationIssue>();
        pts[0] = targetType;
        System.arraycopy(paramTypes, 0, pts, 1, paramTypes.length);
        Extension f = null;
        try {
            f = ctx.getExtensionForTypes(this.getName().getValue(), pts);
        }
        catch (Exception e) {
            internalIssues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Error parsing extensions : " + e.getMessage(), this));
        }
        if (f != null) {
            returnType = ctx.getReturnType(f, pts, internalIssues);
        } else if (this.getTarget() == null) {
            try {
                f = ctx.getExtensionForTypes(this.getName().getValue(), paramTypes);
            }
            catch (Exception e) {
                internalIssues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Error parsing extensions : " + e.getMessage(), this));
            }
            if (f != null) {
                returnType = ctx.getReturnType(f, pts, internalIssues);
            }
        }
        return returnType;
    }

    private String getParamsString(Type[] paramTypes) {
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < paramTypes.length) {
            Type type = paramTypes[i];
            buff.append(type.getName());
            if (i + 1 < paramTypes.length) {
                buff.append(",");
            }
            ++i;
        }
        return buff.append(")").toString();
    }

    @Override
    protected String toStringInternal() {
        return String.valueOf(this.getTarget() != null ? String.valueOf(this.getTarget().toStringInternal()) + "." : "") + this.getName() + this.getParamsExpressionString(this.getParams());
    }

    @Override
    public String getNameString(ExecutionContext context) {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getName().getValue());
        buff.append("(");
        if (this.params.length > 0) {
            if (context != null) {
                buff.append(this.getParamTypesString(context));
            } else {
                buff.append("..");
            }
        }
        return buff.append(")").toString();
    }

    private String getParamTypesString(ExecutionContext context) {
        ExecutionContext ctx = context.cloneWithoutMonitor();
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.getParams().length) {
            Type type = ctx.getType(this.params[i].evaluate(ctx));
            String name = type.getName();
            int pos = name.lastIndexOf("::");
            if (pos < 0) {
                buff.append(name);
            } else {
                buff.append(name.substring(pos + 2));
            }
            if (i + 1 < this.params.length) {
                buff.append(",");
            }
            ++i;
        }
        return buff.toString();
    }

    private String getParamsExpressionString(Expression[] params2) {
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < params2.length) {
            buff.append(params2[i]);
            if (i + 1 < params2.length) {
                buff.append(",");
            }
            ++i;
        }
        return buff.append(")").toString();
    }

    private Object evaluate(Extension ext, Object[] params, ExecutionContext ctx) {
        ctx.preTask(this);
        Object result = ext.evaluate(params, ctx);
        ctx.postTask(this);
        return result;
    }

    private Object evaluate(Operation op, Object targetObj, Object[] params, ExecutionContext ctx) {
        ctx.preTask(this);
        Object result = op.evaluate(targetObj, params);
        ctx.postTask(this);
        return result;
    }
}

