/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.xtend.middleend.plugins.LanguageSpecificMiddleEnd;
import org.eclipse.xtend.middleend.plugins.LanguageSpecificMiddleEndFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    private static final Log _log = LogFactory.getLog(Activator.class);
    private static Activator _instance = null;
    private final List<LanguageSpecificMiddleEndFactory> _middleEndContributions = new ArrayList<LanguageSpecificMiddleEndFactory>();
    private boolean _isInitialized = false;

    public static Activator getInstance() {
        return _instance;
    }

    public List<LanguageSpecificMiddleEnd> getFreshMiddleEnds(Map<Class<?>, Object> specificParams) {
        this.init();
        ArrayList<LanguageSpecificMiddleEnd> result = new ArrayList<LanguageSpecificMiddleEnd>();
        for (LanguageSpecificMiddleEndFactory factory : this._middleEndContributions) {
            try {
                result.add(factory.create(specificParams.get(factory.getClass())));
            }
            catch (IllegalArgumentException exc) {
                _log.debug((Object)("middle end implementation " + factory.getName() + " says it is not available: " + exc.getMessage()));
            }
        }
        return result;
    }

    public void start(BundleContext context) throws Exception {
        this._isInitialized = false;
        _instance = this;
    }

    private void init() {
        if (this._isInitialized) {
            return;
        }
        this._isInitialized = true;
        this._middleEndContributions.clear();
        try {
            IConfigurationElement[] confEl;
            IConfigurationElement[] iConfigurationElementArray = confEl = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.xtend.backend.MiddleEnd");
            int n = confEl.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement curEl = iConfigurationElementArray[n2];
                Object o = curEl.createExecutableExtension("class");
                this._middleEndContributions.add((LanguageSpecificMiddleEndFactory)o);
                ++n2;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        Collections.sort(this._middleEndContributions, new Comparator<LanguageSpecificMiddleEndFactory>(){

            @Override
            public int compare(LanguageSpecificMiddleEndFactory o1, LanguageSpecificMiddleEndFactory o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        _log.info((Object)"Activating Eclipse Modeling Middle End - the following middle ends are registered:");
        for (LanguageSpecificMiddleEndFactory factory : this._middleEndContributions) {
            _log.info((Object)("  " + factory.getName()));
        }
    }

    public void stop(BundleContext context) throws Exception {
        _instance = null;
        this._middleEndContributions.clear();
    }
}

