/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.common.Property;
import org.eclipse.xtend.backend.types.internal.FunctionBackedProperty;
import org.eclipse.xtend.backend.util.Cache;
import org.eclipse.xtend.backend.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SyntheticPropertyExtracter {
    private final Cache<String, AccessorPair> _accessorPairs = new Cache<String, AccessorPair>(){

        @Override
        protected AccessorPair create(String key) {
            return new AccessorPair();
        }
    };
    private final BackendType _owner;

    public SyntheticPropertyExtracter(ExecutionContext ctx, BackendType type) {
        this._owner = type;
        Collection<NamedFunction> _allFunctions = ctx.getFunctionDefContext().getByFirstParameterType(type);
        for (NamedFunction f : _allFunctions) {
            Pair<Boolean, String> propAcc = SyntheticPropertyExtracter.getPropertyAccessorDetails(f);
            if (propAcc == null) continue;
            AccessorPair ap = this._accessorPairs.get(SyntheticPropertyExtracter.refinePropertyName(propAcc.getSecond()));
            boolean isSetter = propAcc.getFirst();
            if (isSetter) {
                ap._setterName = f.getName().getSimpleName();
                continue;
            }
            ap._getterName = f.getName().getSimpleName();
        }
    }

    public Map<String, Property> getProperties() {
        HashMap<String, Property> result = new HashMap<String, Property>();
        for (String propName : this._accessorPairs.getMap().keySet()) {
            AccessorPair ap = this._accessorPairs.get(propName);
            result.put(propName, new FunctionBackedProperty(propName, ap._getterName, ap._setterName, this._owner));
        }
        return result;
    }

    private static Pair<Boolean, String> getPropertyAccessorDetails(NamedFunction f) {
        if (f.getFunction().getGuard() != null) {
            return null;
        }
        if (SyntheticPropertyExtracter.hasPrefix(f.getName().getSimpleName(), "set")) {
            if (f.getFunction().getParameterTypes().size() != 2) {
                return null;
            }
            return new Pair<Boolean, String>(true, f.getName().getSimpleName().substring(3));
        }
        if (f.getFunction().getParameterTypes().size() != 1) {
            return null;
        }
        if (SyntheticPropertyExtracter.hasPrefix(f.getName().getSimpleName(), "get") || SyntheticPropertyExtracter.hasPrefix(f.getName().getSimpleName(), "has")) {
            return new Pair<Boolean, String>(false, f.getName().getSimpleName().substring(3));
        }
        if (SyntheticPropertyExtracter.hasPrefix(f.getName().getSimpleName(), "is")) {
            return new Pair<Boolean, String>(false, f.getName().getSimpleName().substring(2));
        }
        return null;
    }

    private static boolean hasPrefix(String functionName, String prefix) {
        if (!functionName.startsWith(prefix)) {
            return false;
        }
        if (functionName.length() < prefix.length() + 1) {
            return false;
        }
        return Character.isUpperCase(functionName.charAt(prefix.length()));
    }

    private static String refinePropertyName(String rawName) {
        if (rawName.length() >= 2 && Character.isUpperCase(rawName.charAt(1))) {
            return rawName;
        }
        return String.valueOf(Character.toLowerCase(rawName.charAt(0))) + rawName.substring(1);
    }

    private static class AccessorPair {
        public String _getterName;
        public String _setterName;

        private AccessorPair() {
        }
    }
}

