/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.internal;

import java.util.Arrays;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.Property;
import org.eclipse.xtend.backend.common.QualifiedName;

public final class FunctionBackedProperty
implements Property {
    private final String _name;
    private final BackendType _owner;
    private final String _getterName;
    private final String _setterName;

    public FunctionBackedProperty(String name, String getterName, String setterName, BackendType owner) {
        this._name = name;
        this._owner = owner;
        this._getterName = getterName;
        this._setterName = setterName;
    }

    public Object get(ExecutionContext ctx, Object o) {
        return ctx.getFunctionDefContext().invoke(ctx, new QualifiedName(this._getterName), Arrays.asList(o));
    }

    public void set(ExecutionContext ctx, Object o, Object newValue) {
        ctx.getFunctionDefContext().invoke(ctx, new QualifiedName(this._setterName), Arrays.asList(o, newValue));
    }

    public String getName() {
        return this._name;
    }

    public BackendType getOwner() {
        return this._owner;
    }

    public boolean isReadable() {
        return this._getterName != null;
    }

    public boolean isWritable() {
        return this._setterName != null;
    }

    public BackendType getType(BackendTypesystem ts) {
        throw new UnsupportedOperationException();
    }
}

