/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.functions.internal;

import java.util.List;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.FunctionDefContext;
import org.eclipse.xtend.backend.common.LocalVarContext;
import org.eclipse.xtend.backend.functions.AbstractFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Closure
extends AbstractFunction {
    private final LocalVarContext _lvcAtDefinitionTime = new LocalVarContext();
    private final FunctionDefContext _fdcAtDefinitionTime;
    private final List<String> _paramNames;
    private final ExpressionBase _def;

    public Closure(LocalVarContext lvcAtDefinitionTime, FunctionDefContext fdcAtDefinitionTime, List<String> paramNames, List<? extends BackendType> paramTypes, ExpressionBase def) {
        super(null, paramTypes, null, false);
        this._lvcAtDefinitionTime.getLocalVars().putAll(lvcAtDefinitionTime.getLocalVars());
        this._fdcAtDefinitionTime = fdcAtDefinitionTime;
        this._paramNames = paramNames;
        this._def = def;
    }

    @Override
    public Object invoke(ExecutionContext ctx, Object[] params) {
        if (this._fdcAtDefinitionTime == ctx.getFunctionDefContext()) {
            return this.invokeWithExistingFdc(ctx, params);
        }
        FunctionDefContext oldFdc = ctx.getFunctionDefContext();
        try {
            ctx.setFunctionDefContext(this._fdcAtDefinitionTime);
            Object object = this.invokeWithExistingFdc(ctx, params);
            return object;
        }
        finally {
            ctx.setFunctionDefContext(oldFdc);
        }
    }

    private Object invokeWithExistingFdc(ExecutionContext ctx, Object ... params) {
        LocalVarContext lvc = this._lvcAtDefinitionTime;
        int i = 0;
        while (i < this._paramNames.size()) {
            lvc.getLocalVars().put(this._paramNames.get(i), params[i]);
            ++i;
        }
        LocalVarContext oldLvc = ctx.getLocalVarContext();
        try {
            ctx.setLocalVarContext(lvc);
            Object object = this._def.evaluate(ctx);
            return object;
        }
        finally {
            ctx.setLocalVarContext(oldLvc);
        }
    }

    @Override
    public void setFunctionDefContext(FunctionDefContext fdc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FunctionDefContext getFunctionDefContext() {
        return this._fdcAtDefinitionTime;
    }

    @Override
    public BackendType getReturnType() {
        throw new UnsupportedOperationException();
    }
}

