/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.expr;

import java.util.Collection;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.SourcePos;
import org.eclipse.xtend.backend.syslib.CollectionOperations;
import org.eclipse.xtend.backend.types.builtin.CollectionType;

public final class PropertyOnWhateverExpression
extends ExpressionBase {
    private final ExpressionBase _inner;
    private final String _propertyName;

    public PropertyOnWhateverExpression(ExpressionBase inner, String propertyName, SourcePos sourcePos) {
        super(sourcePos);
        this._inner = inner;
        this._propertyName = propertyName;
    }

    public ExpressionBase getInnerExpression() {
        return this._inner;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    protected Object evaluateInternal(ExecutionContext ctx) {
        Object o = this._inner.evaluate(ctx);
        if (o == null) {
            ctx.logNullDeRef(this.getPos());
            return null;
        }
        BackendType t = ctx.getTypesystem().findType(o);
        if (CollectionType.INSTANCE.isAssignableFrom(t)) {
            if (this.isProperty(ctx, t, this._propertyName)) {
                return t.getProperty(ctx, o, this._propertyName);
            }
            Collection<Object> result = CollectionOperations.createMatchingCollection((Collection)o);
            for (Object obj : (Collection)o) {
                CollectionOperations.addFlattened(result, ctx.getTypesystem().findType(obj).getProperty(ctx, obj, this._propertyName));
            }
            return result;
        }
        return t.getProperty(ctx, o, this._propertyName);
    }

    private boolean isProperty(ExecutionContext ctx, BackendType t, String propName) {
        return t.getProperties(ctx).containsKey(propName);
    }
}

