/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.emf.check;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderImpl;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.ExecutionContextImpl;
import org.eclipse.xtend.expression.ResourceManager;
import org.eclipse.xtend.expression.ResourceManagerDefaultImpl;
import org.eclipse.xtend.expression.TypeSystemImpl;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.emf.EmfMetaModel;
import org.eclipse.xtend.typesystem.emf.check.CheckFileWithContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckEValidatorAdapter
implements EValidator {
    private final Log log = LogFactory.getLog(CheckEValidatorAdapter.class);
    private final List<CheckFileWithContext> _checkFiles;
    private EValidator _nestedValidator;
    private final EPackage _ePackage;
    private ResourceManager _externalResourceManager;

    public CheckEValidatorAdapter(EPackage ePackage) {
        this._ePackage = ePackage;
        this._checkFiles = new ArrayList<CheckFileWithContext>();
    }

    public CheckEValidatorAdapter(EPackage ePackage, EValidator existingValidator) {
        this(ePackage);
        if (existingValidator != null) {
            this._nestedValidator = existingValidator;
        }
    }

    public void addCheckFile(CheckFileWithContext checkFile) {
        this._checkFiles.add(checkFile);
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List<EObject> allElements = Collections.singletonList(eObject);
        boolean isValid = this.runExtXptCheck(diagnostics, allElements);
        if (this._nestedValidator != null) {
            isValid &= this._nestedValidator.validate(eClass, eObject, diagnostics, context);
        }
        return isValid;
    }

    public boolean validate(EDataType dataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        List<EDataType> allElements = Collections.singletonList(dataType);
        boolean isValid = this.runExtXptCheck(diagnostics, allElements);
        if (this._nestedValidator != null) {
            isValid &= this._nestedValidator.validate(dataType, value, diagnostics, context);
        }
        return isValid;
    }

    public void setExternalResourceManager(ResourceManager externalResourceManager) {
        this._externalResourceManager = externalResourceManager;
    }

    private ResourceManager getResourceManager() {
        if (this._externalResourceManager != null) {
            return this._externalResourceManager;
        }
        return new ResourceManagerDefaultImpl();
    }

    private ExecutionContext createExecutionContext(CheckFileWithContext checkFile, ResourceManager resourceManager) {
        HashSet<EPackage> allEPackages = new HashSet<EPackage>();
        allEPackages.add(this._ePackage);
        for (String nsURI : checkFile.getImportedEPackageNsUris()) {
            try {
                EPackage importedEPackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
                if (importedEPackage == null) continue;
                allEPackages.add(importedEPackage);
            }
            catch (Exception exc) {
                this.log.error((Object)exc);
            }
        }
        TypeSystemImpl typeSystem = new TypeSystemImpl();
        typeSystem.registerMetaModel((MetaModel)new EmfMetaModel(allEPackages){
            private final EPackage[] _allEPackages;
            {
                this._allEPackages = set.toArray(new EPackage[set.size()]);
            }

            protected EPackage[] allPackages() {
                return this._allEPackages;
            }
        });
        ExecutionContextImpl executionContext = new ExecutionContextImpl(resourceManager, typeSystem, null);
        return executionContext;
    }

    private boolean runExtXptCheck(DiagnosticChain diagnostics, List<?> allElements) {
        boolean isValid = true;
        ResourceLoader current = ResourceLoaderFactory.getCurrentThreadResourceLoader();
        try {
            ResourceLoaderFactory.setCurrentThreadResourceLoader((ResourceLoader)new ResourceLoaderImpl(this.getClass().getClassLoader()));
            for (CheckFileWithContext checkFile : this._checkFiles) {
                IssuesImpl issues = new IssuesImpl();
                ResourceManager resourceManager = this.getResourceManager();
                ExtensionFile parsedCheckFile = (ExtensionFile)resourceManager.loadResource(checkFile.getFileName(), "chk");
                if (parsedCheckFile == null) {
                    throw new IllegalArgumentException("Couldn't find file " + checkFile.getFileName() + "." + "chk" + ". Maybe it has been misspelled or it's not on the classpath?");
                }
                ExecutionContext executionContext = this.createExecutionContext(checkFile, resourceManager);
                this.runOawCheck(parsedCheckFile, allElements, diagnostics, executionContext);
                isValid &= issues.hasErrors();
            }
        }
        finally {
            ResourceLoaderFactory.setCurrentThreadResourceLoader((ResourceLoader)current);
        }
        return isValid;
    }

    private Issues runOawCheck(ExtensionFile parsedCheckFile, List<?> allElements, DiagnosticChain diagnostics, ExecutionContext executionContext) {
        IssuesImpl issues = new IssuesImpl();
        if (parsedCheckFile != null) {
            parsedCheckFile.check(executionContext, allElements, (Issues)issues, false);
            this.addDiagnosticFromIssues(diagnostics, (Issues)issues);
        }
        return issues;
    }

    private void addDiagnosticFromIssues(DiagnosticChain allDiagnostics, Issues issues) {
        MWEDiagnostic[] errors = issues.getErrors();
        this.addDiagnostics(allDiagnostics, errors);
        MWEDiagnostic[] warnings = issues.getWarnings();
        this.addDiagnostics(allDiagnostics, warnings);
    }

    private void addDiagnostics(DiagnosticChain allDiagnostics, MWEDiagnostic[] issues) {
        MWEDiagnostic[] mWEDiagnosticArray = issues;
        int n = issues.length;
        int n2 = 0;
        while (n2 < n) {
            MWEDiagnostic issue = mWEDiagnosticArray[n2];
            allDiagnostics.add((Diagnostic)issue);
            ++n2;
        }
    }
}

