/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.uml2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.types.AbstractType;
import org.eclipse.xtend.backend.types.builtin.BooleanType;
import org.eclipse.xtend.backend.types.builtin.DoubleType;
import org.eclipse.xtend.backend.types.builtin.LongType;
import org.eclipse.xtend.backend.types.builtin.StringType;
import org.eclipse.xtend.backend.types.emf.EmfTypesystem;
import org.eclipse.xtend.backend.types.uml2.internal.EnumType;
import org.eclipse.xtend.backend.types.uml2.internal.MultipleStereotypeType;
import org.eclipse.xtend.backend.types.uml2.internal.StereotypeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UmlTypesystem
implements BackendTypesystem {
    public static final String UNIQUE_REPRESENTATION_PREFIX = "{uml}";
    private BackendTypesystem _rootTs;
    private final EmfTypesystem _emfTypesystem = new EmfTypesystem();
    private final boolean _errorIfStereotypeIsMissing;
    private static final Map<String, BackendType> _uml2Primitives = new HashMap<String, BackendType>();
    private final Map<String, BackendType> _stereotypeTypes = new HashMap<String, BackendType>();

    static {
        UmlTypesystem.registerPrimitiveByName("string", (BackendType)StringType.INSTANCE);
        UmlTypesystem.registerPrimitiveByName("int", (BackendType)LongType.INSTANCE);
        UmlTypesystem.registerPrimitiveByName("integer", (BackendType)LongType.INSTANCE);
        UmlTypesystem.registerPrimitiveByName("unlimitedNatural", (BackendType)LongType.INSTANCE);
        UmlTypesystem.registerPrimitiveByName("boolean", (BackendType)BooleanType.INSTANCE);
        UmlTypesystem.registerPrimitiveByName("real", (BackendType)DoubleType.INSTANCE);
    }

    public UmlTypesystem(Collection<Profile> profiles, boolean errorIfStereotypeIsMissing) {
        this._errorIfStereotypeIsMissing = errorIfStereotypeIsMissing;
        for (Profile p : profiles) {
            this.registerProfile(p);
        }
    }

    public void registerProfile(Profile profile) {
        UmlTypesystem.fixName((NamedElement)profile);
        for (Type t : this.getAllOwnedTypes((Package)profile)) {
            AbstractType bt;
            String typeName;
            if (t instanceof Stereotype) {
                Stereotype st = (Stereotype)t;
                UmlTypesystem.fixName((NamedElement)st);
                typeName = this.getFullName((NamedElement)st);
                bt = new StereotypeType(typeName, st, this);
                this._stereotypeTypes.put(typeName, (BackendType)bt);
                continue;
            }
            if (!(t instanceof Enumeration)) continue;
            Enumeration en = (Enumeration)t;
            UmlTypesystem.fixName((NamedElement)en);
            typeName = this.getFullName((NamedElement)en);
            bt = new EnumType(typeName, en);
            this._stereotypeTypes.put(typeName, (BackendType)bt);
        }
    }

    private String getFullName(NamedElement ne) {
        return ne.getQualifiedName();
    }

    private Collection<Type> getAllOwnedTypes(Package pkg) {
        ArrayList<Type> result = new ArrayList<Type>((Collection<Type>)pkg.getOwnedTypes());
        for (Package child : pkg.getNestedPackages()) {
            result.addAll(this.getAllOwnedTypes(child));
        }
        return result;
    }

    public static void fixName(NamedElement elem) {
        if (elem.getName() == null) {
            return;
        }
        elem.setName(elem.getName().replaceAll("\\s", "_"));
    }

    private static void registerPrimitiveByName(String name, BackendType type) {
        _uml2Primitives.put(name.toLowerCase(), type);
    }

    public BackendType findType(Object o) {
        BackendType stType;
        if (!(o instanceof Type) && o instanceof Element && (stType = this.getTypeByStereotype((Element)o)) != null) {
            return stType;
        }
        if (o instanceof EnumerationLiteral) {
            EnumerationLiteral el = (EnumerationLiteral)o;
            BackendType result = this.getTypeByStereotype((Element)el);
            if (result != null) {
                return result;
            }
            return this._rootTs.findType((Object)el.getEnumeration());
        }
        if (o instanceof Element && (stType = this.getTypeByStereotype((Element)o)) != null) {
            return stType;
        }
        return this._emfTypesystem.findType(o);
    }

    private BackendType getTypeByStereotype(Element element) {
        EList stereotypes = element.getAppliedStereotypes();
        if (stereotypes.isEmpty()) {
            if (this._errorIfStereotypeIsMissing && !stereotypes.toString().equals("[]")) {
                throw new RuntimeException("Stereotype could not be loaded! Possible hint: '" + stereotypes);
            }
            if (element.getOwner() instanceof Profile && element instanceof Enumeration) {
                Enumeration e = (Enumeration)element;
                return this._stereotypeTypes.get(this.getFullName((NamedElement)e));
            }
            if (element instanceof Stereotype) {
                return this._stereotypeTypes.get(this.getFullName((NamedElement)((Stereotype)element)));
            }
            return null;
        }
        ArrayList<BackendType> stTypes = new ArrayList<BackendType>();
        for (Stereotype st : stereotypes) {
            BackendType stType = this._stereotypeTypes.get(this.getFullName((NamedElement)st));
            if (stType == null) continue;
            stTypes.add(stType);
        }
        switch (stTypes.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (BackendType)stTypes.get(0);
            }
        }
        return new MultipleStereotypeType(stTypes);
    }

    private BackendType getTypeByStereotypeList(List<?> stereotypes) {
        ArrayList<BackendType> stTypes = new ArrayList<BackendType>();
        for (Object o : stereotypes) {
            BackendType stType;
            if (!(o instanceof Stereotype) || (stType = this.findType(o)) == null) continue;
            stTypes.add(stType);
        }
        if (stereotypes.size() > 0) {
            return new MultipleStereotypeType(stTypes);
        }
        return null;
    }

    public BackendType getTypeForEClassifier(EClassifier eClassifier) {
        return this._emfTypesystem.getTypeForEClassifier(eClassifier);
    }

    public BackendType findType(Class<?> cls) {
        return this._emfTypesystem.findType(cls);
    }

    public BackendTypesystem getRootTypesystem() {
        return this._rootTs;
    }

    public void setRootTypesystem(BackendTypesystem ts) {
        this._emfTypesystem.setRootTypesystem(ts);
        this._rootTs = ts;
    }

    public BackendType findType(String uniqueRepresentation) {
        if (!uniqueRepresentation.startsWith(UNIQUE_REPRESENTATION_PREFIX)) {
            return null;
        }
        BackendType bt = this._stereotypeTypes.get(uniqueRepresentation = uniqueRepresentation.substring(UNIQUE_REPRESENTATION_PREFIX.length()));
        if (bt != null) {
            return bt;
        }
        String umlNsUri = UMLFactory.eINSTANCE.getEPackage().getNsURI();
        String emfUniqueRepresentation = "{emf}{" + umlNsUri + "}" + uniqueRepresentation.substring(uniqueRepresentation.indexOf("::") + 2);
        bt = this._emfTypesystem.findType(emfUniqueRepresentation);
        if (bt != null) {
            return bt;
        }
        return null;
    }

    public static String getUniqueIdentifier(NamedElement cls) {
        if (!cls.getQualifiedName().startsWith("uml::")) {
            EList stereoTypes = cls.getAppliedStereotypes();
            if (stereoTypes.size() > 1) {
                StringBuffer typeNames = new StringBuffer();
                Iterator stIt = stereoTypes.iterator();
                while (stIt.hasNext()) {
                    Stereotype stereotype = (Stereotype)stIt.next();
                    typeNames.append(stereotype.getQualifiedName());
                    if (!stIt.hasNext()) continue;
                    typeNames.append(",");
                }
                return UNIQUE_REPRESENTATION_PREFIX + typeNames.toString();
            }
            if (stereoTypes.size() == 1) {
                return UNIQUE_REPRESENTATION_PREFIX + ((Stereotype)cls.getAppliedStereotypes().get(0)).getQualifiedName();
            }
        }
        return UNIQUE_REPRESENTATION_PREFIX + cls.getQualifiedName();
    }

    public BackendType getTypeForStereotypeProperty(Type t) {
        BackendType umlPrimitive;
        if (t.getName() != null && (umlPrimitive = _uml2Primitives.get(t.getName().toLowerCase())) != null) {
            return umlPrimitive;
        }
        return this.findType(t);
    }
}

