/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.ui.compiler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.compiler.templates.java5.Java5CompilerFacade;
import org.eclipse.xtend.backend.types.CompositeTypesystem;
import org.eclipse.xtend.backend.types.CompositeTypesystemFactory;
import org.eclipse.xtend.backend.ui.Activator;
import org.eclipse.xtend.backend.ui.compiler.NamingHelper;
import org.eclipse.xtend.backend.ui.middleend.LanguageSpecificMiddleEndConfigurer;
import org.eclipse.xtend.middleend.MiddleEnd;
import org.eclipse.xtend.middleend.MiddleEndFactory;
import org.eclipse.xtend.middleend.plugins.LanguageSpecificMiddleEnd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackendBuilder
extends IncrementalProjectBuilder {
    public static final String BACKEND_GEN_FOLDER = "backend-gen";
    public static final String BUILDER_ID = "org.eclipse.xtend.backend.compiler.BackendBuilder";
    private static final Log _log = LogFactory.getLog(BackendBuilder.class);
    private List<LanguageSpecificMiddleEnd> middleends;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        ClassLoader origCl = Thread.currentThread().getContextClassLoader();
        try {
            IJavaProject jp = JavaCore.create((IProject)this.getProject());
            URLClassLoader backendCl = new URLClassLoader(this.getBuildClasspath(jp), origCl);
            Thread.currentThread().setContextClassLoader(backendCl);
            if (monitor != null) {
                final String taskName = "Compiling project " + this.getProject().getName();
                monitor = new ProgressMonitorWrapper((IProgressMonitor)monitor){

                    public void subTask(String name) {
                        super.subTask(String.valueOf(taskName) + name);
                    }
                };
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            if (kind == 6) {
                this.doFullBuild(progress.newChild(1));
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.doFullBuild(progress.newChild(1));
                } else {
                    this.doIncrementalBuild(delta, progress.newChild(1));
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCl);
            if (monitor != null) {
                monitor.done();
            }
        }
        return null;
    }

    protected void doFullBuild(SubMonitor progress) {
        try {
            IJavaProject jp = JavaCore.create((IProject)this.getProject());
            IPackageFragmentRoot[] roots = jp.getPackageFragmentRoots();
            HashMap<IResource, IPath> resources = new HashMap<IResource, IPath>();
            String defaultCharset = this.getProject().getDefaultCharset();
            ArrayList<String> srcFolders = new ArrayList<String>(roots.length);
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n2];
                if (!iPackageFragmentRoot.getPath().equals((Object)this.getOutputFolder(progress))) {
                    if (iPackageFragmentRoot.getResource() != null && !iPackageFragmentRoot.isArchive()) {
                        srcFolders.add(iPackageFragmentRoot.getResource().getRawLocation().toOSString());
                    }
                    this.getAllResources(iPackageFragmentRoot, iPackageFragmentRoot.getResource(), resources);
                }
                ++n2;
            }
            HashSet<String> resNames = new HashSet<String>(resources.size());
            List middleends = this.createMiddleEnd().getLanguageSpecificMiddleEnds();
            for (Map.Entry entry : resources.entrySet()) {
                if (!this.isBackendCompilableResource((IResource)entry.getKey(), middleends)) continue;
                resNames.add(((IPath)entry.getValue()).toOSString());
            }
            HashMap hashMap = new HashMap();
            HashSet<String> btsQualifiers = new HashSet<String>();
            this.configureMiddleends(jp, hashMap, btsQualifiers);
            CompositeTypesystem bts = CompositeTypesystemFactory.INSTANCE.createTypesystem(btsQualifiers);
            if (!resNames.isEmpty()) {
                this.compile(progress, resNames, hashMap, (BackendTypesystem)bts, defaultCharset);
            }
        }
        catch (CoreException e) {
            _log.error((Object)"Error doing full build ", (Throwable)e);
        }
        catch (Exception e) {
            _log.error((Object)e);
        }
    }

    private void doIncrementalBuild(IResourceDelta delta, SubMonitor monitor) throws CoreException {
        BackendDeltaVisitor visitor = new BackendDeltaVisitor((IProgressMonitor)monitor);
        delta.accept((IResourceDeltaVisitor)visitor);
    }

    protected void onAddOrUpdate(IFile resource, IProgressMonitor monitor) {
        IProject project;
        if (resource.exists() && (project = this.getProject()) != null) {
            try {
                List<String> resNames;
                String charset = resource.getCharset();
                IJavaProject jp = JavaCore.create((IProject)this.getProject());
                HashMap specificParams = new HashMap();
                HashSet<String> btsQualifiers = new HashSet<String>();
                this.configureMiddleends(jp, specificParams, btsQualifiers);
                CompositeTypesystem bts = CompositeTypesystemFactory.INSTANCE.createTypesystem(btsQualifiers);
                IPath resPath = null;
                IPackageFragmentRoot[] roots = jp.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getResource() != null && !roots[i].isArchive()) {
                        IResource packageRoot = roots[i].getResource();
                        if (resource.getRawLocation().toOSString().startsWith(packageRoot.getRawLocation().toOSString())) {
                            resPath = resource.getFullPath().makeRelativeTo(packageRoot.getFullPath());
                            break;
                        }
                    }
                    ++i;
                }
                if (resPath != null && !(resNames = Arrays.asList(resPath.toOSString())).isEmpty()) {
                    if (charset != null) {
                        this.compile(SubMonitor.convert((IProgressMonitor)monitor, (int)1), resNames, specificParams, (BackendTypesystem)bts, charset);
                    } else {
                        this.compile(SubMonitor.convert((IProgressMonitor)monitor, (int)1), resNames, specificParams, (BackendTypesystem)bts, this.getProject().getDefaultCharset());
                    }
                }
            }
            catch (CoreException e) {
                _log.error((Object)("Error building " + resource.getLocation().toOSString() + " incrementally"), (Throwable)e);
            }
        }
    }

    protected void onRemoval(IFile resource, IProgressMonitor monitor) {
    }

    private void compile(SubMonitor progress, Collection<String> resNames, Map<Class<?>, Object> specificParams, BackendTypesystem bts, String fileEncoding) throws CoreException {
        Java5CompilerFacade compiler = new Java5CompilerFacade(bts);
        String middleEndPackage = "org.example";
        String middleEndName = this.getMiddleendName();
        String outputDir = this.getOutputFolder(progress).getRawLocation().toOSString();
        _log.info((Object)("Compiling M2T Backend executable resources " + resNames.toString()));
        compiler.compile(resNames, "org.example", middleEndName, outputDir, specificParams, fileEncoding);
    }

    private void configureMiddleends(IJavaProject project, Map<Class<?>, Object> specificParams, Set<String> btsQualifiers) {
        List<LanguageSpecificMiddleEndConfigurer> configurers = Activator.getInstance().getMiddleEndConfigurers();
        for (LanguageSpecificMiddleEndConfigurer c : configurers) {
            c.getMiddleEndName();
            Map<Class<?>, Object> params = c.getSpecificParams(project);
            specificParams.putAll(params);
            btsQualifiers.addAll(c.getConfiguredTypeSystems(project));
        }
    }

    private MiddleEnd createMiddleEnd() {
        IJavaProject jp = JavaCore.create((IProject)this.getProject());
        HashMap specificParams = new HashMap();
        HashSet<String> btsQualifiers = new HashSet<String>();
        this.configureMiddleends(jp, specificParams, btsQualifiers);
        CompositeTypesystem bts = CompositeTypesystemFactory.INSTANCE.createTypesystem(btsQualifiers);
        if (MiddleEndFactory.canCreateFromExtentions()) {
            return MiddleEndFactory.createFromExtensions((BackendTypesystem)bts, specificParams);
        }
        return null;
    }

    private String getMiddleendName() {
        return NamingHelper.toMiddleEndClassName(this.getProject().getName(), null);
    }

    private void getAllResources(IPackageFragmentRoot root, IResource res, Map<IResource, IPath> resources) {
        if (res instanceof IFile && !res.isHidden()) {
            IPath filePath = res.getFullPath();
            IPath srcRootPath = root.getResource().getFullPath();
            IPath relFilePath = filePath.makeRelativeTo(srcRootPath);
            resources.put(res, relFilePath);
        } else if (res instanceof IFolder) {
            try {
                IResource[] iResourceArray = ((IFolder)res).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource r = iResourceArray[n2];
                    this.getAllResources(root, r, resources);
                    ++n2;
                }
            }
            catch (CoreException e) {
                _log.error((Object)"Error collecting resources for full build", (Throwable)e);
            }
            catch (Exception e) {
                _log.error((Object)"Error collecting resources for full build", (Throwable)e);
            }
        }
    }

    private IFolder getOutputFolder(SubMonitor monitor) throws CoreException {
        IFolder genFolder = this.getProject().getFolder(BACKEND_GEN_FOLDER);
        if (!genFolder.exists()) {
            genFolder.create(true, true, (IProgressMonitor)monitor);
        }
        return genFolder;
    }

    boolean isOnJavaClassPath(IResource resource) {
        IJavaProject jp = JavaCore.create((IProject)resource.getProject());
        if (jp != null) {
            return jp.isOnClasspath(resource);
        }
        return false;
    }

    private boolean isBackendCompilableResource(IResource resource, List<LanguageSpecificMiddleEnd> middleends) {
        String resourcePath = resource.getLocation().toOSString();
        if (resource instanceof IFile && !resourcePath.endsWith(".class") && !resourcePath.endsWith(".java") && this.isOnJavaClassPath(resource)) {
            for (LanguageSpecificMiddleEnd me : middleends) {
                boolean isCanditate = me.mayHandle(resourcePath);
                if (!isCanditate) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected URL[] getBuildClasspath(IJavaProject jp) {
        try {
            List<String> srcFolders = this.getSourceFolders(jp.getProject(), new LinkedList<String>());
            URL[] srcUrls = this.getbuildClasspathUrls(srcFolders);
            return srcUrls;
        }
        catch (CoreException e) {
            _log.error((Object)e);
            return null;
        }
    }

    private List<String> getSourceFolders(IProject project, List<String> srcFolders) throws CoreException {
        IPackageFragmentRoot[] roots;
        IJavaProject jp = JavaCore.create((IProject)project);
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = jp.getPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n2];
            if (!iPackageFragmentRoot.getPath().equals((Object)jp.getProject().getFolder(BACKEND_GEN_FOLDER)) && iPackageFragmentRoot.getResource() != null && !iPackageFragmentRoot.isArchive()) {
                srcFolders.add(iPackageFragmentRoot.getResource().getRawLocation().toOSString());
            }
            ++n2;
        }
        iPackageFragmentRootArray = project.getReferencedProjects();
        n = iPackageFragmentRootArray.length;
        n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot refProject = iPackageFragmentRootArray[n2];
            this.getSourceFolders((IProject)refProject, srcFolders);
            ++n2;
        }
        return srcFolders;
    }

    private URL[] getbuildClasspathUrls(List<String> srcFolders) {
        URL[] srcUrls = new URL[srcFolders.size()];
        int i = 0;
        while (i < srcFolders.size()) {
            StringBuilder urlBuilder = new StringBuilder("file://");
            urlBuilder.append(srcFolders.get(i));
            urlBuilder.append(File.separator);
            try {
                URL currUrl;
                srcUrls[i] = currUrl = new URL(urlBuilder.toString());
            }
            catch (MalformedURLException e) {
                _log.error((Object)e);
            }
            ++i;
        }
        return srcUrls;
    }

    class BackendDeltaVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        private final IProgressMonitor _monitor;
        private List<LanguageSpecificMiddleEnd> _middleends;

        public BackendDeltaVisitor(IProgressMonitor monitor) {
            this._monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (this._middleends == null) {
                this._middleends = BackendBuilder.this.createMiddleEnd().getLanguageSpecificMiddleEnds();
            }
            if (BackendBuilder.this.isBackendCompilableResource(resource, this._middleends)) {
                switch (delta.getKind()) {
                    case 1: {
                        BackendBuilder.this.onAddOrUpdate((IFile)resource, this._monitor);
                        break;
                    }
                    case 2: {
                        BackendBuilder.this.onRemoval((IFile)resource, this._monitor);
                        break;
                    }
                    case 4: {
                        BackendBuilder.this.onAddOrUpdate((IFile)resource, this._monitor);
                    }
                }
            }
            this._monitor.worked(1);
            return true;
        }

        public boolean visit(IResource resource) {
            if (this._middleends == null) {
                this._middleends = BackendBuilder.this.createMiddleEnd().getLanguageSpecificMiddleEnds();
            }
            if (BackendBuilder.this.isBackendCompilableResource(resource, this._middleends)) {
                BackendBuilder.this.onAddOrUpdate((IFile)resource, this._monitor);
            }
            this._monitor.worked(1);
            return true;
        }
    }
}

