/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.xpath.functions.extras;

import java.util.List;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathUtil;

public class PropertiesEncodeFunction
implements XPathFunction {
    public Object evaluate(List args) {
        String input = XPathUtil.xpathString(args.get(0));
        boolean leadingSpacesOnly = args.size() == 1 ? false : XPathUtil.xpathBoolean(args.get(1));
        return PropertiesEncodeFunction.encode(input, leadingSpacesOnly);
    }

    public static String encode(String input, boolean leadingSpacesOnly) {
        StringBuffer buffer = new StringBuffer(input.length());
        boolean encodeSpaces = true;
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    if (leadingSpacesOnly) {
                        encodeSpaces = false;
                    }
                    buffer.append('\\');
                    buffer.append(c);
                    break;
                }
                case ' ': {
                    if (encodeSpaces) {
                        buffer.append('\\');
                    }
                    buffer.append(c);
                    break;
                }
                default: {
                    if (leadingSpacesOnly) {
                        encodeSpaces = false;
                    }
                    if (' ' <= c && c <= '~') {
                        buffer.append(c);
                        break;
                    }
                    buffer.append('\\').append('u').append(Character.forDigit(c >> 12 & 0xF, 16)).append(Character.forDigit(c >> 8 & 0xF, 16)).append(Character.forDigit(c >> 4 & 0xF, 16)).append(Character.forDigit(c & 0xF, 16));
                }
            }
            ++i;
        }
        return buffer.toString();
    }
}

