/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.extensionpoints.TagLibraryDataFactory;
import org.eclipse.jet.taglib.TagLibrary;

public final class InternalTagLibManager
implements IRegistryChangeListener {
    private static final String PLUGIN_ID = "org.eclipse.jet";
    private static final String EXTENSION_NAME = "tagLibraries";
    private static final String EXTENSION_POINT_ID = "org.eclipse.jet.tagLibraries";
    private final Map tagLibraries = new HashMap();
    private static final String E_TAGLIBRARY = "tagLibrary";
    private static final String A_TAGLIBRARY_ID = "id";

    public void startup() {
        InternalJET2Platform.IMethodTimer timer = InternalJET2Platform.getStartupMethodTimer(this.getClass(), "startup()");
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] configElements = reg.getConfigurationElementsFor(EXTENSION_POINT_ID);
        this.addTagLibraries(configElements);
        reg.addRegistryChangeListener((IRegistryChangeListener)this, PLUGIN_ID);
        timer.done();
    }

    private void addTagLibraries(IConfigurationElement[] configElements) {
        int i = 0;
        while (i < configElements.length) {
            String namespace;
            TagLibrary tagLibrary;
            String libraryId;
            if (E_TAGLIBRARY.equals(configElements[i].getName()) && !this.tagLibraries.containsKey(libraryId = (tagLibrary = TagLibraryDataFactory.INSTANCE.createTagLibrary(namespace = this.getNamespace(configElements[i]), configElements[i])).getLibraryId())) {
                this.tagLibraries.put(libraryId, tagLibrary);
            }
            ++i;
        }
    }

    private String getNamespace(IConfigurationElement element) throws InvalidRegistryObjectException {
        return element.getDeclaringExtension().getNamespace();
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas(PLUGIN_ID, EXTENSION_NAME);
        int i = 0;
        while (i < deltas.length) {
            IExtension ext = deltas[i].getExtension();
            if (deltas[i].getKind() == 1) {
                this.addTagLibraries(ext.getConfigurationElements());
            } else {
                this.removeTagLibraries(ext.getConfigurationElements());
            }
            ++i;
        }
    }

    private void removeTagLibraries(IConfigurationElement[] configElements) {
        int i = 0;
        while (i < configElements.length) {
            String libraryId;
            String id;
            if (E_TAGLIBRARY.equals(configElements[i].getName()) && (id = configElements[i].getAttribute(A_TAGLIBRARY_ID)) != null && this.tagLibraries.containsKey(libraryId = String.valueOf(this.getNamespace(configElements[i])) + "." + id)) {
                this.tagLibraries.remove(libraryId);
            }
            ++i;
        }
    }

    public void shutdown() {
        InternalJET2Platform.IMethodTimer timer = InternalJET2Platform.getStartupMethodTimer(this.getClass(), "shutdown()");
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        reg.removeRegistryChangeListener((IRegistryChangeListener)this);
        this.tagLibraries.clear();
        timer.done();
    }

    public TagLibrary getTagLibrary(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        return (TagLibrary)this.tagLibraries.get(id);
    }

    public String[] getKnownTagLibraryIds() {
        return this.tagLibraries.keySet().toArray(new String[this.tagLibraries.size()]);
    }

    public void forceRefresh(String id) {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensions(id);
        int i = 0;
        while (i < extensions.length) {
            if (EXTENSION_POINT_ID.equals(extensions[i].getExtensionPointUniqueIdentifier())) {
                this.addTagLibraries(extensions[i].getConfigurationElements());
            }
            ++i;
        }
    }
}

