/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib;

import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;

public class DocumentHelper {
    static /* synthetic */ Class class$0;

    private DocumentHelper() {
    }

    public static void installPositionCategory(IDocument document, String category) {
        if (!document.containsPositionCategory(category)) {
            document.addPositionCategory(category);
            document.addPositionUpdater((IPositionUpdater)new OverrideablePositionUpdater(category));
        }
    }

    public static void indent(BufferedJET2Writer bodyContent, int depth, String indent) {
        char[] indentArray = indent.toCharArray();
        int indentLength = indentArray.length;
        char[] fullIndent = new char[indentLength * depth];
        int i = 0;
        while (i < depth) {
            System.arraycopy(indentArray, 0, fullIndent, i * indentLength, indentLength);
            ++i;
        }
        String indentation = new String(fullIndent);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDocument document = (IDocument)bodyContent.getAdapter((Class)clazz);
        int numberOfLines = document.getNumberOfLines();
        int line = 0;
        while (line < numberOfLines) {
            try {
                IRegion lineInformation = document.getLineInformation(line);
                if (lineInformation.getLength() > 0 || line < numberOfLines - 1) {
                    document.replace(lineInformation.getOffset(), 0, indentation);
                }
            }
            catch (BadLocationException e) {
                RuntimeException rte = new RuntimeException("Unexpected exception: line = " + line);
                rte.initCause(e);
                throw rte;
            }
            ++line;
        }
    }

    public static interface IPositionUpdaterOverride {
        public boolean update(int var1, int var2, int var3);
    }

    public static class InsertAfterEmptyPosition
    extends Position
    implements IPositionUpdaterOverride {
        public InsertAfterEmptyPosition(int length) {
            super(length);
        }

        public boolean update(int changeOffset, int changeLength, int replacementLength) {
            return changeLength == 0 && this.getLength() == 0 && changeOffset == this.getOffset();
        }
    }

    public static class OverrideablePositionUpdater
    extends DefaultPositionUpdater {
        public OverrideablePositionUpdater(String category) {
            super(category);
        }

        protected void adaptToReplace() {
            if (this.fPosition instanceof IPositionUpdaterOverride && ((IPositionUpdaterOverride)this.fPosition).update(this.fOffset, this.fLength, this.fReplaceLength)) {
                return;
            }
            super.adaptToReplace();
        }
    }
}

