/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jet.core.compiler.JETCompilerOptions;
import org.eclipse.jet.core.parser.DefaultTemplateResolver;
import org.eclipse.jet.core.parser.ITagLibraryResolver;
import org.eclipse.jet.core.parser.ITemplateInput;
import org.eclipse.jet.core.parser.ITemplateResolver;
import org.eclipse.jet.core.parser.ProblemSeverity;
import org.eclipse.jet.core.parser.RecursiveIncludeException;
import org.eclipse.jet.core.parser.ast.JETASTParser;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.internal.compiler.LoaderGenerationParameters;
import org.eclipse.jet.internal.compiler.TemplateRunner;
import org.eclipse.jet.internal.core.NewLineUtil;
import org.eclipse.jet.internal.core.compiler.DuplicateGeneratedClassException;
import org.eclipse.jet.internal.core.compiler.ICompilerOutput;
import org.eclipse.jet.internal.core.compiler.IJETCompiler;
import org.eclipse.jet.internal.core.compiler.IncludeDependencies;
import org.eclipse.jet.internal.core.compiler.IncludeDependenciesUtil;
import org.eclipse.jet.internal.core.compiler.UniqueNameGenerator;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.TagLibrary;
import org.eclipse.jet.taglib.TagLibraryReference;

public final class SimplifiedCompiler
implements IJETCompiler {
    private static final String JET_TEMPLATE_MAP_PROPERTIES = "jetTemplateMap.properties";
    private final int jetSpec;
    private final ITemplateResolver templateResolver;
    private final Map predefinedTagLibraries;
    private final Map options;
    private final UniqueNameGenerator uniqueNameGenerator;
    private final Map pathToRefTagLibSet;
    private final ICompilerOutput compilerOutput;
    private final ITemplateMatcher templateMatcher;
    private final String templateLoaderClassName;
    private final String templateLoaderPackage;
    private final ITagLibraryResolver tagLibraryResolver;
    private final IncludeDependencies includeDependencies;
    private boolean enableEmbeddedExpressions;
    private static final ITagLibraryResolver nullTagLibraryResolver = new ITagLibraryResolver(){

        public TagLibrary getLibrary(String tagLibraryID) {
            return null;
        }
    };
    private static final String NL = System.getProperty("line.separator");

    private SimplifiedCompiler(Builder builder) {
        this.jetSpec = builder.jetSpec;
        this.templateResolver = builder.templateResolver == null ? new NullTemplateResolver() : builder.templateResolver;
        this.predefinedTagLibraries = builder.predefinedTagLibraries == null ? Collections.EMPTY_MAP : new HashMap(builder.predefinedTagLibraries);
        this.options = builder.options == null ? JETCompilerOptions.getDefaultCompilerOptions() : new HashMap(builder.options);
        Map pathToFQNMap = builder.savedState == null ? Collections.EMPTY_MAP : builder.savedState.pathToFQNMap;
        Map fqnToPathMap = builder.savedState == null ? Collections.EMPTY_MAP : builder.savedState.fqnToPathMap;
        this.uniqueNameGenerator = new UniqueNameGenerator(pathToFQNMap, fqnToPathMap, JETCompilerOptions.getStringOption((Map)this.options, (String)"org.eclipse.jet.compiledTemplatePackage"));
        this.compilerOutput = builder.compilerOutput;
        if (builder.templateLoaderFQN == null) {
            this.templateLoaderPackage = null;
            this.templateLoaderClassName = null;
        } else {
            int index = builder.templateLoaderFQN.lastIndexOf(46);
            this.templateLoaderPackage = index >= 0 ? builder.templateLoaderFQN.substring(0, index) : "";
            this.templateLoaderClassName = index >= 0 ? builder.templateLoaderFQN.substring(index + 1) : builder.templateLoaderFQN;
        }
        HashSet<String> sourceExtensions = new HashSet<String>();
        String[] extensions = JETCompilerOptions.getStringOption((Map)this.options, (String)"org.eclipse.jet.templateExt").split(",");
        int i = 0;
        while (i < extensions.length) {
            sourceExtensions.add(extensions[i].trim());
            ++i;
        }
        this.pathToRefTagLibSet = builder.savedState == null ? new HashMap() : new HashMap(builder.savedState.pathToRefTagLibSet);
        this.tagLibraryResolver = builder.tagLibraryResolver == null ? nullTagLibraryResolver : builder.tagLibraryResolver;
        this.includeDependencies = builder.savedState == null ? new IncludeDependencies() : builder.savedState.includeDependencies;
        this.templateMatcher = builder.jetSpec == 1 ? new JET1TemplateMatcher(JETCompilerOptions.getStringOption((Map)this.options, (String)"org.eclipse.jet.v1TemplatesDir")) : new JET2TemplateMatcher(sourceExtensions);
        this.enableEmbeddedExpressions = builder.enabledEmbeddedExpressions;
    }

    public IJETCompiler.CompileResult compile(String templatePath) {
        if (!this.isJETSourceFile(templatePath)) {
            return IJETCompiler.CompileResult.IGNORED;
        }
        this.compilerOutput.preCompile(templatePath);
        JETCompilationUnit cu = (JETCompilationUnit)new JETASTParser.Builder(this.jetSpec).templateResolver(this.templateResolver).predefinedTagLibraries(this.predefinedTagLibraries).tagLibraryResolver(this.tagLibraryResolver).enableEmbeddedExpressions(this.enableEmbeddedExpressions).build().parse(templatePath);
        try {
            String oldOutputPath = this.uniqueNameGenerator.getGeneratedOutputPath(templatePath);
            this.uniqueNameGenerator.ensureJavaOutputSet(templatePath, cu);
            TemplateRunner templateRunner = new TemplateRunner();
            String cgTemplatePath = this.jetSpec == 1 ? "templates/v1/jet2java.jet" : "templates/v2/jet2java.jet";
            String code = templateRunner.generate(cgTemplatePath, Collections.singletonMap("cu", cu));
            String outputPath = this.outputPath(cu.getOutputJavaPackage(), cu.getOutputJavaClassName());
            if (oldOutputPath != null && !oldOutputPath.equals(outputPath)) {
                this.compilerOutput.removeOutput(oldOutputPath);
            }
            this.compilerOutput.writeOutput(outputPath, NewLineUtil.setLineTerminator((CharSequence)code, (String)NL), null);
            if (cu.hasErrors() || cu.hasWarnings()) {
                this.compilerOutput.recordProblems(templatePath, cu.getProblems());
            }
            this.updateDependencies(templatePath, cu);
        }
        catch (DuplicateGeneratedClassException e) {
            cu.createProblem(ProblemSeverity.ERROR, 10, JET2Messages.JET2Compiler_SameJavaClassAsOther, new Object[]{e.getTemplatePath(), e.getOtherTemplatePath()}, -1, -1, -1, -1);
        }
        if (cu.hasErrors()) {
            return IJETCompiler.CompileResult.ERRORS;
        }
        if (cu.hasWarnings()) {
            return IJETCompiler.CompileResult.WARNINGS;
        }
        return IJETCompiler.CompileResult.OK;
    }

    private void updateDependencies(String templatePath, JETCompilationUnit cu) {
        TagLibraryReference[] tlRefs = cu.getTagLibraryReferences();
        Set tlIdRefs = tlRefs.length == 0 ? Collections.EMPTY_SET : new HashSet(tlRefs.length);
        int i = 0;
        while (i < tlRefs.length) {
            tlIdRefs.add(tlRefs[i].getTagLibraryId());
            ++i;
        }
        this.pathToRefTagLibSet.put(templatePath, tlIdRefs);
        this.includeDependencies.removeDependencies(templatePath);
        this.includeDependencies.addDependencies(templatePath, IncludeDependenciesUtil.getDependencies((JETCompilationUnit)cu));
    }

    private String outputPath(String javaPackage, String className) {
        StringBuffer buffer = new StringBuffer(javaPackage.length() + className.length() + 6);
        if (javaPackage.length() > 0) {
            buffer.append(javaPackage.replace('.', '/')).append('/');
        }
        buffer.append(className).append(".java");
        return buffer.toString();
    }

    private String outputPath(String fqClassName) {
        StringBuffer buffer = new StringBuffer(fqClassName.length() + ".java".length());
        buffer.append(fqClassName.replace('.', '/')).append(".java");
        return buffer.toString();
    }

    private boolean isJETSourceFile(String templatePath) {
        return this.templateMatcher.isTemplate(templatePath);
    }

    public Serializable getMemento() {
        return new SaveStateMemento(this);
    }

    public void finish() {
        TemplateRunner templateRunner = new TemplateRunner();
        if (this.jetSpec == 1) {
            String mapContents = templateRunner.generate("templates/jetTemplateMap.properties.jet", Collections.singletonMap("args", this.uniqueNameGenerator.getPathToFQNMap()));
            this.compilerOutput.writeOutput(JET_TEMPLATE_MAP_PROPERTIES, NewLineUtil.setLineTerminator((CharSequence)mapContents, (String)NL), null);
        }
        if (this.templateLoaderClassName != null) {
            LoaderGenerationParameters args = new LoaderGenerationParameters(this.templateLoaderPackage, this.templateLoaderClassName, this.uniqueNameGenerator.getPathToFQNMap());
            HashMap<String, LoaderGenerationParameters> argsMap = new HashMap<String, LoaderGenerationParameters>(2);
            argsMap.put("args", args);
            argsMap.put("useJava5", (LoaderGenerationParameters)this.options.get("org.eclipse.jet.useJava5"));
            String code = templateRunner.generate("templates/jet2transform.jet", argsMap);
            this.compilerOutput.writeOutput(this.outputPath(this.templateLoaderPackage, this.templateLoaderClassName), NewLineUtil.setLineTerminator((CharSequence)code, (String)NL), null);
        }
    }

    public void clean() {
        Iterator i = this.uniqueNameGenerator.clean().iterator();
        while (i.hasNext()) {
            String fqJavaClass = (String)i.next();
            this.compilerOutput.removeOutput(this.outputPath(fqJavaClass));
        }
        if (this.templateLoaderClassName != null) {
            this.compilerOutput.removeOutput(this.outputPath(this.templateLoaderPackage, this.templateLoaderClassName));
            if (this.jetSpec == 1) {
                this.compilerOutput.removeOutput(JET_TEMPLATE_MAP_PROPERTIES);
            }
        }
        this.pathToRefTagLibSet.clear();
    }

    public void removeTemplate(String templatePath) {
        String outputPath = this.uniqueNameGenerator.remove(templatePath);
        if (outputPath != null) {
            this.compilerOutput.removeOutput(outputPath);
        }
        this.pathToRefTagLibSet.remove(templatePath);
    }

    public String[] getTagLibaryDependencies() {
        HashSet dependencies = new HashSet(this.predefinedTagLibraries.values());
        Iterator i = this.pathToRefTagLibSet.values().iterator();
        while (i.hasNext()) {
            Set templateDependencies = (Set)i.next();
            dependencies.addAll(templateDependencies);
        }
        return dependencies.toArray(new String[dependencies.size()]);
    }

    public boolean isTemplate(String templatePath) {
        return this.isJETSourceFile(templatePath);
    }

    public String[] getAffectedTemplatePaths(String changedFilePath) {
        HashSet<String> templatesToCompile = new HashSet<String>(Arrays.asList(this.includeDependencies.getAffectedTemplates(changedFilePath)));
        return templatesToCompile.toArray(new String[templatesToCompile.size()]);
    }

    /* synthetic */ SimplifiedCompiler(Builder builder, SimplifiedCompiler simplifiedCompiler) {
        this(builder);
    }

    public static final class Builder {
        final int jetSpec;
        ITemplateResolver templateResolver;
        SaveStateMemento savedState;
        Map options;
        final ICompilerOutput compilerOutput;
        String templateLoaderFQN;
        Map predefinedTagLibraries;
        ITagLibraryResolver tagLibraryResolver;
        boolean enabledEmbeddedExpressions = false;

        public Builder(int jetSpec, URI baseLocation, ICompilerOutput compilerOutput) {
            this(jetSpec, compilerOutput);
            this.templateResolver(new DefaultTemplateResolver.Builder(baseLocation).build());
        }

        public Builder(int jetSpec, ICompilerOutput compilerOutput) {
            this.jetSpec = jetSpec;
            this.compilerOutput = compilerOutput;
        }

        public Builder templateResolver(ITemplateResolver templateResolver) {
            this.templateResolver = templateResolver;
            return this;
        }

        public Builder savedState(Serializable savedState) {
            if (!(savedState instanceof SaveStateMemento)) {
                throw new IllegalArgumentException();
            }
            this.savedState = (SaveStateMemento)savedState;
            return this;
        }

        public Builder options(Map options) {
            this.options = options;
            return this;
        }

        public Builder templateLoaderFQN(String templateLoaderFQN) {
            this.templateLoaderFQN = templateLoaderFQN;
            return this;
        }

        public Builder predefinedTagLibraries(Map predefinedTagLibraries) {
            this.predefinedTagLibraries = predefinedTagLibraries;
            return this;
        }

        public Builder tagLibraryResolver(ITagLibraryResolver tagLibraryResolver) {
            this.tagLibraryResolver = tagLibraryResolver;
            return this;
        }

        public Builder enableEmbeddedExpressions(boolean enableEmbeddedExpressions) {
            this.enabledEmbeddedExpressions = enableEmbeddedExpressions;
            return this;
        }

        public SimplifiedCompiler build() {
            return new SimplifiedCompiler(this, null);
        }
    }

    public static interface ITemplateMatcher {
        public boolean isTemplate(String var1);
    }

    private static final class JET1TemplateMatcher
    implements ITemplateMatcher {
        private final String templatesDir;

        public JET1TemplateMatcher(String templatesDir) {
            this.templatesDir = templatesDir == null || templatesDir.length() == 0 ? "" : (templatesDir.endsWith("/") ? templatesDir : String.valueOf(templatesDir) + "/");
        }

        public boolean isTemplate(String templatePath) {
            return templatePath.startsWith(this.templatesDir) && templatePath.endsWith("jet");
        }
    }

    public static final class JET2TemplateMatcher
    implements ITemplateMatcher {
        private final Set sourceExtensions;

        public JET2TemplateMatcher(Set sourceExtensions) {
            this.sourceExtensions = sourceExtensions;
        }

        public boolean isTemplate(String templatePath) {
            int extensionIndex = templatePath.lastIndexOf(".");
            if (extensionIndex >= 0) {
                String extension = templatePath.substring(extensionIndex + 1);
                return this.sourceExtensions.contains(extension);
            }
            return false;
        }
    }

    private static final class NullTemplateResolver
    implements ITemplateResolver {
        private NullTemplateResolver() {
        }

        public URI[] getBaseLocations() {
            return new URI[0];
        }

        public ITemplateInput getIncludedInput(String templatePath, ITemplateInput[] activeInputs) throws RecursiveIncludeException {
            return null;
        }

        public ITemplateInput getInput(String templatePath) {
            return null;
        }
    }

    public static final class SaveStateMemento
    implements Serializable {
        private static final long serialVersionUID = -5023383826047467196L;
        private final Map fqnToPathMap;
        private final Map pathToFQNMap;
        private final Map pathToRefTagLibSet;
        private final IncludeDependencies includeDependencies;

        public SaveStateMemento(SimplifiedCompiler compiler) {
            this.fqnToPathMap = compiler.uniqueNameGenerator.getFQNToPathMap();
            this.pathToFQNMap = compiler.uniqueNameGenerator.getPathToFQNMap();
            this.pathToRefTagLibSet = new HashMap(compiler.pathToRefTagLibSet);
            this.includeDependencies = compiler.includeDependencies;
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (this.includeDependencies == null) {
                throw new IOException("includeDependencies is null");
            }
        }
    }
}

