/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.debug.model;

import java.util.List;
import java.util.Stack;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.emf.mwe.core.debug.model.SyntaxElement;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugElement;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugStackFrame;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugTarget;
import org.eclipse.emf.mwe.ui.debug.model.MWEBreakpoint;

public class DebugThread
extends DebugElement
implements IThread {
    private Stack<DebugStackFrame> frames = new Stack();
    private MWEBreakpoint bp;
    private boolean fStepping = false;
    private int varFrameId;

    public DebugThread(DebugTarget target) {
        super(target);
    }

    public boolean hasStackFrames() {
        return this.isSuspended();
    }

    public IStackFrame[] getStackFrames() {
        if (this.isSuspended()) {
            Stack<DebugStackFrame> result = new Stack<DebugStackFrame>();
            int size = this.frames.size();
            int i = size - 1;
            while (i >= 0) {
                DebugStackFrame frame = (DebugStackFrame)((Object)this.frames.get(i));
                if (frame.isVisible()) {
                    result.push(frame);
                }
                --i;
            }
            return result.toArray(new IStackFrame[0]);
        }
        return new IStackFrame[0];
    }

    public IStackFrame getTopStackFrame() {
        if (this.isSuspended() && !this.frames.isEmpty()) {
            return this.frames.peek();
        }
        return null;
    }

    public DebugStackFrame getStackFramePeek() {
        return this.frames.peek();
    }

    public int getSetVarFrameId(DebugStackFrame frame) {
        this.varFrameId = frame.getFrameId();
        return this.varFrameId;
    }

    public int getVarFrameId() {
        return this.varFrameId;
    }

    public void clearStack(int cleanStackLevel) {
        int i = this.frames.size();
        while (i > cleanStackLevel) {
            this.frames.pop();
            --i;
        }
    }

    public void pushStackFrames(List<SyntaxElement> list) {
        for (SyntaxElement se : list) {
            this.frames.push(new DebugStackFrame(this, se));
        }
    }

    public void setVariablesDirty() {
        for (DebugStackFrame frame : this.frames) {
            frame.setVariablesDirty();
        }
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.bp == null) {
            return new IBreakpoint[0];
        }
        return new IBreakpoint[]{this.bp};
    }

    public void setBreakpoint(MWEBreakpoint bp) {
        this.bp = bp;
    }

    public int getPriority() {
        return 0;
    }

    public String getName() {
        StringBuilder sb = new StringBuilder("State: " + this.getState());
        if (this.bp != null) {
            sb.append(" (breakpoint " + this.bp.getName() + ")");
        }
        return sb.toString();
    }

    public String getState() {
        return this.isTerminated() ? "terminated" : (this.isSuspended() ? "suspended" : (this.isStepping() ? "stepping" : "running"));
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public void setStepping(boolean stepping) {
        this.fStepping = stepping;
    }

    public boolean canStepInto() {
        return this.isSuspended();
    }

    public void stepInto() throws DebugException {
        this.getDebugModelManager().requireStepInto();
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public void stepOver() throws DebugException {
        this.getDebugModelManager().requireStepOver();
    }

    public boolean canStepReturn() {
        return this.isSuspended();
    }

    public void stepReturn() throws DebugException {
        this.getDebugModelManager().requireStepReturn();
    }

    public boolean canSuspend() {
        return this.getDebugTarget().canSuspend();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canResume() {
        return this.getDebugTarget().canResume();
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume();
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }
}

