/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.edit;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.edit.StateEditPart;
import org.eclipse.emf.henshin.statespace.explorer.edit.StateSpaceLayoutEditPolicy;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;

public class StateSpaceEditPart
extends AbstractGraphicalEditPart
implements Adapter {
    private StateSpaceManager manager;
    private Notifier target;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getStateSpace().eAdapters().add((Object)this);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getStateSpace().eAdapters().remove((Object)this);
            super.deactivate();
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new StateSpaceLayoutEditPolicy());
    }

    protected IFigure createFigure() {
        FreeformLayer layer = new FreeformLayer();
        layer.setBorder((Border)new MarginBorder(3));
        layer.setLayoutManager((LayoutManager)new FreeformLayout());
        ConnectionLayer connections = (ConnectionLayer)this.getLayer("Connection Layer");
        connections.setAntialias(1);
        return layer;
    }

    public void refreshLabels() {
        boolean hideIndizes = this.getStateSpace().isLayoutHideIndizes();
        boolean hideLabels = this.getStateSpace().isLayoutHideLabels();
        for (Object child : this.getChildren()) {
            if (!(child instanceof StateEditPart)) continue;
            ((StateEditPart)((Object)child)).refreshLabelAndLocation(hideIndizes, hideLabels);
        }
    }

    public StateSpace getStateSpace() {
        return (StateSpace)this.getModel();
    }

    public StateSpaceManager getStateSpaceManager() {
        return this.manager;
    }

    public void setStateSpaceManager(StateSpaceManager manager) {
        this.manager = manager;
    }

    protected List<?> getModelChildren() {
        return this.getStateSpace().getStates();
    }

    protected void removeChild(int index) {
        EditPart child = (EditPart)this.getChildren().get(index);
        this.fireRemovingChild(child, index);
        if (this.isActive()) {
            child.deactivate();
        }
        child.removeNotify();
        this.removeChildVisual(child);
        child.setParent(null);
        this.getChildren().remove(index);
    }

    public Notifier getTarget() {
        return this.target;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(Notification event) {
        switch (event.getFeatureID(StateSpace.class)) {
            case 2: {
                int type = event.getEventType();
                if (type == 3) {
                    EditPart editpart = this.createChild(event.getNewValue());
                    this.addChild(editpart, event.getPosition());
                    break;
                }
                if (type == 4) {
                    EditPart editpart = (EditPart)this.getChildren().get(event.getPosition());
                    this.removeChild(editpart);
                    break;
                }
                this.refreshChildren();
            }
        }
    }

    public void setTarget(Notifier target) {
        this.target = target;
    }
}

