/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.commands;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.emf.henshin.statespace.explorer.jobs.AbstractStateSpaceJob;
import org.eclipse.gef.commands.Command;

public abstract class AbstractStateSpaceCommand
extends Command {
    private StateSpaceManager manager;
    private Job job;
    private Throwable exception;

    public AbstractStateSpaceCommand(String label, StateSpaceManager manager) {
        super(label);
        this.manager = manager;
    }

    protected StateSpaceManager getStateSpaceManager() {
        return this.manager;
    }

    public void doExecute() throws StateSpaceException {
        this.doRedo();
    }

    public void doUndo() throws StateSpaceException {
    }

    public void doRedo() throws StateSpaceException {
    }

    public final void execute() {
        try {
            this.doExecute();
        }
        catch (Throwable e) {
            StateSpaceExplorerPlugin.getInstance().logError("Error while trying to " + this.getLabel(), e);
            if (this.job != null) {
                if (this.job instanceof AbstractStateSpaceJob) {
                    ((AbstractStateSpaceJob)this.job).abort();
                } else {
                    this.job.cancel();
                }
            }
            this.exception = e;
        }
    }

    public final void undo() {
        try {
            this.doUndo();
        }
        catch (Throwable e) {
            StateSpaceExplorerPlugin.getInstance().logError("Error while trying to " + this.getLabel(), e);
            if (this.job != null) {
                this.job.cancel();
            }
            this.exception = e;
        }
    }

    public final void redo() {
        try {
            this.doRedo();
        }
        catch (Throwable e) {
            StateSpaceExplorerPlugin.getInstance().logError("Error while trying to " + this.getLabel(), e);
            if (this.job != null) {
                this.job.cancel();
            }
            this.exception = e;
        }
    }

    public void setCallingJob(Job job) {
        this.job = job;
    }

    public Throwable getException() {
        return this.exception;
    }
}

