/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.actions;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.presentation.EcoreActionBarContributor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.editor.actions.EcoreSelectionDialogUtil;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.presentation.HenshinEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ImportPackageAction
implements IObjectActionDelegate {
    public static final String FROM_WORKSPACE_ACTION_ID = "importFromWorkspace";
    public static final String FROM_REGISTRY_ACTION_ID = "importFromRegistry";
    protected IWorkbenchPart workbenchPart;
    protected Module module;

    public void run(IAction action) {
        Shell shell = this.workbenchPart.getSite().getShell();
        ResourceSet resourceSet = this.module.eResource().getResourceSet();
        EPackage newPackage = FROM_WORKSPACE_ACTION_ID.equals(action.getId()) ? EcoreSelectionDialogUtil.selectEcoreFilePackage(shell, resourceSet) : ImportPackageAction.selectRegisteredPackage(shell, resourceSet);
        if (newPackage != null && newPackage.getNsURI() != null) {
            this.runImportCommand(newPackage);
        }
    }

    protected void runImportCommand(final EPackage epackage) {
        AbstractCommand command = new AbstractCommand("Import Package"){

            public boolean canUndo() {
                return false;
            }

            public boolean prepare() {
                return true;
            }

            public void execute() {
                this.redo();
            }

            public void redo() {
                ImportPackageAction.this.doImport(epackage);
            }
        };
        HenshinEditor editor = (HenshinEditor)this.workbenchPart;
        CommandStack stack = editor.getEditingDomain().getCommandStack();
        stack.execute((Command)command);
    }

    protected void doImport(EPackage epackage) {
        String nsURI = epackage.getNsURI();
        int i = 0;
        while (i < this.module.getImports().size()) {
            EPackage current = (EPackage)this.module.getImports().get(i);
            if (nsURI.equals(current.getNsURI()) && epackage != current) {
                this.module.getImports().set(i, (Object)epackage);
                return;
            }
            ++i;
        }
        this.module.getImports().add((Object)epackage);
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.workbenchPart = part instanceof HenshinEditor ? part : null;
        action.setEnabled(this.workbenchPart != null);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object first;
        this.module = null;
        if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof Module) {
            this.module = (Module)first;
        }
        action.setEnabled(this.module != null);
    }

    public static EPackage selectRegisteredPackage(Shell shell, ResourceSet resourceSet) {
        CustomRegisteredPackageDialog dialog = new CustomRegisteredPackageDialog(shell);
        dialog.setMultipleSelection(false);
        dialog.open();
        EPackage epackage = null;
        Object[] result = dialog.getResult();
        if (result != null) {
            List<Object> nsURIs = Arrays.asList(result);
            if (dialog.isDevelopmentTimeVersion()) {
                resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
                Map locationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
                if (result.length > 0) {
                    URI location = (URI)locationMap.get(result[0]);
                    Resource resource = resourceSet.getResource(location, true);
                    EcoreUtil.resolveAll((Resource)resource);
                }
                block0: for (Resource resource : resourceSet.getResources()) {
                    for (EPackage current : EcoreSelectionDialogUtil.getAllPackages(resource)) {
                        if (!nsURIs.contains(current.getNsURI())) continue;
                        epackage = current;
                        continue block0;
                    }
                }
            } else if (result.length > 0) {
                String uri = result[0].toString();
                return EPackage.Registry.INSTANCE.getEPackage(uri);
            }
        }
        return epackage;
    }

    protected static class CustomRegisteredPackageDialog
    extends EcoreActionBarContributor.ExtendedLoadResourceAction.RegisteredPackageDialog {
        public CustomRegisteredPackageDialog(Shell shell) {
            super(shell);
            this.setMessage("Select the package to import. In most cases you need the runtime version.");
            this.isDevelopmentTimeVersion = false;
        }

        protected Control createDialogArea(Composite parent) {
            Control result = super.createDialogArea(parent);
            this.updateButtons(result);
            return result;
        }

        private void updateButtons(Control control) {
            if (control instanceof Button) {
                Button button = (Button)control;
                String text = button.getText().toLowerCase();
                if (text.indexOf("runtime") >= 0) {
                    button.setSelection(true);
                } else {
                    button.setSelection(false);
                }
            }
            if (control instanceof Composite) {
                Control[] controlArray = ((Composite)control).getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    this.updateButtons(child);
                    ++n2;
                }
            }
        }
    }
}

