/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.testframework;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.HenshinGraph;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.util.Match;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.model.CountedUnit;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.model.impl.HenshinFactoryImpl;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.ocl.conditions.BooleanOCLCondition;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.IQueryResult;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.OCL;

public class Tools {
    protected static int[] getGraphSizes(UnitApplication ua) {
        EmfGraph graph = ((EmfEngine)ua.getInterpreterEngine()).getEmfGraph();
        int[] sizes = new int[2];
        sizes[0] = graph.geteObjects().size();
        ua.execute();
        sizes[1] = graph.geteObjects().size();
        return sizes;
    }

    public static TransformationUnit createTUFromRule(Rule r) {
        HenshinFactoryImpl hf = new HenshinFactoryImpl();
        CountedUnit cu = hf.createCountedUnit();
        cu.setCount(1);
        cu.setActivated(true);
        cu.setName("__CREATED_from_" + r.getName());
        cu.setDescription("automatically created from Rule " + r.getName() + "   [do not change]");
        cu.setSubUnit((TransformationUnit)r);
        return cu;
    }

    public static void printMatches(List<Match> ma) {
        System.out.println("matches:");
        for (Match m : ma) {
            for (EObject eo : m.getNodeMapping().values()) {
                System.out.println("\t" + eo);
            }
            System.out.println("--");
        }
    }

    public static void printMatch(Match ma) {
        System.out.println("match:");
        for (EObject eo : ma.getNodeMapping().values()) {
            System.out.println("\t" + eo);
        }
        System.out.println("--");
    }

    public static void printMatches(Match ma) {
        Tools.printMatch(ma);
    }

    public static void printGraph(EmfGraph graph) {
        for (EObject eo : graph.geteObjects()) {
            System.out.println(eo);
        }
    }

    public static void printGraph(Graph graph) {
        for (EObject eo : graph.eContents()) {
            System.out.println(eo);
            for (Edge edge : graph.getEdges()) {
                System.out.println("edge: " + edge);
            }
        }
    }

    public static void persist(EObject rootObject, String filename) throws IOException {
        ModelUtils.save((EObject)rootObject, (String)filename);
    }

    public static void persistAllEmbeddedGraphs(TransformationSystem ts, String path, String fileExt) throws IOException {
        for (Graph g : ts.getInstances()) {
            HenshinGraph hgr = new HenshinGraph(g);
            System.out.println("saving " + path + g.getName() + "." + fileExt);
            Tools.persist(Tools.getGraphRoot((EmfGraph)hgr), String.valueOf(path) + g.getName() + "." + fileExt);
        }
    }

    public static void persist(Rule rule, String filename) throws IOException {
        ResourceSetImpl rSet = new ResourceSetImpl();
        URI myURI = URI.createFileURI((String)filename);
        Resource res = rSet.createResource(myURI, "henshin");
        res.getContents().add((Object)rule);
        res.save(null);
    }

    public static Collection<? extends EObject> getOCLQueryResults(String contextFreeOclQuery, EmfGraph graph) {
        BooleanOCLCondition oclQueryCondition;
        OCL ocl = OCL.newInstance();
        try {
            oclQueryCondition = new BooleanOCLCondition(ocl.getEnvironment(), contextFreeOclQuery, null);
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new AssertionError((Object)("error parsing OCL query!   " + contextFreeOclQuery));
        }
        WHERE wr = new WHERE((EObjectCondition)oclQueryCondition);
        FROM fm = new FROM(graph.geteObjects());
        SELECT st = new SELECT(fm, wr);
        IQueryResult result = st.execute();
        return result.getEObjects();
    }

    public static EObject getFirstElementFromOCLQueryResult(String contextFreeOclQuery, EmfGraph graph) {
        BooleanOCLCondition oclQueryCondition;
        OCL ocl = OCL.newInstance();
        try {
            oclQueryCondition = new BooleanOCLCondition(ocl.getEnvironment(), contextFreeOclQuery, null);
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new AssertionError((Object)("error parsing OCL query!   " + contextFreeOclQuery));
        }
        WHERE wr = new WHERE((EObjectCondition)oclQueryCondition);
        FROM fm = new FROM(graph.geteObjects());
        SELECT st = new SELECT(fm, wr);
        IQueryResult result = st.execute();
        if (result.size() == 0) {
            return null;
        }
        return result.getEObjects().toArray(new EObject[1])[0];
    }

    public static EObject getGraphRoot(EmfGraph graph) {
        return graph.getRootObjects().toArray(new EObject[1])[0];
    }

    public static void printCollection(Collection<? extends EObject> coll) {
        System.out.println("-------");
        for (EObject eObject : coll) {
            System.out.println(eObject);
        }
        System.out.println("-------");
    }

    public static void printParameterMappings(RuleApplication ra) {
        for (Parameter p : ra.getMatch().getParameterValues().keySet()) {
            System.out.println(String.valueOf(p.getName()) + "\t-> " + ra.getMatch().getParameterValues().get(p));
        }
        for (Parameter p : ra.getComatch().getParameterValues().keySet()) {
            System.out.println(String.valueOf(p.getName()) + "\t<- " + ra.getComatch().getParameterValues().get(p));
        }
    }

    public static Map<Parameter, Object> createParameterMapping(Map<String, Object> mapping, Rule rule) {
        HashMap<Parameter, Object> pMapping = new HashMap<Parameter, Object>();
        for (Parameter param : rule.getParameters()) {
            if (mapping.get(param.getName()) == null) continue;
            pMapping.put(param, mapping.get(param.getName()));
        }
        return pMapping;
    }

    public static void printParameterMappings(UnitApplication ua) {
        for (Parameter p : ua.getParameterValues().keySet()) {
            System.out.println(String.valueOf(p.getName()) + "\t : " + ua.getParameterValues().get(p));
        }
    }
}

