/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.internal.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.util.Match;
import org.eclipse.emf.henshin.interpreter.util.ModelHelper;
import org.eclipse.emf.henshin.model.AmalgamationUnit;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationUnit;

public class AmalgamationInfo {
    private AmalgamationUnit amalgamationUnit;
    private Map<Parameter, Object> parameterValues;
    private Map<Node, Node> multiNode2kernelNode;
    private EmfEngine emfEngine;

    public AmalgamationInfo(EmfEngine emfEngine, AmalgamationUnit amalgamationUnit, Map<Parameter, Object> parameterValues) {
        this.emfEngine = emfEngine;
        this.amalgamationUnit = amalgamationUnit;
        this.parameterValues = parameterValues;
        this.multiNode2kernelNode = this.extractMappings((List<Mapping>)amalgamationUnit.getLhsMappings(), (List<Mapping>)amalgamationUnit.getRhsMappings());
    }

    private Map<Node, Node> extractMappings(List<Mapping> lhsMappings, List<Mapping> rhsMappings) {
        HashMap<Node, Node> multiNodeMap = new HashMap<Node, Node>();
        ArrayList<Mapping> unsortedMappings = new ArrayList<Mapping>(lhsMappings);
        unsortedMappings.addAll(rhsMappings);
        for (Mapping mapping : unsortedMappings) {
            Node kernelNode = mapping.getOrigin();
            Node multiNode = mapping.getImage();
            multiNodeMap.put(multiNode, kernelNode);
        }
        return multiNodeMap;
    }

    public RuleApplication getAmalgamationRule() {
        HenshinFactory factory = HenshinFactory.eINSTANCE;
        Rule kernelRule = this.amalgamationUnit.getKernelRule();
        Map<Node, EObject> kernelNodeMapping = ModelHelper.createPrematch((TransformationUnit)this.amalgamationUnit, this.parameterValues);
        HashMap<Node, EObject> parallelNodeMapping = new HashMap<Node, EObject>();
        Match prematch = new Match(kernelRule, this.parameterValues, kernelNodeMapping);
        RuleApplication kernelRuleApplication = new RuleApplication(this.emfEngine, kernelRule);
        kernelRuleApplication.setMatch(prematch);
        List<Match> kernelMatches = this.emfEngine.findAllMatches(kernelRuleApplication);
        if (kernelMatches.size() == 0) {
            return null;
        }
        Match kernelMatch = null;
        Collection<Match> multiMatches = null;
        for (Match match : kernelMatches) {
            multiMatches = this.getMultiRuleMatches(match);
            if (multiMatches == null) continue;
            kernelMatch = match;
            break;
        }
        if (multiMatches == null) {
            return null;
        }
        Rule parallelRule = factory.createRule();
        parallelRule.setName(this.amalgamationUnit.getName());
        parallelRule.setLhs(factory.createGraph());
        parallelRule.setRhs(factory.createGraph());
        HashMap<Node, Node> copyMap = new HashMap<Node, Node>();
        parallelNodeMapping.putAll(this.addMatchContent(parallelRule, kernelMatch, copyMap));
        for (Match multiMatch : multiMatches) {
            parallelNodeMapping.putAll(this.addMatchContent(parallelRule, multiMatch, copyMap));
        }
        RuleApplication parallelRuleApplication = new RuleApplication(this.emfEngine, parallelRule);
        Match parallelMatch = new Match(parallelRule, kernelMatch.getParameterValues(), parallelNodeMapping);
        parallelRuleApplication.setMatch(parallelMatch);
        for (Node node : parallelNodeMapping.keySet()) {
            parallelRuleApplication.addMatch(node, (EObject)parallelNodeMapping.get(node));
        }
        return parallelRuleApplication;
    }

    private Collection<Match> getMultiRuleMatches(Match kernelMatch) {
        ArrayList<Match> multiMatches = new ArrayList<Match>();
        for (Rule multiRule : this.amalgamationUnit.getMultiRules()) {
            Map<Node, EObject> multiRuleMappings = this.translateMapping(multiRule, kernelMatch);
            Match prematch = new Match(multiRule, this.parameterValues, multiRuleMappings);
            RuleApplication multiRuleApplication = new RuleApplication(this.emfEngine, multiRule);
            multiRuleApplication.setMatch(prematch);
            multiMatches.addAll(multiRuleApplication.findAllMatches());
        }
        if (multiMatches.size() > 0) {
            return multiMatches;
        }
        return null;
    }

    private Map<Node, EObject> translateMapping(Rule multiRule, Match kernelMatch) {
        Map<Node, EObject> kernelNodeMapping = kernelMatch.getNodeMapping();
        HashMap<Node, EObject> multiNodeMapping = new HashMap<Node, EObject>();
        for (Node node : multiRule.getLhs().getNodes()) {
            Node kernelNode = this.multiNode2kernelNode.get(node);
            multiNodeMapping.put(node, kernelNodeMapping.get(kernelNode));
        }
        return multiNodeMapping;
    }

    private Map<Node, EObject> addMatchContent(Rule parallelRule, Match simpleMatch, Map<Node, Node> copyMap) {
        Edge parallelEdge;
        Node parallelTarget;
        Node parallelSource;
        Node targetNode;
        Node sourceNode;
        String newName;
        Node newParallelNode;
        HenshinFactory factory = HenshinFactory.eINSTANCE;
        HashMap<String, String> oldParameterNames = new HashMap<String, String>();
        HashMap<Node, EObject> partialMatch = new HashMap<Node, EObject>();
        Rule rule = simpleMatch.getRule();
        if (simpleMatch.getRule() == this.amalgamationUnit.getKernelRule()) {
            for (Parameter parameter : rule.getParameters()) {
                Parameter parallelParameter = (Parameter)EcoreUtil.copy((EObject)parameter);
                parallelParameter.setUnit((TransformationUnit)parallelRule);
            }
        } else {
            for (Parameter parameter : rule.getParameters()) {
                String parameterName = parameter.getName();
                if (this.amalgamationUnit.getKernelRule().getParameterByName(parameterName) != null) continue;
                Parameter parallelParameter = (Parameter)EcoreUtil.copy((EObject)parameter);
                parallelParameter.setUnit((TransformationUnit)parallelRule);
                String newName2 = String.valueOf(parameter.getName()) + Math.abs(new Random().nextInt());
                parallelParameter.setName(newName2);
                oldParameterNames.put(newName2, parameterName);
            }
        }
        for (Node node : rule.getLhs().getNodes()) {
            if (this.multiNode2kernelNode.get(node) != null) continue;
            newParallelNode = (Node)EcoreUtil.copy((EObject)node);
            newParallelNode.getOutgoing().clear();
            newParallelNode.getIncoming().clear();
            newParallelNode.setGraph(parallelRule.getLhs());
            copyMap.put(node, newParallelNode);
            partialMatch.put(newParallelNode, simpleMatch.getNodeMapping().get(node));
            for (Attribute attribute : newParallelNode.getAttributes()) {
                for (Parameter parameter : parallelRule.getParameters()) {
                    newName = parameter.getName();
                    if (oldParameterNames.get(newName) == null) continue;
                    ModelHelper.renameParameterInAttribute(attribute, (String)oldParameterNames.get(newName), newName);
                }
            }
        }
        for (Node node : rule.getRhs().getNodes()) {
            if (this.multiNode2kernelNode.get(node) != null) continue;
            newParallelNode = (Node)EcoreUtil.copy((EObject)node);
            newParallelNode.getOutgoing().clear();
            newParallelNode.getIncoming().clear();
            newParallelNode.setGraph(parallelRule.getRhs());
            copyMap.put(node, newParallelNode);
            for (Attribute attribute : newParallelNode.getAttributes()) {
                for (Parameter parameter : parallelRule.getParameters()) {
                    newName = parameter.getName();
                    if (oldParameterNames.get(newName) == null) continue;
                    ModelHelper.renameParameterInAttribute(attribute, (String)oldParameterNames.get(newName), newName);
                }
            }
        }
        for (Mapping mapping : rule.getMappings()) {
            sourceNode = mapping.getOrigin();
            targetNode = mapping.getImage();
            if (targetNode.getGraph() != rule.getRhs() || parallelRule.containsMapping(parallelSource = copyMap.get(sourceNode), parallelTarget = copyMap.get(targetNode))) continue;
            Mapping parallelMapping = factory.createMapping();
            parallelMapping.setOrigin(parallelSource);
            parallelMapping.setImage(parallelTarget);
            parallelRule.getMappings().add((Object)parallelMapping);
        }
        for (Edge edge : rule.getLhs().getEdges()) {
            sourceNode = edge.getSource();
            targetNode = edge.getTarget();
            parallelSource = copyMap.get(sourceNode);
            parallelTarget = copyMap.get(targetNode);
            if (parallelSource == null) {
                parallelSource = copyMap.get(this.multiNode2kernelNode.get(sourceNode));
            }
            if (parallelTarget == null) {
                parallelTarget = copyMap.get(this.multiNode2kernelNode.get(targetNode));
            }
            if (sourceNode.findOutgoingEdgeByType(targetNode, edge.getType()) == null || parallelSource.findOutgoingEdgeByType(parallelTarget, edge.getType()) != null) continue;
            parallelEdge = factory.createEdge();
            parallelEdge.setSource(parallelSource);
            parallelEdge.setTarget(parallelTarget);
            parallelEdge.setType(edge.getType());
            parallelEdge.setGraph(parallelRule.getLhs());
        }
        for (Edge edge : rule.getRhs().getEdges()) {
            sourceNode = edge.getSource();
            targetNode = edge.getTarget();
            parallelSource = copyMap.get(sourceNode);
            parallelTarget = copyMap.get(targetNode);
            if (parallelSource == null) {
                parallelSource = copyMap.get(this.multiNode2kernelNode.get(sourceNode));
            }
            if (parallelTarget == null) {
                parallelTarget = copyMap.get(this.multiNode2kernelNode.get(targetNode));
            }
            if (sourceNode.findOutgoingEdgeByType(targetNode, edge.getType()) == null || parallelSource.findOutgoingEdgeByType(parallelTarget, edge.getType()) != null) continue;
            parallelEdge = factory.createEdge();
            parallelEdge.setSource(parallelSource);
            parallelEdge.setTarget(parallelTarget);
            parallelEdge.setType(edge.getType());
            parallelEdge.setGraph(parallelRule.getRhs());
        }
        return partialMatch;
    }
}

