/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.maps;

import java.util.List;
import org.eclipse.emf.henshin.diagram.edit.maps.EdgeMapEditor;
import org.eclipse.emf.henshin.diagram.edit.maps.NodeMapEditor;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;

public class MappingMapEditor {
    private Rule source;
    private Rule target;
    private NodeMapEditor lhsNodeMapEditor;
    private NodeMapEditor rhsNodeMapEditor;
    private EdgeMapEditor lhsEdgeMapEditor;
    private EdgeMapEditor rhsEdgeMapEditor;

    public MappingMapEditor(Rule source, Rule target, List<Mapping> lhsMappings, List<Mapping> rhsMappings) {
        this.source = source;
        this.target = target;
        this.lhsNodeMapEditor = new NodeMapEditor(source.getLhs(), target.getLhs(), lhsMappings);
        this.rhsNodeMapEditor = new NodeMapEditor(source.getRhs(), target.getRhs(), rhsMappings);
        this.lhsEdgeMapEditor = new EdgeMapEditor(source.getLhs(), target.getLhs(), lhsMappings);
        this.rhsEdgeMapEditor = new EdgeMapEditor(source.getRhs(), target.getRhs(), rhsMappings);
    }

    public void moveMappedNode(Node node) {
        Node opposite = this.getOppositeNode(node);
        Graph graph = node.getGraph();
        if (opposite == null || graph == null) {
            return;
        }
        if (graph.getContainerRule() == this.source) {
            this.target.getMappings().add((Object)this.getLhsRhsMapping(node, opposite));
        } else if (graph.getContainerRule() == this.target) {
            this.source.getMappings().add((Object)this.getLhsRhsMapping(node, opposite));
        }
        if (graph == this.source.getLhs() || graph == this.target.getLhs()) {
            this.rhsNodeMapEditor.move(opposite);
            this.lhsNodeMapEditor.move(node);
        } else if (graph == this.source.getRhs() || graph == this.target.getRhs()) {
            this.rhsNodeMapEditor.move(node);
            this.lhsNodeMapEditor.move(opposite);
        }
        HenshinMappingUtil.removeInvalidMappings((List)this.target.getMappings(), (Graph)this.target.getLhs(), (Graph)this.target.getRhs());
    }

    public void copyMappedNode(Node node) {
        Node copiedNode;
        Node copiedOpposite;
        Node opposite = this.getOppositeNode(node);
        Graph graph = node.getGraph();
        if (opposite == null || graph == null) {
            return;
        }
        if (graph == this.source.getLhs() || graph == this.target.getLhs()) {
            copiedOpposite = this.rhsNodeMapEditor.copy(opposite);
            copiedNode = this.lhsNodeMapEditor.copy(node);
        } else if (graph == this.source.getRhs() || graph == this.target.getRhs()) {
            copiedNode = this.rhsNodeMapEditor.copy(node);
            copiedOpposite = this.lhsNodeMapEditor.copy(opposite);
        } else {
            return;
        }
        Mapping mapping = this.getLhsRhsMapping(node, opposite);
        if (graph.getContainerRule() == this.source) {
            this.copyMapping(mapping, node, opposite, copiedNode, copiedOpposite, this.target);
        } else if (graph.getContainerRule() == this.target) {
            this.copyMapping(mapping, node, opposite, copiedNode, copiedOpposite, this.source);
        }
    }

    public void moveMappedEdge(Edge edge) {
        Rule from;
        Edge opposite = this.getOppositeEdge(edge);
        Graph graph = edge.getGraph();
        if (opposite == null || graph == null) {
            return;
        }
        if (graph == this.source.getLhs() || graph == this.source.getRhs()) {
            from = this.source;
        } else if (graph == this.target.getLhs() || graph == this.target.getRhs()) {
            from = this.target;
        } else {
            return;
        }
        this.copyMappedNode(edge.getSource());
        this.copyMappedNode(edge.getTarget());
        if (graph == from.getLhs()) {
            this.lhsEdgeMapEditor.move(edge);
            this.rhsEdgeMapEditor.move(opposite);
        } else if (graph == from.getRhs()) {
            this.lhsEdgeMapEditor.move(opposite);
            this.rhsEdgeMapEditor.move(edge);
        }
    }

    public void moveMappedElement(Object element) {
        if (element instanceof Node) {
            this.moveMappedNode((Node)element);
        } else if (element instanceof Edge) {
            this.moveMappedEdge((Edge)element);
        }
    }

    public void ensureCompleteness() {
        for (Node node : this.source.getLhs().getNodes()) {
            this.copyNodeToTarget(node);
        }
        for (Edge edge : this.source.getLhs().getEdges()) {
            this.copyEdgeToTarget(edge);
        }
    }

    private void copyNodeToTarget(Node node) {
        if (this.getOppositeNode(node) != null) {
            this.copyMappedNode(node);
        } else if (node.getGraph() == this.source.getLhs()) {
            this.lhsNodeMapEditor.copy(node);
        } else if (node.getGraph() == this.source.getRhs()) {
            this.rhsNodeMapEditor.copy(node);
        }
    }

    private void copyEdgeToTarget(Edge edge) {
        Edge opposite = this.getOppositeEdge(edge);
        if (edge.getGraph() == this.source.getLhs()) {
            this.lhsEdgeMapEditor.copy(edge);
            if (opposite != null) {
                this.rhsEdgeMapEditor.copy(opposite);
            }
        } else if (edge.getGraph() == this.source.getRhs()) {
            this.rhsEdgeMapEditor.copy(edge);
            if (opposite != null) {
                this.lhsEdgeMapEditor.copy(opposite);
            }
        }
    }

    private Node getOppositeNode(Node node) {
        if (node.getGraph().getContainerRule() == this.source) {
            return new NodeMapEditor(this.source.getRhs()).getOpposite(node);
        }
        if (node.getGraph().getContainerRule() == this.target) {
            return new NodeMapEditor(this.target.getRhs()).getOpposite(node);
        }
        return null;
    }

    private Edge getOppositeEdge(Edge edge) {
        if (edge.getGraph().getContainerRule() == this.source) {
            return new EdgeMapEditor(this.source.getRhs()).getOpposite(edge);
        }
        if (edge.getGraph().getContainerRule() == this.target) {
            return new EdgeMapEditor(this.target.getRhs()).getOpposite(edge);
        }
        return null;
    }

    private Mapping getLhsRhsMapping(Node n1, Node n2) {
        Mapping mapping = HenshinMappingUtil.getMapping((Node)n1, (Node)n2, (List)this.source.getMappings());
        if (mapping == null) {
            mapping = HenshinMappingUtil.getMapping((Node)n1, (Node)n2, (List)this.target.getMappings());
        }
        return mapping;
    }

    private void copyMapping(Mapping mapping, Node old1, Node old2, Node new1, Node new2, Rule rule) {
        if (mapping.getOrigin() == old1 && mapping.getImage() == old2) {
            HenshinMappingUtil.createMapping((Node)new1, (Node)new2, (List)rule.getMappings());
        } else if (mapping.getOrigin() == old2 && mapping.getImage() == old1) {
            HenshinMappingUtil.createMapping((Node)new2, (Node)new1, (List)rule.getMappings());
        }
    }
}

