/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.matching.constraints;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.matching.constraints.BinaryConstraint;
import org.eclipse.emf.henshin.matching.constraints.DomainChange;
import org.eclipse.emf.henshin.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.matching.constraints.Variable;

public class ReferenceConstraint
implements BinaryConstraint {
    private EReference reference;
    private Variable target;

    public ReferenceConstraint(Variable target, EReference eReference) {
        this.target = target;
        this.reference = eReference;
    }

    @Override
    public boolean check(DomainSlot source, DomainSlot target) {
        ArrayList<EObject> referredObjects;
        if (!source.locked || source.value.eGet((EStructuralFeature)this.reference) == null) {
            return false;
        }
        if (this.reference.isMany()) {
            referredObjects = (ArrayList<EObject>)source.value.eGet((EStructuralFeature)this.reference);
            if (referredObjects.isEmpty()) {
                return false;
            }
        } else {
            EObject v = (EObject)source.value.eGet((EStructuralFeature)this.reference);
            if (v == null) {
                return false;
            }
            referredObjects = new ArrayList<EObject>(1);
            referredObjects.add(v);
        }
        if (target.locked) {
            return referredObjects.contains(target.value);
        }
        DomainChange change = new DomainChange(target, target.temporaryDomain);
        source.remoteChangeMap.put(this, change);
        target.temporaryDomain = new ArrayList<EObject>(referredObjects);
        if (change.originalValues != null) {
            target.temporaryDomain.retainAll(change.originalValues);
        }
        return !target.temporaryDomain.isEmpty();
    }

    public Variable getTarget() {
        return this.target;
    }
}

