/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.matching.conditions.nested;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.matching.conditions.nested.IFormula;
import org.eclipse.emf.henshin.matching.constraints.DomainSlot;
import org.eclipse.emf.henshin.matching.constraints.Variable;

public class ApplicationCondition
implements IFormula {
    protected boolean negated;
    protected IFormula formula;
    protected EmfGraph graph;
    protected List<Variable> variables;
    protected Map<Variable, DomainSlot> domainMap;

    public ApplicationCondition(EmfGraph graph, Map<Variable, DomainSlot> domainMap, boolean negated) {
        this.domainMap = domainMap;
        this.graph = graph;
        this.negated = negated;
    }

    public boolean findGraph() {
        return this.findMatch(0);
    }

    protected boolean findMatch(int index) {
        if (index == this.variables.size()) {
            return this.formula.eval();
        }
        Variable variable = this.variables.get(index);
        DomainSlot slot = this.domainMap.get(variable);
        boolean validAssignment = false;
        while (!validAssignment) {
            validAssignment = slot.instantiate(variable, this.domainMap, this.graph);
            if (validAssignment) {
                validAssignment = this.findMatch(index + 1);
            }
            if (validAssignment) continue;
            slot.unlock(variable);
            if (slot.instantiationPossible()) continue;
            slot.clear(variable);
            return false;
        }
        return true;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public IFormula getFormula() {
        return this.formula;
    }

    public void setFormula(IFormula formula) {
        this.formula = formula;
    }

    private void resetVariables() {
        for (Variable var : this.variables) {
            this.domainMap.get(var).clear(var);
        }
    }

    @Override
    public boolean eval() {
        boolean result = this.findGraph();
        this.resetVariables();
        return result ? !this.negated : this.negated;
    }
}

