/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpacePlugin;
import org.eclipse.emf.henshin.statespace.external.prism.AbstractPRISMTool;
import org.eclipse.emf.henshin.statespace.external.prism.RatesPropertiesManager;
import org.eclipse.emf.henshin.statespace.validation.StateSpaceXYPlot;
import org.eclipse.emf.henshin.statespace.validation.StateValidator;
import org.eclipse.emf.henshin.statespace.validation.ValidationResult;
import org.eclipse.emf.henshin.statespace.validation.Validator;

public class PRISMStateSpaceValidator
extends AbstractPRISMTool {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.ENGLISH);

    /*
     * WARNING - void declaration
     */
    public ValidationResult validate(StateSpace stateSpace, IProgressMonitor monitor) throws Exception {
        Experiment next;
        monitor.beginTask("Validating CSL property...", -1);
        File cslFile = this.createTempFile("property", ".csl", this.preprocessProperty(this.property, stateSpace, monitor));
        monitor.subTask("Running PRISM...");
        Process process = this.invokePRISM(stateSpace, cslFile, null, true, monitor);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        ArrayList<Experiment> experiments = new ArrayList<Experiment>();
        while ((next = this.parseExperiment(reader, monitor)) != null) {
            experiments.add(next);
            if (!monitor.isCanceled()) continue;
            process.destroy();
            return null;
        }
        if (experiments.isEmpty()) {
            throw new RuntimeException("Unexpected PRISM output");
        }
        if (experiments.size() == 1) {
            return new ValidationResult(true, "Result: " + NUMBER_FORMAT.format(((Experiment)experiments.get((int)0)).result));
        }
        Set<String> parameters = ((Experiment)experiments.get((int)0)).constants.keySet();
        ArrayList<String> changing = new ArrayList<String>();
        block1: for (String param : parameters) {
            int i = 1;
            while (i < experiments.size()) {
                double val2;
                double val1 = ((Experiment)experiments.get((int)(i - 1))).constants.get(param);
                if (val1 != (val2 = ((Experiment)experiments.get((int)i)).constants.get(param).doubleValue())) {
                    changing.add(param);
                    continue block1;
                }
                ++i;
            }
        }
        String variable = (String)changing.get(0);
        String userPreference = RatesPropertiesManager.getPRISMExperiment(stateSpace);
        if (userPreference != null && changing.contains(userPreference)) {
            variable = userPreference;
        }
        ArrayList plots = new ArrayList();
        for (Experiment experiment1 : experiments) {
            boolean found = false;
            for (List list : plots) {
                Experiment experiment2 = (Experiment)list.get(0);
                boolean compatible = true;
                for (String param : parameters) {
                    Double val1 = experiment1.constants.get(param);
                    Double val2 = experiment2.constants.get(param);
                    if (param.equals(variable) || val1.equals(val2)) continue;
                    compatible = false;
                    break;
                }
                if (!compatible) continue;
                list.add(experiment1);
                found = true;
                break;
            }
            if (found) continue;
            plots.add(new ArrayList());
            ((List)plots.get(plots.size() - 1)).add(experiment1);
        }
        double[][] xValues = new double[plots.size()][];
        double[][] yValues = new double[plots.size()][];
        int i = 0;
        while (i < plots.size()) {
            List list = (List)plots.get(i);
            int length = list.size();
            xValues[i] = new double[length];
            yValues[i] = new double[length];
            int j = 0;
            while (j < length) {
                xValues[i][j] = ((Experiment)list.get((int)j)).constants.get(variable);
                yValues[i][j] = ((Experiment)list.get((int)j)).result;
                ++j;
            }
            ++i;
        }
        String[] legend = null;
        if (plots.size() > 1) {
            void var16_26;
            legend = new String[plots.size()];
            boolean bl = false;
            while (var16_26 < legend.length) {
                legend[var16_26] = "";
                for (String param : changing) {
                    if (param.equals(variable)) continue;
                    if (legend[var16_26].length() > 0) {
                        legend[var16_26] = String.valueOf(legend[var16_26]) + ",";
                    }
                    String value = NUMBER_FORMAT.format(((Experiment)experiments.get((int)var16_26)).constants.get(param));
                    legend[var16_26] = String.valueOf(legend[var16_26]) + param + "=" + value;
                }
                ++var16_26;
            }
        }
        StateSpaceXYPlot stateSpaceXYPlot = new StateSpaceXYPlot(variable, "Result", (double[][])xValues, (double[][])yValues, legend);
        return new ValidationResult(true, null, (Object)stateSpaceXYPlot);
    }

    private String preprocessProperty(String property, StateSpace stateSpace, IProgressMonitor monitor) throws Exception {
        while (!monitor.isCanceled()) {
            int start = property.indexOf("<<<");
            if (start < 0) break;
            int end = property.indexOf(">>>", start);
            end = end < 0 ? property.length() : (end += 3);
            String toReplace = property.substring(start, end);
            String type = "";
            int i = 3;
            while (i < toReplace.length()) {
                if (Character.isWhitespace(toReplace.charAt(i))) break;
                type = String.valueOf(type) + toReplace.charAt(i);
                ++i;
            }
            StateValidator validator = null;
            for (Validator v : StateSpacePlugin.INSTANCE.getValidators().values()) {
                if (!v.getName().startsWith(type) || !(v instanceof StateValidator)) continue;
                validator = (StateValidator)v;
                break;
            }
            if (validator == null) {
                throw new RuntimeException("Unknown validator \"" + type + "\"");
            }
            String theProperty = toReplace.substring(3 + type.length(), toReplace.length() - 3).trim();
            validator.setStateSpaceIndex(this.index);
            validator.setProperty(theProperty);
            String result = "";
            NullProgressMonitor nullMonitor = new NullProgressMonitor();
            for (State state : stateSpace.getStates()) {
                if (!validator.validate(state, (IProgressMonitor)nullMonitor).isValid()) continue;
                if (result.length() > 0) {
                    result = String.valueOf(result) + " | ";
                }
                result = String.valueOf(result) + "s=" + state.getIndex();
            }
            if (result.length() == 0) {
                result = "false";
            }
            result = String.valueOf(result) + ";";
            property = String.valueOf(property.substring(0, start)) + result + property.substring(end);
        }
        return property;
    }

    private Experiment parseExperiment(BufferedReader reader, IProgressMonitor monitor) throws Exception {
        Experiment experiment = new Experiment();
        String line = null;
        String error = null;
        boolean parseError = false;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0) {
                if (!parseError) continue;
                throw new RuntimeException(error);
            }
            if (parseError) {
                error = String.valueOf(error) + "\n" + line;
            } else if (line.startsWith("Error")) {
                error = line;
                parseError = true;
            } else if (line.startsWith("Model constants:") && experiment.constants.isEmpty()) {
                String[] constants;
                System.out.println("\n" + line);
                line = line.substring("Model constants:".length()).trim();
                String[] stringArray = constants = line.split(",");
                int n = constants.length;
                int n2 = 0;
                while (n2 < n) {
                    String constant = stringArray[n2];
                    String[] keyval = constant.split("=");
                    if (keyval.length != 2) {
                        throw new RuntimeException("Unexpected PRISM output");
                    }
                    experiment.constants.put(keyval[0], NUMBER_FORMAT.parse(keyval[1]).doubleValue());
                    ++n2;
                }
            } else if (line.startsWith("Result:")) {
                System.out.println(line);
                line = line.substring("Result:".length()).trim();
                experiment.result = NUMBER_FORMAT.parse(line).doubleValue();
                return experiment;
            }
            if (!monitor.isCanceled()) continue;
            return null;
        }
        return null;
    }

    public String getName() {
        return "PRISM";
    }

    public boolean usesProperty() {
        return true;
    }

    public class Experiment {
        public Map<String, Double> constants = new LinkedHashMap<String, Double>();
        public double result = 0.0;
    }
}

