/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.sirius.ui.handlers;

import org.eclipse.amalgam.explorer.contextual.core.ui.view.ExplorerContextualView;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;

public class OpenDiagramHandler
extends AbstractHandler {
    private ISelection _selection;
    private ExplorerContextualView _explorerContextualView;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean init = this.init(event);
        if (init) {
            this.opendiagram();
        }
        return null;
    }

    public void opendiagram() {
        IStructuredSelection structuredSelection = (IStructuredSelection)this._selection;
        DRepresentation representation = (DRepresentation)structuredSelection.getFirstElement();
        boolean listeningToPageSelectionEvents = ExplorerContextualView.isListeningToPageSelectionEvents();
        EObject target = this.getTarget((EObject)representation);
        if (target != null) {
            try {
                if (listeningToPageSelectionEvents) {
                    this._explorerContextualView.deactivateListeningToPageSelectionEvents();
                }
                Session session = SessionManager.INSTANCE.getSession(target);
                IEditorPart iEditorPart = DialectUIManager.INSTANCE.openEditor(session, representation, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                if (listeningToPageSelectionEvents) {
                    this._explorerContextualView.activateListeningToPageSelectionEvents();
                }
            }
        }
    }

    public boolean init(ExecutionEvent event_p) {
        IEvaluationContext evaluationContext;
        Object variable;
        Object applicationContext = event_p.getApplicationContext();
        if (applicationContext instanceof IEvaluationContext && (variable = (evaluationContext = (IEvaluationContext)applicationContext).getVariable("activePart")) instanceof IViewPart && variable instanceof ExplorerContextualView) {
            this._explorerContextualView = (ExplorerContextualView)variable;
            this._selection = this._explorerContextualView.getSite().getSelectionProvider().getSelection();
            return true;
        }
        return false;
    }

    protected EObject getTarget(EObject representation) {
        if (representation instanceof DRepresentation) {
            DSemanticDecorator sDecorator = (DSemanticDecorator)representation;
            return sDecorator.getTarget();
        }
        return null;
    }
}

