/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;

public class EcoreUtil2 {
    public static String defaultPattern = "{1} {0}";

    public static String getUniqueName(EObject namedElement_p, EAttribute attribute_p, String prefix_p, boolean space_p, boolean recursive_p) {
        EObject parent = namedElement_p.eContainer();
        StringBuilder name = new StringBuilder(prefix_p);
        if (space_p) {
            name.append(" ");
        }
        String nameString = name.toString();
        if (parent == null) {
            return nameString;
        }
        EStructuralFeature feature = namedElement_p.eContainingFeature();
        if (recursive_p) {
            EStructuralFeature parentFeature = parent.eContainingFeature();
            while (feature == parentFeature) {
                parent = parent.eContainer();
                parentFeature = parent.eContainingFeature();
            }
        }
        if (feature instanceof EReference && feature.isMany()) {
            boolean isUnique = false;
            ArrayList list = new ArrayList((Collection)parent.eGet(feature));
            list.remove(namedElement_p);
            int i = list.size() + 1;
            name.append(i);
            while (!isUnique) {
                nameString = name.toString();
                isUnique = EcoreUtil2.checkListName(list, nameString, feature, attribute_p);
                if (isUnique) continue;
                if (nameString.endsWith(Integer.valueOf(i).toString())) {
                    name.delete(name.length() - Integer.valueOf(i).toString().length(), name.length());
                }
                name.append(++i);
            }
        }
        return nameString;
    }

    public static String getUniqueName(EObject object_p, EObject container_p, EStructuralFeature feature_p, EAttribute attribute_p, String defaultString_p) {
        String resultName = "";
        if (feature_p == null || feature_p.isMany()) {
            int counter = 0;
            ArrayList siblings = new ArrayList();
            if (feature_p != null) {
                siblings.addAll((Collection)container_p.eGet(feature_p));
            } else {
                siblings.addAll(container_p.eContents());
            }
            siblings.remove(object_p);
            if (siblings != null && !siblings.isEmpty()) {
                ArrayList<String> existingNames = new ArrayList<String>();
                if (attribute_p != null) {
                    for (Object sibling : siblings) {
                        String name;
                        EObject eSibling = (EObject)sibling;
                        Object attributeValue = eSibling.eGet((EStructuralFeature)attribute_p);
                        if (!(attributeValue instanceof String) || (name = (String)attributeValue).equals("")) continue;
                        existingNames.add(name);
                    }
                    counter = siblings.size();
                    while (existingNames.contains(resultName = MessageFormat.format(defaultPattern, ++counter, defaultString_p))) {
                    }
                }
            } else {
                resultName = MessageFormat.format(defaultPattern, ++counter, defaultString_p);
            }
        } else {
            resultName = defaultString_p;
        }
        return resultName;
    }

    private static boolean checkElementName(EObject current_p, String nameString_p, EStructuralFeature feature_p, EAttribute attribute_p) {
        Object name = current_p.eGet((EStructuralFeature)attribute_p);
        return name == null || !name.equals(nameString_p);
    }

    private static boolean checkListName(Collection<? extends EObject> list_p, String nameString_p, EStructuralFeature feature_p, EAttribute attribute_p) {
        Iterator<? extends EObject> elements = list_p.iterator();
        boolean isUnique = true;
        while (elements.hasNext() && isUnique) {
            EObject currentEObject = elements.next();
            isUnique = EcoreUtil2.checkElementName(currentEObject, nameString_p, feature_p, attribute_p);
        }
        return isUnique;
    }

    public static ResourceSet getResourceSet(EObject element_p) {
        Resource resource;
        ResourceSet set = null;
        if (element_p != null && (resource = element_p.eResource()) != null) {
            set = resource.getResourceSet();
        }
        return set;
    }

    public static IFile getFile(Resource resource_p) {
        IFile result = null;
        if (resource_p == null) {
            return result;
        }
        result = WorkspaceSynchronizer.getFile((Resource)resource_p);
        return result;
    }
}

