/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.discovery.ui.common.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.amalgam.discovery.DiscoveryUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class CommonImages {
    private static final URL baseURL = DiscoveryUIPlugin.getDefault().getBundle().getEntry("/icons/full/");
    private static ImageRegistry imageRegistry;
    private static final String T_TOOL = "etool16";
    private static final String T_OBJ = "obj16";
    private static final String T_WIZBAN = "wizban";
    public static final ImageDescriptor BANNER_DISCOVERY;
    public static final ImageDescriptor FIND_CLEAR;
    public static final ImageDescriptor FIND_CLEAR_DISABLED;
    public static final ImageDescriptor IMAGE_PLACEHOLDER;

    static {
        BANNER_DISCOVERY = CommonImages.create(T_WIZBAN, "banner-discovery.png");
        FIND_CLEAR = CommonImages.create(T_TOOL, "find-clear.gif");
        FIND_CLEAR_DISABLED = CommonImages.create(T_TOOL, "find-clear-disabled.gif");
        IMAGE_PLACEHOLDER = CommonImages.create(T_OBJ, "loading.png");
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)CommonImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry imageRegistry = CommonImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage(true);
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }
}

